#!/bin/sh

# Setup env
set -xe
. /environ

# Enter build dir
mkdir /gif; cd /gif

# Download latest
VERSION='5.2.2'
URL="https://sourceforge.net/projects/giflib/files/giflib-${VERSION}.tar.gz/download"
curl -fL "$URL" -o 'giflib.tgz'

# Unpack giflib tar
tar -xvf 'giflib.tgz'
cd giflib-*

# Make our modifications to makefile
sed -i Makefile -e 's|^PREFIX\s*=.*|PREFIX = /vendor|'
sed -i Makefile -e "s|^CFLAGS\s*=.*|CFLAGS = ${CFLAGS}|"

# Perform library build.
make -j $(nproc) libgif.a

# Install headers
cp gif_lib.h \
   /vendor/include

# Install libraries
cp libgif.a \
   /vendor/lib
