use crate::{
    actions::GlobalArgs,
    render::json::JsonToStdout,
    types::{context::BergContext, output::OutputMode},
};

use clap::Parser;
use miette::IntoDiagnostic;

/// Display short summary of the authenticated user account
#[derive(Parser, Debug)]
pub struct ApiVersionArgs {}

impl ApiVersionArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        let ctx = BergContext::new(self, global_args).await?;
        let version = ctx.client.get_version().await.into_diagnostic()?;

        match ctx.global_args.output_mode {
            OutputMode::Pretty => match version.version {
                Some(version) => println!("Version: {version}"),
                None => println!("No version detected"),
            },
            OutputMode::Json => version.print_json()?,
        }

        Ok(())
    }
}
