{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          pullCreateBasic = {
            withChangeBranches = true;
            withRepoSetup = true;
            withAuth = true;
            test = ''
              pull = ${
                testLib.berg_run_json {
                  cmd = ''pull create --title "my first contribution" --target-branch "${sharedLib.main}"'';
                  cdTestRepo = true;
                }
              }

              printj(pull)

              assert pull["title"] == "my first contribution", f"pull title incorrect\ngot:{pull}"
              assert pull["user"]["login"] == "${sharedLib.user}", f"pull user incorrect\ngot:{pull}"
              assert pull["head"]["label"] == "${sharedLib.branch}", f"pull target branch incorrect\ngot:{pull}"
              assert pull["base"]["label"] == "${sharedLib.main}", f"pull base branch incorrect\ngot:{pull}"
              assert pull["state"] == "open", f"pull state incorrect\ngot:{pull}"
            '';
          };
          pullCreateFromMain = {
            withChangeBranches = true;
            withRepoSetup = true;
            withAuth = true;
            test = ''
              forgejo.succeed("cd ${sharedLib.repo}; git switch main")

              pull = ${
                testLib.berg_run_json {
                  cmd = ''pull create --title "my first contribution" --target-branch "${sharedLib.main}" --source-branch ${sharedLib.branch}'';
                  cdTestRepo = true;
                }
              }

              printj(pull)

              assert pull["title"] == "my first contribution", f"pull title incorrect\ngot:{pull}"
              assert pull["user"]["login"] == "${sharedLib.user}", f"pull user incorrect\ngot:{pull}"
              assert pull["head"]["label"] == "${sharedLib.branch}", f"pull target branch incorrect\ngot:{pull}"
              assert pull["base"]["label"] == "${sharedLib.main}", f"pull base branch incorrect\ngot:{pull}"
              assert pull["state"] == "open", f"pull state incorrect\ngot:{pull}"
            '';
          };
          pullCreateFull = {
            withLabels = true;
            withChangeBranches = true;
            withRepoSetup = true;
            withAuth = true;
            test = ''
              pull = ${
                testLib.berg_run_json {
                  cmd = ''pull create --title "my first contribution" --target-branch "${sharedLib.main}" --source-branch ${sharedLib.branch} --description "I have an idea! Look at this, please!" --assignees "${sharedLib.otherUser}" --labels "bug,feat,test"'';
                  cdTestRepo = true;
                }
              }

              printj(pull)

              assert pull["title"] == "my first contribution", f"pull title incorrect\ngot:{pull}"
              assert pull["user"]["login"] == "${sharedLib.user}", f"pull user incorrect\ngot:{pull}"
              assert pull["head"]["label"] == "${sharedLib.branch}", f"pull target branch incorrect\ngot:{pull}"
              assert pull["base"]["label"] == "${sharedLib.main}", f"pull base branch incorrect\ngot:{pull}"
              assert pull["body"] == "I have an idea! Look at this, please!", f"pull body incorrect\ngot:{pull}"
              assert pull["assignees"][0]["login"] == "${sharedLib.otherUser}", f"pull assignees incorrect\ngot:{pull}"
              assert len(pull["labels"]) == 3, f"pull labels number incorrect\ngot:{pull["labels"]}"
              assert pull["state"] == "open", f"pull state incorrect\ngot:{pull}"
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
