// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

package clusterpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Available authorization mode of a Redis cluster.
type AuthorizationMode int32

const (
	// Not set.
	AuthorizationMode_AUTH_MODE_UNSPECIFIED AuthorizationMode = 0
	// IAM basic authorization mode
	AuthorizationMode_AUTH_MODE_IAM_AUTH AuthorizationMode = 1
	// Authorization disabled mode
	AuthorizationMode_AUTH_MODE_DISABLED AuthorizationMode = 2
)

// Enum value maps for AuthorizationMode.
var (
	AuthorizationMode_name = map[int32]string{
		0: "AUTH_MODE_UNSPECIFIED",
		1: "AUTH_MODE_IAM_AUTH",
		2: "AUTH_MODE_DISABLED",
	}
	AuthorizationMode_value = map[string]int32{
		"AUTH_MODE_UNSPECIFIED": 0,
		"AUTH_MODE_IAM_AUTH":    1,
		"AUTH_MODE_DISABLED":    2,
	}
)

func (x AuthorizationMode) Enum() *AuthorizationMode {
	p := new(AuthorizationMode)
	*p = x
	return p
}

func (x AuthorizationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthorizationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[0].Descriptor()
}

func (AuthorizationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[0]
}

func (x AuthorizationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthorizationMode.Descriptor instead.
func (AuthorizationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{0}
}

// NodeType of a redis cluster node,
type NodeType int32

const (
	NodeType_NODE_TYPE_UNSPECIFIED NodeType = 0
	// Redis shared core nano node_type.
	NodeType_REDIS_SHARED_CORE_NANO NodeType = 1
	// Redis highmem medium node_type.
	NodeType_REDIS_HIGHMEM_MEDIUM NodeType = 2
	// Redis highmem xlarge node_type.
	NodeType_REDIS_HIGHMEM_XLARGE NodeType = 3
	// Redis standard small node_type.
	NodeType_REDIS_STANDARD_SMALL NodeType = 4
)

// Enum value maps for NodeType.
var (
	NodeType_name = map[int32]string{
		0: "NODE_TYPE_UNSPECIFIED",
		1: "REDIS_SHARED_CORE_NANO",
		2: "REDIS_HIGHMEM_MEDIUM",
		3: "REDIS_HIGHMEM_XLARGE",
		4: "REDIS_STANDARD_SMALL",
	}
	NodeType_value = map[string]int32{
		"NODE_TYPE_UNSPECIFIED":  0,
		"REDIS_SHARED_CORE_NANO": 1,
		"REDIS_HIGHMEM_MEDIUM":   2,
		"REDIS_HIGHMEM_XLARGE":   3,
		"REDIS_STANDARD_SMALL":   4,
	}
)

func (x NodeType) Enum() *NodeType {
	p := new(NodeType)
	*p = x
	return p
}

func (x NodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[1].Descriptor()
}

func (NodeType) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[1]
}

func (x NodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeType.Descriptor instead.
func (NodeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{1}
}

// Available mode of in-transit encryption.
type TransitEncryptionMode int32

const (
	// In-transit encryption not set.
	TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_UNSPECIFIED TransitEncryptionMode = 0
	// In-transit encryption disabled.
	TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_DISABLED TransitEncryptionMode = 1
	// Use server managed encryption for in-transit encryption.
	TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION TransitEncryptionMode = 2
)

// Enum value maps for TransitEncryptionMode.
var (
	TransitEncryptionMode_name = map[int32]string{
		0: "TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
		1: "TRANSIT_ENCRYPTION_MODE_DISABLED",
		2: "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION",
	}
	TransitEncryptionMode_value = map[string]int32{
		"TRANSIT_ENCRYPTION_MODE_UNSPECIFIED":           0,
		"TRANSIT_ENCRYPTION_MODE_DISABLED":              1,
		"TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION": 2,
	}
)

func (x TransitEncryptionMode) Enum() *TransitEncryptionMode {
	p := new(TransitEncryptionMode)
	*p = x
	return p
}

func (x TransitEncryptionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransitEncryptionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[2].Descriptor()
}

func (TransitEncryptionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[2]
}

func (x TransitEncryptionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransitEncryptionMode.Descriptor instead.
func (TransitEncryptionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{2}
}

// Represents the different states of a Redis cluster.
type Cluster_State int32

const (
	// Not set.
	Cluster_STATE_UNSPECIFIED Cluster_State = 0
	// Redis cluster is being created.
	Cluster_CREATING Cluster_State = 1
	// Redis cluster has been created and is fully usable.
	Cluster_ACTIVE Cluster_State = 2
	// Redis cluster configuration is being updated.
	Cluster_UPDATING Cluster_State = 3
	// Redis cluster is being deleted.
	Cluster_DELETING Cluster_State = 4
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	Cluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[3].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[3]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{7, 0}
}

// Available persistence modes.
type ClusterPersistenceConfig_PersistenceMode int32

const (
	// Not set.
	ClusterPersistenceConfig_PERSISTENCE_MODE_UNSPECIFIED ClusterPersistenceConfig_PersistenceMode = 0
	// Persistence is disabled, and any snapshot data is deleted.
	ClusterPersistenceConfig_DISABLED ClusterPersistenceConfig_PersistenceMode = 1
	// RDB based persistence is enabled.
	ClusterPersistenceConfig_RDB ClusterPersistenceConfig_PersistenceMode = 2
	// AOF based persistence is enabled.
	ClusterPersistenceConfig_AOF ClusterPersistenceConfig_PersistenceMode = 3
)

// Enum value maps for ClusterPersistenceConfig_PersistenceMode.
var (
	ClusterPersistenceConfig_PersistenceMode_name = map[int32]string{
		0: "PERSISTENCE_MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "RDB",
		3: "AOF",
	}
	ClusterPersistenceConfig_PersistenceMode_value = map[string]int32{
		"PERSISTENCE_MODE_UNSPECIFIED": 0,
		"DISABLED":                     1,
		"RDB":                          2,
		"AOF":                          3,
	}
)

func (x ClusterPersistenceConfig_PersistenceMode) Enum() *ClusterPersistenceConfig_PersistenceMode {
	p := new(ClusterPersistenceConfig_PersistenceMode)
	*p = x
	return p
}

func (x ClusterPersistenceConfig_PersistenceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterPersistenceConfig_PersistenceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[4].Descriptor()
}

func (ClusterPersistenceConfig_PersistenceMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[4]
}

func (x ClusterPersistenceConfig_PersistenceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterPersistenceConfig_PersistenceMode.Descriptor instead.
func (ClusterPersistenceConfig_PersistenceMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13, 0}
}

// Available snapshot periods.
type ClusterPersistenceConfig_RDBConfig_SnapshotPeriod int32

const (
	// Not set.
	ClusterPersistenceConfig_RDBConfig_SNAPSHOT_PERIOD_UNSPECIFIED ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 0
	// One hour.
	ClusterPersistenceConfig_RDBConfig_ONE_HOUR ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 1
	// Six hours.
	ClusterPersistenceConfig_RDBConfig_SIX_HOURS ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 2
	// Twelve hours.
	ClusterPersistenceConfig_RDBConfig_TWELVE_HOURS ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 3
	// Twenty four hours.
	ClusterPersistenceConfig_RDBConfig_TWENTY_FOUR_HOURS ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 4
)

// Enum value maps for ClusterPersistenceConfig_RDBConfig_SnapshotPeriod.
var (
	ClusterPersistenceConfig_RDBConfig_SnapshotPeriod_name = map[int32]string{
		0: "SNAPSHOT_PERIOD_UNSPECIFIED",
		1: "ONE_HOUR",
		2: "SIX_HOURS",
		3: "TWELVE_HOURS",
		4: "TWENTY_FOUR_HOURS",
	}
	ClusterPersistenceConfig_RDBConfig_SnapshotPeriod_value = map[string]int32{
		"SNAPSHOT_PERIOD_UNSPECIFIED": 0,
		"ONE_HOUR":                    1,
		"SIX_HOURS":                   2,
		"TWELVE_HOURS":                3,
		"TWENTY_FOUR_HOURS":           4,
	}
)

func (x ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Enum() *ClusterPersistenceConfig_RDBConfig_SnapshotPeriod {
	p := new(ClusterPersistenceConfig_RDBConfig_SnapshotPeriod)
	*p = x
	return p
}

func (x ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[5].Descriptor()
}

func (ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[5]
}

func (x ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterPersistenceConfig_RDBConfig_SnapshotPeriod.Descriptor instead.
func (ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13, 0, 0}
}

// Available fsync modes.
type ClusterPersistenceConfig_AOFConfig_AppendFsync int32

const (
	// Not set. Default: EVERYSEC
	ClusterPersistenceConfig_AOFConfig_APPEND_FSYNC_UNSPECIFIED ClusterPersistenceConfig_AOFConfig_AppendFsync = 0
	// Never fsync. Normally Linux will flush data every 30 seconds with this
	// configuration, but it's up to the kernel's exact tuning.
	ClusterPersistenceConfig_AOFConfig_NO ClusterPersistenceConfig_AOFConfig_AppendFsync = 1
	// fsync every second. Fast enough, and you may lose 1 second of data if
	// there is a disaster
	ClusterPersistenceConfig_AOFConfig_EVERYSEC ClusterPersistenceConfig_AOFConfig_AppendFsync = 2
	// fsync every time new commands are appended to the AOF. It has the best
	// data loss protection at the cost of performance
	ClusterPersistenceConfig_AOFConfig_ALWAYS ClusterPersistenceConfig_AOFConfig_AppendFsync = 3
)

// Enum value maps for ClusterPersistenceConfig_AOFConfig_AppendFsync.
var (
	ClusterPersistenceConfig_AOFConfig_AppendFsync_name = map[int32]string{
		0: "APPEND_FSYNC_UNSPECIFIED",
		1: "NO",
		2: "EVERYSEC",
		3: "ALWAYS",
	}
	ClusterPersistenceConfig_AOFConfig_AppendFsync_value = map[string]int32{
		"APPEND_FSYNC_UNSPECIFIED": 0,
		"NO":                       1,
		"EVERYSEC":                 2,
		"ALWAYS":                   3,
	}
)

func (x ClusterPersistenceConfig_AOFConfig_AppendFsync) Enum() *ClusterPersistenceConfig_AOFConfig_AppendFsync {
	p := new(ClusterPersistenceConfig_AOFConfig_AppendFsync)
	*p = x
	return p
}

func (x ClusterPersistenceConfig_AOFConfig_AppendFsync) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterPersistenceConfig_AOFConfig_AppendFsync) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[6].Descriptor()
}

func (ClusterPersistenceConfig_AOFConfig_AppendFsync) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[6]
}

func (x ClusterPersistenceConfig_AOFConfig_AppendFsync) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterPersistenceConfig_AOFConfig_AppendFsync.Descriptor instead.
func (ClusterPersistenceConfig_AOFConfig_AppendFsync) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13, 1, 0}
}

// Defines various modes of zone distribution.
// Currently supports two modes, can be expanded in future to support more
// types of distribution modes.
// design doc: go/same-zone-cluster
type ZoneDistributionConfig_ZoneDistributionMode int32

const (
	// Not Set. Default: MULTI_ZONE
	ZoneDistributionConfig_ZONE_DISTRIBUTION_MODE_UNSPECIFIED ZoneDistributionConfig_ZoneDistributionMode = 0
	// Distribute all resources across 3 zones picked at random, within the
	// region.
	ZoneDistributionConfig_MULTI_ZONE ZoneDistributionConfig_ZoneDistributionMode = 1
	// Distribute all resources in a single zone. The zone field must be
	// specified, when this mode is selected.
	ZoneDistributionConfig_SINGLE_ZONE ZoneDistributionConfig_ZoneDistributionMode = 2
)

// Enum value maps for ZoneDistributionConfig_ZoneDistributionMode.
var (
	ZoneDistributionConfig_ZoneDistributionMode_name = map[int32]string{
		0: "ZONE_DISTRIBUTION_MODE_UNSPECIFIED",
		1: "MULTI_ZONE",
		2: "SINGLE_ZONE",
	}
	ZoneDistributionConfig_ZoneDistributionMode_value = map[string]int32{
		"ZONE_DISTRIBUTION_MODE_UNSPECIFIED": 0,
		"MULTI_ZONE":                         1,
		"SINGLE_ZONE":                        2,
	}
)

func (x ZoneDistributionConfig_ZoneDistributionMode) Enum() *ZoneDistributionConfig_ZoneDistributionMode {
	p := new(ZoneDistributionConfig_ZoneDistributionMode)
	*p = x
	return p
}

func (x ZoneDistributionConfig_ZoneDistributionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ZoneDistributionConfig_ZoneDistributionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[7].Descriptor()
}

func (ZoneDistributionConfig_ZoneDistributionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[7]
}

func (x ZoneDistributionConfig_ZoneDistributionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ZoneDistributionConfig_ZoneDistributionMode.Descriptor instead.
func (ZoneDistributionConfig_ZoneDistributionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{14, 0}
}

// Request for [CreateCluster][CloudRedis.CreateCluster].
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster location using the form:
	//
	//	`projects/{project_id}/locations/{location_id}`
	//
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis cluster in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The cluster that is to be created.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *CreateClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [ListClusters][CloudRedis.ListClusters].
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster location using the form:
	//
	//	`projects/{project_id}/locations/{location_id}`
	//
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [`next_page_token`][google.cloud.redis.cluster.v1.ListClustersResponse.next_page_token]
	// to determine if there are more clusters left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` value returned from a previous
	// [ListClusters][CloudRedis.ListClusters] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *ListClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for [ListClusters][CloudRedis.ListClusters].
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Redis clusters in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a placeholder
	// Redis entry is included in the response with the `name` field set to a
	// value of the form
	// `projects/{project_id}/locations/{location_id}/clusters/`- and the
	// `status` field set to ERROR and `status_message` field set to "location not
	// available for ListClusters".
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [UpdateCluster][CloudRedis.UpdateCluster].
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Cluster][google.cloud.redis.cluster.v1.Cluster]:
	//
	//   - `size_gb`
	//   - `replica_count`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *UpdateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [GetCluster][CloudRedis.GetCluster].
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *GetClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [DeleteCluster][CloudRedis.DeleteCluster].
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for
// [GetClusterCertificateAuthorityRequest][CloudRedis.GetClusterCertificateAuthorityRequest].
type GetClusterCertificateAuthorityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster certificate authority resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}/certificateAuthority`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterCertificateAuthorityRequest) Reset() {
	*x = GetClusterCertificateAuthorityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterCertificateAuthorityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterCertificateAuthorityRequest) ProtoMessage() {}

func (x *GetClusterCertificateAuthorityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterCertificateAuthorityRequest.ProtoReflect.Descriptor instead.
func (*GetClusterCertificateAuthorityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *GetClusterCertificateAuthorityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A cluster instance.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp associated with the cluster creation request.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this cluster.
	// Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
	State Cluster_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.redis.cluster.v1.Cluster_State" json:"state,omitempty"`
	// Output only. System assigned, unique identifier for the cluster.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The number of replica nodes per shard.
	ReplicaCount *int32 `protobuf:"varint,8,opt,name=replica_count,json=replicaCount,proto3,oneof" json:"replica_count,omitempty"`
	// Optional. The authorization mode of the Redis cluster.
	// If not provided, auth feature is disabled for the cluster.
	AuthorizationMode AuthorizationMode `protobuf:"varint,11,opt,name=authorization_mode,json=authorizationMode,proto3,enum=google.cloud.redis.cluster.v1.AuthorizationMode" json:"authorization_mode,omitempty"`
	// Optional. The in-transit encryption for the Redis cluster.
	// If not provided, encryption  is disabled for the cluster.
	TransitEncryptionMode TransitEncryptionMode `protobuf:"varint,12,opt,name=transit_encryption_mode,json=transitEncryptionMode,proto3,enum=google.cloud.redis.cluster.v1.TransitEncryptionMode" json:"transit_encryption_mode,omitempty"`
	// Output only. Redis memory size in GB for the entire cluster rounded up to
	// the next integer.
	SizeGb *int32 `protobuf:"varint,13,opt,name=size_gb,json=sizeGb,proto3,oneof" json:"size_gb,omitempty"`
	// Required. Number of shards for the Redis cluster.
	ShardCount *int32 `protobuf:"varint,14,opt,name=shard_count,json=shardCount,proto3,oneof" json:"shard_count,omitempty"`
	// Required. Each PscConfig configures the consumer network where IPs will
	// be designated to the cluster for client access through Private Service
	// Connect Automation. Currently, only one PscConfig is supported.
	PscConfigs []*PscConfig `protobuf:"bytes,15,rep,name=psc_configs,json=pscConfigs,proto3" json:"psc_configs,omitempty"`
	// Output only. Endpoints created on each given network, for Redis clients to
	// connect to the cluster. Currently only one discovery endpoint is supported.
	DiscoveryEndpoints []*DiscoveryEndpoint `protobuf:"bytes,16,rep,name=discovery_endpoints,json=discoveryEndpoints,proto3" json:"discovery_endpoints,omitempty"`
	// Output only. PSC connections for discovery of the cluster topology and
	// accessing the cluster.
	PscConnections []*PscConnection `protobuf:"bytes,17,rep,name=psc_connections,json=pscConnections,proto3" json:"psc_connections,omitempty"`
	// Output only. Additional information about the current state of the cluster.
	StateInfo *Cluster_StateInfo `protobuf:"bytes,18,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Optional. The type of a redis node in the cluster. NodeType determines the
	// underlying machine-type of a redis node.
	NodeType NodeType `protobuf:"varint,19,opt,name=node_type,json=nodeType,proto3,enum=google.cloud.redis.cluster.v1.NodeType" json:"node_type,omitempty"`
	// Optional. Persistence config (RDB, AOF) for the cluster.
	PersistenceConfig *ClusterPersistenceConfig `protobuf:"bytes,20,opt,name=persistence_config,json=persistenceConfig,proto3" json:"persistence_config,omitempty"`
	// Optional. Key/Value pairs of customer overrides for mutable Redis Configs
	RedisConfigs map[string]string `protobuf:"bytes,21,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Precise value of redis memory size in GB for the entire
	// cluster.
	PreciseSizeGb *float64 `protobuf:"fixed64,22,opt,name=precise_size_gb,json=preciseSizeGb,proto3,oneof" json:"precise_size_gb,omitempty"`
	// Optional. This config will be used to determine how the customer wants us
	// to distribute cluster resources within the region.
	ZoneDistributionConfig *ZoneDistributionConfig `protobuf:"bytes,23,opt,name=zone_distribution_config,json=zoneDistributionConfig,proto3" json:"zone_distribution_config,omitempty"`
	// Optional. The delete operation will fail when the value is set to true.
	DeletionProtectionEnabled *bool `protobuf:"varint,25,opt,name=deletion_protection_enabled,json=deletionProtectionEnabled,proto3,oneof" json:"deletion_protection_enabled,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_UNSPECIFIED
}

func (x *Cluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Cluster) GetReplicaCount() int32 {
	if x != nil && x.ReplicaCount != nil {
		return *x.ReplicaCount
	}
	return 0
}

func (x *Cluster) GetAuthorizationMode() AuthorizationMode {
	if x != nil {
		return x.AuthorizationMode
	}
	return AuthorizationMode_AUTH_MODE_UNSPECIFIED
}

func (x *Cluster) GetTransitEncryptionMode() TransitEncryptionMode {
	if x != nil {
		return x.TransitEncryptionMode
	}
	return TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_UNSPECIFIED
}

func (x *Cluster) GetSizeGb() int32 {
	if x != nil && x.SizeGb != nil {
		return *x.SizeGb
	}
	return 0
}

func (x *Cluster) GetShardCount() int32 {
	if x != nil && x.ShardCount != nil {
		return *x.ShardCount
	}
	return 0
}

func (x *Cluster) GetPscConfigs() []*PscConfig {
	if x != nil {
		return x.PscConfigs
	}
	return nil
}

func (x *Cluster) GetDiscoveryEndpoints() []*DiscoveryEndpoint {
	if x != nil {
		return x.DiscoveryEndpoints
	}
	return nil
}

func (x *Cluster) GetPscConnections() []*PscConnection {
	if x != nil {
		return x.PscConnections
	}
	return nil
}

func (x *Cluster) GetStateInfo() *Cluster_StateInfo {
	if x != nil {
		return x.StateInfo
	}
	return nil
}

func (x *Cluster) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_NODE_TYPE_UNSPECIFIED
}

func (x *Cluster) GetPersistenceConfig() *ClusterPersistenceConfig {
	if x != nil {
		return x.PersistenceConfig
	}
	return nil
}

func (x *Cluster) GetRedisConfigs() map[string]string {
	if x != nil {
		return x.RedisConfigs
	}
	return nil
}

func (x *Cluster) GetPreciseSizeGb() float64 {
	if x != nil && x.PreciseSizeGb != nil {
		return *x.PreciseSizeGb
	}
	return 0
}

func (x *Cluster) GetZoneDistributionConfig() *ZoneDistributionConfig {
	if x != nil {
		return x.ZoneDistributionConfig
	}
	return nil
}

func (x *Cluster) GetDeletionProtectionEnabled() bool {
	if x != nil && x.DeletionProtectionEnabled != nil {
		return *x.DeletionProtectionEnabled
	}
	return false
}

type PscConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The network where the IP address of the discovery endpoint will
	// be reserved, in the form of
	// projects/{network_project}/global/networks/{network_id}.
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *PscConfig) Reset() {
	*x = PscConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PscConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscConfig) ProtoMessage() {}

func (x *PscConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscConfig.ProtoReflect.Descriptor instead.
func (*PscConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *PscConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Endpoints on each network, for Redis clients to connect to the cluster.
type DiscoveryEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Address of the exposed Redis endpoint used by clients to
	// connect to the service. The address could be either IP or hostname.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. Customer configuration for where the endpoint is created and
	// accessed from.
	PscConfig *PscConfig `protobuf:"bytes,3,opt,name=psc_config,json=pscConfig,proto3" json:"psc_config,omitempty"`
}

func (x *DiscoveryEndpoint) Reset() {
	*x = DiscoveryEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEndpoint) ProtoMessage() {}

func (x *DiscoveryEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEndpoint.ProtoReflect.Descriptor instead.
func (*DiscoveryEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *DiscoveryEndpoint) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *DiscoveryEndpoint) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *DiscoveryEndpoint) GetPscConfig() *PscConfig {
	if x != nil {
		return x.PscConfig
	}
	return nil
}

// Details of consumer resources in a PSC connection.
type PscConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The PSC connection id of the forwarding rule connected to the
	// service attachment.
	PscConnectionId string `protobuf:"bytes,1,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// Output only. The IP allocated on the consumer network for the PSC
	// forwarding rule.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Output only. The URI of the consumer side forwarding rule.
	// Example:
	// projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
	ForwardingRule string `protobuf:"bytes,3,opt,name=forwarding_rule,json=forwardingRule,proto3" json:"forwarding_rule,omitempty"`
	// Output only. The consumer project_id where the forwarding rule is created
	// from.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The consumer network where the IP address resides, in the form of
	// projects/{project_id}/global/networks/{network_id}.
	Network string `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *PscConnection) Reset() {
	*x = PscConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PscConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscConnection) ProtoMessage() {}

func (x *PscConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscConnection.ProtoReflect.Descriptor instead.
func (*PscConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *PscConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *PscConnection) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *PscConnection) GetForwardingRule() string {
	if x != nil {
		return x.ForwardingRule
	}
	return ""
}

func (x *PscConnection) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PscConnection) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Pre-defined metadata fields.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Redis cluster certificate authority
type CertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// server ca information
	//
	// Types that are assignable to ServerCa:
	//
	//	*CertificateAuthority_ManagedServerCa
	ServerCa isCertificateAuthority_ServerCa `protobuf_oneof:"server_ca"`
	// Identifier. Unique name of the resource in this scope including project,
	// location and cluster using the form:
	//
	//	`projects/{project}/locations/{location}/clusters/{cluster}/certificateAuthority`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CertificateAuthority) Reset() {
	*x = CertificateAuthority{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{12}
}

func (m *CertificateAuthority) GetServerCa() isCertificateAuthority_ServerCa {
	if m != nil {
		return m.ServerCa
	}
	return nil
}

func (x *CertificateAuthority) GetManagedServerCa() *CertificateAuthority_ManagedCertificateAuthority {
	if x, ok := x.GetServerCa().(*CertificateAuthority_ManagedServerCa); ok {
		return x.ManagedServerCa
	}
	return nil
}

func (x *CertificateAuthority) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isCertificateAuthority_ServerCa interface {
	isCertificateAuthority_ServerCa()
}

type CertificateAuthority_ManagedServerCa struct {
	ManagedServerCa *CertificateAuthority_ManagedCertificateAuthority `protobuf:"bytes,1,opt,name=managed_server_ca,json=managedServerCa,proto3,oneof"`
}

func (*CertificateAuthority_ManagedServerCa) isCertificateAuthority_ServerCa() {}

// Configuration of the persistence functionality.
type ClusterPersistenceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The mode of persistence.
	Mode ClusterPersistenceConfig_PersistenceMode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.redis.cluster.v1.ClusterPersistenceConfig_PersistenceMode" json:"mode,omitempty"`
	// Optional. RDB configuration. This field will be ignored if mode is not RDB.
	RdbConfig *ClusterPersistenceConfig_RDBConfig `protobuf:"bytes,2,opt,name=rdb_config,json=rdbConfig,proto3" json:"rdb_config,omitempty"`
	// Optional. AOF configuration. This field will be ignored if mode is not AOF.
	AofConfig *ClusterPersistenceConfig_AOFConfig `protobuf:"bytes,3,opt,name=aof_config,json=aofConfig,proto3" json:"aof_config,omitempty"`
}

func (x *ClusterPersistenceConfig) Reset() {
	*x = ClusterPersistenceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterPersistenceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterPersistenceConfig) ProtoMessage() {}

func (x *ClusterPersistenceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterPersistenceConfig.ProtoReflect.Descriptor instead.
func (*ClusterPersistenceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *ClusterPersistenceConfig) GetMode() ClusterPersistenceConfig_PersistenceMode {
	if x != nil {
		return x.Mode
	}
	return ClusterPersistenceConfig_PERSISTENCE_MODE_UNSPECIFIED
}

func (x *ClusterPersistenceConfig) GetRdbConfig() *ClusterPersistenceConfig_RDBConfig {
	if x != nil {
		return x.RdbConfig
	}
	return nil
}

func (x *ClusterPersistenceConfig) GetAofConfig() *ClusterPersistenceConfig_AOFConfig {
	if x != nil {
		return x.AofConfig
	}
	return nil
}

// Zone distribution config for allocation of cluster resources.
type ZoneDistributionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The mode of zone distribution. Defaults to MULTI_ZONE, when not
	// specified.
	Mode ZoneDistributionConfig_ZoneDistributionMode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.redis.cluster.v1.ZoneDistributionConfig_ZoneDistributionMode" json:"mode,omitempty"`
	// Optional. When SINGLE ZONE distribution is selected, zone field would be
	// used to allocate all resources in that zone. This is not applicable to
	// MULTI_ZONE, and would be ignored for MULTI_ZONE clusters.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *ZoneDistributionConfig) Reset() {
	*x = ZoneDistributionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZoneDistributionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZoneDistributionConfig) ProtoMessage() {}

func (x *ZoneDistributionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZoneDistributionConfig.ProtoReflect.Descriptor instead.
func (*ZoneDistributionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{14}
}

func (x *ZoneDistributionConfig) GetMode() ZoneDistributionConfig_ZoneDistributionMode {
	if x != nil {
		return x.Mode
	}
	return ZoneDistributionConfig_ZONE_DISTRIBUTION_MODE_UNSPECIFIED
}

func (x *ZoneDistributionConfig) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Represents additional information about the state of the cluster.
type Cluster_StateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Info:
	//
	//	*Cluster_StateInfo_UpdateInfo_
	Info isCluster_StateInfo_Info `protobuf_oneof:"info"`
}

func (x *Cluster_StateInfo) Reset() {
	*x = Cluster_StateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_StateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_StateInfo) ProtoMessage() {}

func (x *Cluster_StateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_StateInfo.ProtoReflect.Descriptor instead.
func (*Cluster_StateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{7, 0}
}

func (m *Cluster_StateInfo) GetInfo() isCluster_StateInfo_Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (x *Cluster_StateInfo) GetUpdateInfo() *Cluster_StateInfo_UpdateInfo {
	if x, ok := x.GetInfo().(*Cluster_StateInfo_UpdateInfo_); ok {
		return x.UpdateInfo
	}
	return nil
}

type isCluster_StateInfo_Info interface {
	isCluster_StateInfo_Info()
}

type Cluster_StateInfo_UpdateInfo_ struct {
	// Describes ongoing update on the cluster when cluster state is UPDATING.
	UpdateInfo *Cluster_StateInfo_UpdateInfo `protobuf:"bytes,1,opt,name=update_info,json=updateInfo,proto3,oneof"`
}

func (*Cluster_StateInfo_UpdateInfo_) isCluster_StateInfo_Info() {}

// Represents information about an updating cluster.
type Cluster_StateInfo_UpdateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target number of shards for redis cluster
	TargetShardCount *int32 `protobuf:"varint,1,opt,name=target_shard_count,json=targetShardCount,proto3,oneof" json:"target_shard_count,omitempty"`
	// Target number of replica nodes per shard.
	TargetReplicaCount *int32 `protobuf:"varint,2,opt,name=target_replica_count,json=targetReplicaCount,proto3,oneof" json:"target_replica_count,omitempty"`
}

func (x *Cluster_StateInfo_UpdateInfo) Reset() {
	*x = Cluster_StateInfo_UpdateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_StateInfo_UpdateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_StateInfo_UpdateInfo) ProtoMessage() {}

func (x *Cluster_StateInfo_UpdateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_StateInfo_UpdateInfo.ProtoReflect.Descriptor instead.
func (*Cluster_StateInfo_UpdateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{7, 0, 0}
}

func (x *Cluster_StateInfo_UpdateInfo) GetTargetShardCount() int32 {
	if x != nil && x.TargetShardCount != nil {
		return *x.TargetShardCount
	}
	return 0
}

func (x *Cluster_StateInfo_UpdateInfo) GetTargetReplicaCount() int32 {
	if x != nil && x.TargetReplicaCount != nil {
		return *x.TargetReplicaCount
	}
	return 0
}

type CertificateAuthority_ManagedCertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The PEM encoded CA certificate chains for redis managed
	// server authentication
	CaCerts []*CertificateAuthority_ManagedCertificateAuthority_CertChain `protobuf:"bytes,1,rep,name=ca_certs,json=caCerts,proto3" json:"ca_certs,omitempty"`
}

func (x *CertificateAuthority_ManagedCertificateAuthority) Reset() {
	*x = CertificateAuthority_ManagedCertificateAuthority{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_ManagedCertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_ManagedCertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority_ManagedCertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_ManagedCertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_ManagedCertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{12, 0}
}

func (x *CertificateAuthority_ManagedCertificateAuthority) GetCaCerts() []*CertificateAuthority_ManagedCertificateAuthority_CertChain {
	if x != nil {
		return x.CaCerts
	}
	return nil
}

type CertificateAuthority_ManagedCertificateAuthority_CertChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificates that form the CA chain, from leaf to root order.
	Certificates []string `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) Reset() {
	*x = CertificateAuthority_ManagedCertificateAuthority_CertChain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_ManagedCertificateAuthority_CertChain) ProtoMessage() {}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_ManagedCertificateAuthority_CertChain.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_ManagedCertificateAuthority_CertChain) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{12, 0, 0}
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

// Configuration of the RDB based persistence.
type ClusterPersistenceConfig_RDBConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Period between RDB snapshots.
	RdbSnapshotPeriod ClusterPersistenceConfig_RDBConfig_SnapshotPeriod `protobuf:"varint,1,opt,name=rdb_snapshot_period,json=rdbSnapshotPeriod,proto3,enum=google.cloud.redis.cluster.v1.ClusterPersistenceConfig_RDBConfig_SnapshotPeriod" json:"rdb_snapshot_period,omitempty"`
	// Optional. The time that the first snapshot was/will be attempted, and to
	// which future snapshots will be aligned. If not provided, the current time
	// will be used.
	RdbSnapshotStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=rdb_snapshot_start_time,json=rdbSnapshotStartTime,proto3" json:"rdb_snapshot_start_time,omitempty"`
}

func (x *ClusterPersistenceConfig_RDBConfig) Reset() {
	*x = ClusterPersistenceConfig_RDBConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterPersistenceConfig_RDBConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterPersistenceConfig_RDBConfig) ProtoMessage() {}

func (x *ClusterPersistenceConfig_RDBConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterPersistenceConfig_RDBConfig.ProtoReflect.Descriptor instead.
func (*ClusterPersistenceConfig_RDBConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ClusterPersistenceConfig_RDBConfig) GetRdbSnapshotPeriod() ClusterPersistenceConfig_RDBConfig_SnapshotPeriod {
	if x != nil {
		return x.RdbSnapshotPeriod
	}
	return ClusterPersistenceConfig_RDBConfig_SNAPSHOT_PERIOD_UNSPECIFIED
}

func (x *ClusterPersistenceConfig_RDBConfig) GetRdbSnapshotStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RdbSnapshotStartTime
	}
	return nil
}

// Configuration of the AOF based persistence.
type ClusterPersistenceConfig_AOFConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. fsync configuration.
	AppendFsync ClusterPersistenceConfig_AOFConfig_AppendFsync `protobuf:"varint,1,opt,name=append_fsync,json=appendFsync,proto3,enum=google.cloud.redis.cluster.v1.ClusterPersistenceConfig_AOFConfig_AppendFsync" json:"append_fsync,omitempty"`
}

func (x *ClusterPersistenceConfig_AOFConfig) Reset() {
	*x = ClusterPersistenceConfig_AOFConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterPersistenceConfig_AOFConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterPersistenceConfig_AOFConfig) ProtoMessage() {}

func (x *ClusterPersistenceConfig_AOFConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterPersistenceConfig_AOFConfig.ProtoReflect.Descriptor instead.
func (*ClusterPersistenceConfig_AOFConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13, 1}
}

func (x *ClusterPersistenceConfig_AOFConfig) GetAppendFsync() ClusterPersistenceConfig_AOFConfig_AppendFsync {
	if x != nil {
		return x.AppendFsync
	}
	return ClusterPersistenceConfig_AOFConfig_APPEND_FSYNC_UNSPECIFIED
}

var File_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto protoreflect.FileDescriptor

var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x01, 0x0a, 0x14,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x07, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x94, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x42, 0x0a, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0xbe, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x45, 0x0a, 0x07, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x4d, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x6f, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x6e, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x89, 0x10, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x2d, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x64, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x71, 0x0a, 0x17,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x21, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x88,
	0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x0a,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a,
	0x0b, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x66, 0x0a,
	0x13, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x12, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x5a, 0x0a, 0x0f, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x54, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x49, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x6b, 0x0a, 0x12, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x62, 0x0a, 0x0d, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x52,
	0x65, 0x64, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x16, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x03, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x47, 0x62, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x18, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x7a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x1b, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x19, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x88, 0x01, 0x01, 0x1a, 0x9c, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x5e, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x1a, 0xa6, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00,
	0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x06, 0x0a, 0x04,
	0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x3f, 0x0a, 0x11, 0x52, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x5d, 0xea, 0x41, 0x5a,
	0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x65,
	0x63, 0x69, 0x73, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x42, 0x1e, 0x0a, 0x1c,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x2a, 0x0a, 0x09,
	0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x99, 0x01, 0x0a, 0x11, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1d,
	0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x73, 0x63, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xcb, 0x01, 0x0a, 0x0d, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x04, 0x0a, 0x14, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x7d, 0x0a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x00, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0xc4, 0x01, 0x0a, 0x1b,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x74, 0x0a, 0x08, 0x63,
	0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x59, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x07, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74,
	0x73, 0x1a, 0x2f, 0x0a, 0x09, 0x43, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x22,
	0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x29, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x42, 0x0b, 0x0a, 0x09, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61,
	0x22, 0xda, 0x07, 0x0a, 0x18, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x65, 0x0a, 0x0a, 0x72, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x44, 0x42,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x64, 0x62,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x0a, 0x61, 0x6f, 0x66, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x61, 0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xe4, 0x02,
	0x0a, 0x09, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x13,
	0x72, 0x64, 0x62, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x72, 0x64, 0x62, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x56, 0x0a, 0x17, 0x72, 0x64, 0x62, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x72, 0x64, 0x62, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x77, 0x0a, 0x0e, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1f, 0x0a,
	0x1b, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x4f, 0x4e, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x49, 0x58, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x54,
	0x57, 0x45, 0x4c, 0x56, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x03, 0x12, 0x15, 0x0a,
	0x11, 0x54, 0x57, 0x45, 0x4e, 0x54, 0x59, 0x5f, 0x46, 0x4f, 0x55, 0x52, 0x5f, 0x48, 0x4f, 0x55,
	0x52, 0x53, 0x10, 0x04, 0x1a, 0xd1, 0x01, 0x0a, 0x09, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x75, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x66, 0x73, 0x79,
	0x6e, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x70, 0x70, 0x65,
	0x6e, 0x64, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x64, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x22, 0x4d, 0x0a, 0x0b, 0x41, 0x70, 0x70,
	0x65, 0x6e, 0x64, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x50, 0x50, 0x45,
	0x4e, 0x44, 0x5f, 0x46, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x4f, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x56, 0x45, 0x52, 0x59, 0x53, 0x45, 0x43, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x03, 0x22, 0x53, 0x0a, 0x0f, 0x50, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x50,
	0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x52,
	0x44, 0x42, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4f, 0x46, 0x10, 0x03, 0x22, 0xf7, 0x01,
	0x0a, 0x16, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x5a, 0x6f,
	0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x22, 0x5f, 0x0a, 0x14, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x26,
	0x0a, 0x22, 0x5a, 0x4f, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f,
	0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45,
	0x5f, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x02, 0x2a, 0x5e, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x15,
	0x41, 0x55, 0x54, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x55, 0x54, 0x48, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x41, 0x4d, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x01, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x8f, 0x01, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1a, 0x0a, 0x16, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f,
	0x43, 0x4f, 0x52, 0x45, 0x5f, 0x4e, 0x41, 0x4e, 0x4f, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52,
	0x45, 0x44, 0x49, 0x53, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x4d, 0x45, 0x4d, 0x5f, 0x4d, 0x45, 0x44,
	0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x48,
	0x49, 0x47, 0x48, 0x4d, 0x45, 0x4d, 0x5f, 0x58, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x03, 0x12,
	0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52,
	0x44, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10, 0x04, 0x2a, 0x99, 0x01, 0x0a, 0x15, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x45,
	0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x31, 0x0a, 0x2d, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x45, 0x4e,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x32, 0xc4, 0x0a, 0x0a, 0x11, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52,
	0x65, 0x64, 0x69, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0xb6, 0x01, 0x0a, 0x0c,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x3b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x0d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7c, 0xca, 0x41, 0x1e, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x13,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x41, 0x6e, 0x79, 0xda, 0x41, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf,
	0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca, 0x41, 0x2c, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x41, 0x6e, 0x79, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xdf, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0xca, 0x41, 0x1e, 0x0a, 0x07, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12,
	0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x7d, 0x1a, 0x48, 0xca, 0x41, 0x14, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x9e, 0x01, 0x0a,
	0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x42, 0x16, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x70, 0x62, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x64, 0x69, 0x73,
	0x3a, 0x3a, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescOnce sync.Once
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData = file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc
)

func file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP() []byte {
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescOnce.Do(func() {
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData)
	})
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData
}

var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_goTypes = []any{
	(AuthorizationMode)(0),                                   // 0: google.cloud.redis.cluster.v1.AuthorizationMode
	(NodeType)(0),                                            // 1: google.cloud.redis.cluster.v1.NodeType
	(TransitEncryptionMode)(0),                               // 2: google.cloud.redis.cluster.v1.TransitEncryptionMode
	(Cluster_State)(0),                                       // 3: google.cloud.redis.cluster.v1.Cluster.State
	(ClusterPersistenceConfig_PersistenceMode)(0),            // 4: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.PersistenceMode
	(ClusterPersistenceConfig_RDBConfig_SnapshotPeriod)(0),   // 5: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.SnapshotPeriod
	(ClusterPersistenceConfig_AOFConfig_AppendFsync)(0),      // 6: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig.AppendFsync
	(ZoneDistributionConfig_ZoneDistributionMode)(0),         // 7: google.cloud.redis.cluster.v1.ZoneDistributionConfig.ZoneDistributionMode
	(*CreateClusterRequest)(nil),                             // 8: google.cloud.redis.cluster.v1.CreateClusterRequest
	(*ListClustersRequest)(nil),                              // 9: google.cloud.redis.cluster.v1.ListClustersRequest
	(*ListClustersResponse)(nil),                             // 10: google.cloud.redis.cluster.v1.ListClustersResponse
	(*UpdateClusterRequest)(nil),                             // 11: google.cloud.redis.cluster.v1.UpdateClusterRequest
	(*GetClusterRequest)(nil),                                // 12: google.cloud.redis.cluster.v1.GetClusterRequest
	(*DeleteClusterRequest)(nil),                             // 13: google.cloud.redis.cluster.v1.DeleteClusterRequest
	(*GetClusterCertificateAuthorityRequest)(nil),            // 14: google.cloud.redis.cluster.v1.GetClusterCertificateAuthorityRequest
	(*Cluster)(nil),                                          // 15: google.cloud.redis.cluster.v1.Cluster
	(*PscConfig)(nil),                                        // 16: google.cloud.redis.cluster.v1.PscConfig
	(*DiscoveryEndpoint)(nil),                                // 17: google.cloud.redis.cluster.v1.DiscoveryEndpoint
	(*PscConnection)(nil),                                    // 18: google.cloud.redis.cluster.v1.PscConnection
	(*OperationMetadata)(nil),                                // 19: google.cloud.redis.cluster.v1.OperationMetadata
	(*CertificateAuthority)(nil),                             // 20: google.cloud.redis.cluster.v1.CertificateAuthority
	(*ClusterPersistenceConfig)(nil),                         // 21: google.cloud.redis.cluster.v1.ClusterPersistenceConfig
	(*ZoneDistributionConfig)(nil),                           // 22: google.cloud.redis.cluster.v1.ZoneDistributionConfig
	(*Cluster_StateInfo)(nil),                                // 23: google.cloud.redis.cluster.v1.Cluster.StateInfo
	nil,                                                      // 24: google.cloud.redis.cluster.v1.Cluster.RedisConfigsEntry
	(*Cluster_StateInfo_UpdateInfo)(nil),                     // 25: google.cloud.redis.cluster.v1.Cluster.StateInfo.UpdateInfo
	(*CertificateAuthority_ManagedCertificateAuthority)(nil), // 26: google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority
	(*CertificateAuthority_ManagedCertificateAuthority_CertChain)(nil), // 27: google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority.CertChain
	(*ClusterPersistenceConfig_RDBConfig)(nil),                         // 28: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig
	(*ClusterPersistenceConfig_AOFConfig)(nil),                         // 29: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig
	(*fieldmaskpb.FieldMask)(nil),                                      // 30: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                                      // 31: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                                    // 32: google.longrunning.Operation
}
var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_depIdxs = []int32{
	15, // 0: google.cloud.redis.cluster.v1.CreateClusterRequest.cluster:type_name -> google.cloud.redis.cluster.v1.Cluster
	15, // 1: google.cloud.redis.cluster.v1.ListClustersResponse.clusters:type_name -> google.cloud.redis.cluster.v1.Cluster
	30, // 2: google.cloud.redis.cluster.v1.UpdateClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	15, // 3: google.cloud.redis.cluster.v1.UpdateClusterRequest.cluster:type_name -> google.cloud.redis.cluster.v1.Cluster
	31, // 4: google.cloud.redis.cluster.v1.Cluster.create_time:type_name -> google.protobuf.Timestamp
	3,  // 5: google.cloud.redis.cluster.v1.Cluster.state:type_name -> google.cloud.redis.cluster.v1.Cluster.State
	0,  // 6: google.cloud.redis.cluster.v1.Cluster.authorization_mode:type_name -> google.cloud.redis.cluster.v1.AuthorizationMode
	2,  // 7: google.cloud.redis.cluster.v1.Cluster.transit_encryption_mode:type_name -> google.cloud.redis.cluster.v1.TransitEncryptionMode
	16, // 8: google.cloud.redis.cluster.v1.Cluster.psc_configs:type_name -> google.cloud.redis.cluster.v1.PscConfig
	17, // 9: google.cloud.redis.cluster.v1.Cluster.discovery_endpoints:type_name -> google.cloud.redis.cluster.v1.DiscoveryEndpoint
	18, // 10: google.cloud.redis.cluster.v1.Cluster.psc_connections:type_name -> google.cloud.redis.cluster.v1.PscConnection
	23, // 11: google.cloud.redis.cluster.v1.Cluster.state_info:type_name -> google.cloud.redis.cluster.v1.Cluster.StateInfo
	1,  // 12: google.cloud.redis.cluster.v1.Cluster.node_type:type_name -> google.cloud.redis.cluster.v1.NodeType
	21, // 13: google.cloud.redis.cluster.v1.Cluster.persistence_config:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig
	24, // 14: google.cloud.redis.cluster.v1.Cluster.redis_configs:type_name -> google.cloud.redis.cluster.v1.Cluster.RedisConfigsEntry
	22, // 15: google.cloud.redis.cluster.v1.Cluster.zone_distribution_config:type_name -> google.cloud.redis.cluster.v1.ZoneDistributionConfig
	16, // 16: google.cloud.redis.cluster.v1.DiscoveryEndpoint.psc_config:type_name -> google.cloud.redis.cluster.v1.PscConfig
	31, // 17: google.cloud.redis.cluster.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 18: google.cloud.redis.cluster.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	26, // 19: google.cloud.redis.cluster.v1.CertificateAuthority.managed_server_ca:type_name -> google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority
	4,  // 20: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.mode:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.PersistenceMode
	28, // 21: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.rdb_config:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig
	29, // 22: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.aof_config:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig
	7,  // 23: google.cloud.redis.cluster.v1.ZoneDistributionConfig.mode:type_name -> google.cloud.redis.cluster.v1.ZoneDistributionConfig.ZoneDistributionMode
	25, // 24: google.cloud.redis.cluster.v1.Cluster.StateInfo.update_info:type_name -> google.cloud.redis.cluster.v1.Cluster.StateInfo.UpdateInfo
	27, // 25: google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority.ca_certs:type_name -> google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority.CertChain
	5,  // 26: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.rdb_snapshot_period:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.SnapshotPeriod
	31, // 27: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.rdb_snapshot_start_time:type_name -> google.protobuf.Timestamp
	6,  // 28: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig.append_fsync:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig.AppendFsync
	9,  // 29: google.cloud.redis.cluster.v1.CloudRedisCluster.ListClusters:input_type -> google.cloud.redis.cluster.v1.ListClustersRequest
	12, // 30: google.cloud.redis.cluster.v1.CloudRedisCluster.GetCluster:input_type -> google.cloud.redis.cluster.v1.GetClusterRequest
	11, // 31: google.cloud.redis.cluster.v1.CloudRedisCluster.UpdateCluster:input_type -> google.cloud.redis.cluster.v1.UpdateClusterRequest
	13, // 32: google.cloud.redis.cluster.v1.CloudRedisCluster.DeleteCluster:input_type -> google.cloud.redis.cluster.v1.DeleteClusterRequest
	8,  // 33: google.cloud.redis.cluster.v1.CloudRedisCluster.CreateCluster:input_type -> google.cloud.redis.cluster.v1.CreateClusterRequest
	14, // 34: google.cloud.redis.cluster.v1.CloudRedisCluster.GetClusterCertificateAuthority:input_type -> google.cloud.redis.cluster.v1.GetClusterCertificateAuthorityRequest
	10, // 35: google.cloud.redis.cluster.v1.CloudRedisCluster.ListClusters:output_type -> google.cloud.redis.cluster.v1.ListClustersResponse
	15, // 36: google.cloud.redis.cluster.v1.CloudRedisCluster.GetCluster:output_type -> google.cloud.redis.cluster.v1.Cluster
	32, // 37: google.cloud.redis.cluster.v1.CloudRedisCluster.UpdateCluster:output_type -> google.longrunning.Operation
	32, // 38: google.cloud.redis.cluster.v1.CloudRedisCluster.DeleteCluster:output_type -> google.longrunning.Operation
	32, // 39: google.cloud.redis.cluster.v1.CloudRedisCluster.CreateCluster:output_type -> google.longrunning.Operation
	20, // 40: google.cloud.redis.cluster.v1.CloudRedisCluster.GetClusterCertificateAuthority:output_type -> google.cloud.redis.cluster.v1.CertificateAuthority
	35, // [35:41] is the sub-list for method output_type
	29, // [29:35] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_init() }
func file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_init() {
	if File_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*CreateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ListClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*GetClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*GetClusterCertificateAuthorityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*PscConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DiscoveryEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*PscConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*CertificateAuthority); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterPersistenceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*ZoneDistributionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_StateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_StateInfo_UpdateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*CertificateAuthority_ManagedCertificateAuthority); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*CertificateAuthority_ManagedCertificateAuthority_CertChain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterPersistenceConfig_RDBConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterPersistenceConfig_AOFConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[12].OneofWrappers = []any{
		(*CertificateAuthority_ManagedServerCa)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15].OneofWrappers = []any{
		(*Cluster_StateInfo_UpdateInfo_)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_goTypes,
		DependencyIndexes: file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_depIdxs,
		EnumInfos:         file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes,
		MessageInfos:      file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes,
	}.Build()
	File_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto = out.File
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc = nil
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_goTypes = nil
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudRedisClusterClient is the client API for CloudRedisCluster service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClusterClient interface {
	// Lists all Redis clusters owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific Redis cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Updates the metadata and configuration of a specific Redis cluster.
	//
	// Completed longrunning.Operation will contain the new cluster object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a specific Redis cluster. Cluster stops serving and data is
	// deleted.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Redis cluster based on the specified properties.
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// cluster will be fully functional. The completed longrunning.Operation will
	// contain the new cluster object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of certificate authority information for Redis cluster.
	GetClusterCertificateAuthority(ctx context.Context, in *GetClusterCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error)
}

type cloudRedisClusterClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudRedisClusterClient(cc grpc.ClientConnInterface) CloudRedisClusterClient {
	return &cloudRedisClusterClient{cc}
}

func (c *cloudRedisClusterClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetClusterCertificateAuthority(ctx context.Context, in *GetClusterCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error) {
	out := new(CertificateAuthority)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetClusterCertificateAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisClusterServer is the server API for CloudRedisCluster service.
type CloudRedisClusterServer interface {
	// Lists all Redis clusters owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific Redis cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Updates the metadata and configuration of a specific Redis cluster.
	//
	// Completed longrunning.Operation will contain the new cluster object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a specific Redis cluster. Cluster stops serving and data is
	// deleted.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Creates a Redis cluster based on the specified properties.
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// cluster will be fully functional. The completed longrunning.Operation will
	// contain the new cluster object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Gets the details of certificate authority information for Redis cluster.
	GetClusterCertificateAuthority(context.Context, *GetClusterCertificateAuthorityRequest) (*CertificateAuthority, error)
}

// UnimplementedCloudRedisClusterServer can be embedded to have forward compatible implementations.
type UnimplementedCloudRedisClusterServer struct {
}

func (*UnimplementedCloudRedisClusterServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedCloudRedisClusterServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) GetClusterCertificateAuthority(context.Context, *GetClusterCertificateAuthorityRequest) (*CertificateAuthority, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterCertificateAuthority not implemented")
}

func RegisterCloudRedisClusterServer(s *grpc.Server, srv CloudRedisClusterServer) {
	s.RegisterService(&_CloudRedisCluster_serviceDesc, srv)
}

func _CloudRedisCluster_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetClusterCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetClusterCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetClusterCertificateAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetClusterCertificateAuthority(ctx, req.(*GetClusterCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedisCluster_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.cluster.v1.CloudRedisCluster",
	HandlerType: (*CloudRedisClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _CloudRedisCluster_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _CloudRedisCluster_GetCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _CloudRedisCluster_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _CloudRedisCluster_DeleteCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _CloudRedisCluster_CreateCluster_Handler,
		},
		{
			MethodName: "GetClusterCertificateAuthority",
			Handler:    _CloudRedisCluster_GetClusterCertificateAuthority_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/cluster/v1/cloud_redis_cluster.proto",
}
