// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/devtools/artifactregistry/v1/repository.proto

package artifactregistrypb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Statuses applying to versions.
type CleanupPolicyCondition_TagState int32

const (
	// Tag status not specified.
	CleanupPolicyCondition_TAG_STATE_UNSPECIFIED CleanupPolicyCondition_TagState = 0
	// Applies to tagged versions only.
	CleanupPolicyCondition_TAGGED CleanupPolicyCondition_TagState = 1
	// Applies to untagged versions only.
	CleanupPolicyCondition_UNTAGGED CleanupPolicyCondition_TagState = 2
	// Applies to all versions.
	CleanupPolicyCondition_ANY CleanupPolicyCondition_TagState = 3
)

// Enum value maps for CleanupPolicyCondition_TagState.
var (
	CleanupPolicyCondition_TagState_name = map[int32]string{
		0: "TAG_STATE_UNSPECIFIED",
		1: "TAGGED",
		2: "UNTAGGED",
		3: "ANY",
	}
	CleanupPolicyCondition_TagState_value = map[string]int32{
		"TAG_STATE_UNSPECIFIED": 0,
		"TAGGED":                1,
		"UNTAGGED":              2,
		"ANY":                   3,
	}
)

func (x CleanupPolicyCondition_TagState) Enum() *CleanupPolicyCondition_TagState {
	p := new(CleanupPolicyCondition_TagState)
	*p = x
	return p
}

func (x CleanupPolicyCondition_TagState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CleanupPolicyCondition_TagState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[0].Descriptor()
}

func (CleanupPolicyCondition_TagState) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[0]
}

func (x CleanupPolicyCondition_TagState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CleanupPolicyCondition_TagState.Descriptor instead.
func (CleanupPolicyCondition_TagState) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{1, 0}
}

// Action type for a cleanup policy.
type CleanupPolicy_Action int32

const (
	// Action not specified.
	CleanupPolicy_ACTION_UNSPECIFIED CleanupPolicy_Action = 0
	// Delete action.
	CleanupPolicy_DELETE CleanupPolicy_Action = 1
	// Keep action.
	CleanupPolicy_KEEP CleanupPolicy_Action = 2
)

// Enum value maps for CleanupPolicy_Action.
var (
	CleanupPolicy_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "DELETE",
		2: "KEEP",
	}
	CleanupPolicy_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"DELETE":             1,
		"KEEP":               2,
	}
)

func (x CleanupPolicy_Action) Enum() *CleanupPolicy_Action {
	p := new(CleanupPolicy_Action)
	*p = x
	return p
}

func (x CleanupPolicy_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CleanupPolicy_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[1].Descriptor()
}

func (CleanupPolicy_Action) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[1]
}

func (x CleanupPolicy_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CleanupPolicy_Action.Descriptor instead.
func (CleanupPolicy_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{3, 0}
}

// Predefined list of publicly available Docker repositories like Docker
// Hub.
type RemoteRepositoryConfig_DockerRepository_PublicRepository int32

const (
	// Unspecified repository.
	RemoteRepositoryConfig_DockerRepository_PUBLIC_REPOSITORY_UNSPECIFIED RemoteRepositoryConfig_DockerRepository_PublicRepository = 0
	// Docker Hub.
	RemoteRepositoryConfig_DockerRepository_DOCKER_HUB RemoteRepositoryConfig_DockerRepository_PublicRepository = 1
)

// Enum value maps for RemoteRepositoryConfig_DockerRepository_PublicRepository.
var (
	RemoteRepositoryConfig_DockerRepository_PublicRepository_name = map[int32]string{
		0: "PUBLIC_REPOSITORY_UNSPECIFIED",
		1: "DOCKER_HUB",
	}
	RemoteRepositoryConfig_DockerRepository_PublicRepository_value = map[string]int32{
		"PUBLIC_REPOSITORY_UNSPECIFIED": 0,
		"DOCKER_HUB":                    1,
	}
)

func (x RemoteRepositoryConfig_DockerRepository_PublicRepository) Enum() *RemoteRepositoryConfig_DockerRepository_PublicRepository {
	p := new(RemoteRepositoryConfig_DockerRepository_PublicRepository)
	*p = x
	return p
}

func (x RemoteRepositoryConfig_DockerRepository_PublicRepository) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteRepositoryConfig_DockerRepository_PublicRepository) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[2].Descriptor()
}

func (RemoteRepositoryConfig_DockerRepository_PublicRepository) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[2]
}

func (x RemoteRepositoryConfig_DockerRepository_PublicRepository) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteRepositoryConfig_DockerRepository_PublicRepository.Descriptor instead.
func (RemoteRepositoryConfig_DockerRepository_PublicRepository) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 1, 0}
}

// Predefined list of publicly available Maven repositories like Maven
// Central.
type RemoteRepositoryConfig_MavenRepository_PublicRepository int32

const (
	// Unspecified repository.
	RemoteRepositoryConfig_MavenRepository_PUBLIC_REPOSITORY_UNSPECIFIED RemoteRepositoryConfig_MavenRepository_PublicRepository = 0
	// Maven Central.
	RemoteRepositoryConfig_MavenRepository_MAVEN_CENTRAL RemoteRepositoryConfig_MavenRepository_PublicRepository = 1
)

// Enum value maps for RemoteRepositoryConfig_MavenRepository_PublicRepository.
var (
	RemoteRepositoryConfig_MavenRepository_PublicRepository_name = map[int32]string{
		0: "PUBLIC_REPOSITORY_UNSPECIFIED",
		1: "MAVEN_CENTRAL",
	}
	RemoteRepositoryConfig_MavenRepository_PublicRepository_value = map[string]int32{
		"PUBLIC_REPOSITORY_UNSPECIFIED": 0,
		"MAVEN_CENTRAL":                 1,
	}
)

func (x RemoteRepositoryConfig_MavenRepository_PublicRepository) Enum() *RemoteRepositoryConfig_MavenRepository_PublicRepository {
	p := new(RemoteRepositoryConfig_MavenRepository_PublicRepository)
	*p = x
	return p
}

func (x RemoteRepositoryConfig_MavenRepository_PublicRepository) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteRepositoryConfig_MavenRepository_PublicRepository) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[3].Descriptor()
}

func (RemoteRepositoryConfig_MavenRepository_PublicRepository) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[3]
}

func (x RemoteRepositoryConfig_MavenRepository_PublicRepository) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteRepositoryConfig_MavenRepository_PublicRepository.Descriptor instead.
func (RemoteRepositoryConfig_MavenRepository_PublicRepository) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 2, 0}
}

// Predefined list of publicly available NPM repositories like npmjs.
type RemoteRepositoryConfig_NpmRepository_PublicRepository int32

const (
	// Unspecified repository.
	RemoteRepositoryConfig_NpmRepository_PUBLIC_REPOSITORY_UNSPECIFIED RemoteRepositoryConfig_NpmRepository_PublicRepository = 0
	// npmjs.
	RemoteRepositoryConfig_NpmRepository_NPMJS RemoteRepositoryConfig_NpmRepository_PublicRepository = 1
)

// Enum value maps for RemoteRepositoryConfig_NpmRepository_PublicRepository.
var (
	RemoteRepositoryConfig_NpmRepository_PublicRepository_name = map[int32]string{
		0: "PUBLIC_REPOSITORY_UNSPECIFIED",
		1: "NPMJS",
	}
	RemoteRepositoryConfig_NpmRepository_PublicRepository_value = map[string]int32{
		"PUBLIC_REPOSITORY_UNSPECIFIED": 0,
		"NPMJS":                         1,
	}
)

func (x RemoteRepositoryConfig_NpmRepository_PublicRepository) Enum() *RemoteRepositoryConfig_NpmRepository_PublicRepository {
	p := new(RemoteRepositoryConfig_NpmRepository_PublicRepository)
	*p = x
	return p
}

func (x RemoteRepositoryConfig_NpmRepository_PublicRepository) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteRepositoryConfig_NpmRepository_PublicRepository) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[4].Descriptor()
}

func (RemoteRepositoryConfig_NpmRepository_PublicRepository) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[4]
}

func (x RemoteRepositoryConfig_NpmRepository_PublicRepository) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteRepositoryConfig_NpmRepository_PublicRepository.Descriptor instead.
func (RemoteRepositoryConfig_NpmRepository_PublicRepository) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 3, 0}
}

// Predefined list of publicly available Python repositories like PyPI.org.
type RemoteRepositoryConfig_PythonRepository_PublicRepository int32

const (
	// Unspecified repository.
	RemoteRepositoryConfig_PythonRepository_PUBLIC_REPOSITORY_UNSPECIFIED RemoteRepositoryConfig_PythonRepository_PublicRepository = 0
	// PyPI.
	RemoteRepositoryConfig_PythonRepository_PYPI RemoteRepositoryConfig_PythonRepository_PublicRepository = 1
)

// Enum value maps for RemoteRepositoryConfig_PythonRepository_PublicRepository.
var (
	RemoteRepositoryConfig_PythonRepository_PublicRepository_name = map[int32]string{
		0: "PUBLIC_REPOSITORY_UNSPECIFIED",
		1: "PYPI",
	}
	RemoteRepositoryConfig_PythonRepository_PublicRepository_value = map[string]int32{
		"PUBLIC_REPOSITORY_UNSPECIFIED": 0,
		"PYPI":                          1,
	}
)

func (x RemoteRepositoryConfig_PythonRepository_PublicRepository) Enum() *RemoteRepositoryConfig_PythonRepository_PublicRepository {
	p := new(RemoteRepositoryConfig_PythonRepository_PublicRepository)
	*p = x
	return p
}

func (x RemoteRepositoryConfig_PythonRepository_PublicRepository) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteRepositoryConfig_PythonRepository_PublicRepository) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[5].Descriptor()
}

func (RemoteRepositoryConfig_PythonRepository_PublicRepository) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[5]
}

func (x RemoteRepositoryConfig_PythonRepository_PublicRepository) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteRepositoryConfig_PythonRepository_PublicRepository.Descriptor instead.
func (RemoteRepositoryConfig_PythonRepository_PublicRepository) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 4, 0}
}

// Predefined list of publicly available repository bases for Apt.
type RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase int32

const (
	// Unspecified repository base.
	RemoteRepositoryConfig_AptRepository_PublicRepository_REPOSITORY_BASE_UNSPECIFIED RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase = 0
	// Debian.
	RemoteRepositoryConfig_AptRepository_PublicRepository_DEBIAN RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase = 1
	// Ubuntu LTS/Pro.
	RemoteRepositoryConfig_AptRepository_PublicRepository_UBUNTU RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase = 2
)

// Enum value maps for RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase.
var (
	RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase_name = map[int32]string{
		0: "REPOSITORY_BASE_UNSPECIFIED",
		1: "DEBIAN",
		2: "UBUNTU",
	}
	RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase_value = map[string]int32{
		"REPOSITORY_BASE_UNSPECIFIED": 0,
		"DEBIAN":                      1,
		"UBUNTU":                      2,
	}
)

func (x RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase) Enum() *RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase {
	p := new(RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase)
	*p = x
	return p
}

func (x RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[6].Descriptor()
}

func (RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[6]
}

func (x RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase.Descriptor instead.
func (RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 5, 0, 0}
}

// Predefined list of publicly available repository bases for Yum.
type RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase int32

const (
	// Unspecified repository base.
	RemoteRepositoryConfig_YumRepository_PublicRepository_REPOSITORY_BASE_UNSPECIFIED RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 0
	// CentOS.
	RemoteRepositoryConfig_YumRepository_PublicRepository_CENTOS RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 1
	// CentOS Debug.
	RemoteRepositoryConfig_YumRepository_PublicRepository_CENTOS_DEBUG RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 2
	// CentOS Vault.
	RemoteRepositoryConfig_YumRepository_PublicRepository_CENTOS_VAULT RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 3
	// CentOS Stream.
	RemoteRepositoryConfig_YumRepository_PublicRepository_CENTOS_STREAM RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 4
	// Rocky.
	RemoteRepositoryConfig_YumRepository_PublicRepository_ROCKY RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 5
	// Fedora Extra Packages for Enterprise Linux (EPEL).
	RemoteRepositoryConfig_YumRepository_PublicRepository_EPEL RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase = 6
)

// Enum value maps for RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase.
var (
	RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase_name = map[int32]string{
		0: "REPOSITORY_BASE_UNSPECIFIED",
		1: "CENTOS",
		2: "CENTOS_DEBUG",
		3: "CENTOS_VAULT",
		4: "CENTOS_STREAM",
		5: "ROCKY",
		6: "EPEL",
	}
	RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase_value = map[string]int32{
		"REPOSITORY_BASE_UNSPECIFIED": 0,
		"CENTOS":                      1,
		"CENTOS_DEBUG":                2,
		"CENTOS_VAULT":                3,
		"CENTOS_STREAM":               4,
		"ROCKY":                       5,
		"EPEL":                        6,
	}
)

func (x RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase) Enum() *RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase {
	p := new(RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase)
	*p = x
	return p
}

func (x RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[7].Descriptor()
}

func (RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[7]
}

func (x RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase.Descriptor instead.
func (RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 6, 0, 0}
}

// A package format.
type Repository_Format int32

const (
	// Unspecified package format.
	Repository_FORMAT_UNSPECIFIED Repository_Format = 0
	// Docker package format.
	Repository_DOCKER Repository_Format = 1
	// Maven package format.
	Repository_MAVEN Repository_Format = 2
	// NPM package format.
	Repository_NPM Repository_Format = 3
	// APT package format.
	Repository_APT Repository_Format = 5
	// YUM package format.
	Repository_YUM Repository_Format = 6
	// Python package format.
	Repository_PYTHON Repository_Format = 8
	// Kubeflow Pipelines package format.
	Repository_KFP Repository_Format = 9
	// Go package format.
	Repository_GO Repository_Format = 10
)

// Enum value maps for Repository_Format.
var (
	Repository_Format_name = map[int32]string{
		0:  "FORMAT_UNSPECIFIED",
		1:  "DOCKER",
		2:  "MAVEN",
		3:  "NPM",
		5:  "APT",
		6:  "YUM",
		8:  "PYTHON",
		9:  "KFP",
		10: "GO",
	}
	Repository_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"DOCKER":             1,
		"MAVEN":              2,
		"NPM":                3,
		"APT":                5,
		"YUM":                6,
		"PYTHON":             8,
		"KFP":                9,
		"GO":                 10,
	}
)

func (x Repository_Format) Enum() *Repository_Format {
	p := new(Repository_Format)
	*p = x
	return p
}

func (x Repository_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Repository_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[8].Descriptor()
}

func (Repository_Format) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[8]
}

func (x Repository_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Repository_Format.Descriptor instead.
func (Repository_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{6, 0}
}

// The mode configures the repository to serve artifacts from different
// sources.
type Repository_Mode int32

const (
	// Unspecified mode.
	Repository_MODE_UNSPECIFIED Repository_Mode = 0
	// A standard repository storing artifacts.
	Repository_STANDARD_REPOSITORY Repository_Mode = 1
	// A virtual repository to serve artifacts from one or more sources.
	Repository_VIRTUAL_REPOSITORY Repository_Mode = 2
	// A remote repository to serve artifacts from a remote source.
	Repository_REMOTE_REPOSITORY Repository_Mode = 3
)

// Enum value maps for Repository_Mode.
var (
	Repository_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "STANDARD_REPOSITORY",
		2: "VIRTUAL_REPOSITORY",
		3: "REMOTE_REPOSITORY",
	}
	Repository_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED":    0,
		"STANDARD_REPOSITORY": 1,
		"VIRTUAL_REPOSITORY":  2,
		"REMOTE_REPOSITORY":   3,
	}
)

func (x Repository_Mode) Enum() *Repository_Mode {
	p := new(Repository_Mode)
	*p = x
	return p
}

func (x Repository_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Repository_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[9].Descriptor()
}

func (Repository_Mode) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[9]
}

func (x Repository_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Repository_Mode.Descriptor instead.
func (Repository_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{6, 1}
}

// VersionPolicy is the version policy for the repository.
type Repository_MavenRepositoryConfig_VersionPolicy int32

const (
	// VERSION_POLICY_UNSPECIFIED - the version policy is not defined.
	// When the version policy is not defined, no validation is performed
	// for the versions.
	Repository_MavenRepositoryConfig_VERSION_POLICY_UNSPECIFIED Repository_MavenRepositoryConfig_VersionPolicy = 0
	// RELEASE - repository will accept only Release versions.
	Repository_MavenRepositoryConfig_RELEASE Repository_MavenRepositoryConfig_VersionPolicy = 1
	// SNAPSHOT - repository will accept only Snapshot versions.
	Repository_MavenRepositoryConfig_SNAPSHOT Repository_MavenRepositoryConfig_VersionPolicy = 2
)

// Enum value maps for Repository_MavenRepositoryConfig_VersionPolicy.
var (
	Repository_MavenRepositoryConfig_VersionPolicy_name = map[int32]string{
		0: "VERSION_POLICY_UNSPECIFIED",
		1: "RELEASE",
		2: "SNAPSHOT",
	}
	Repository_MavenRepositoryConfig_VersionPolicy_value = map[string]int32{
		"VERSION_POLICY_UNSPECIFIED": 0,
		"RELEASE":                    1,
		"SNAPSHOT":                   2,
	}
)

func (x Repository_MavenRepositoryConfig_VersionPolicy) Enum() *Repository_MavenRepositoryConfig_VersionPolicy {
	p := new(Repository_MavenRepositoryConfig_VersionPolicy)
	*p = x
	return p
}

func (x Repository_MavenRepositoryConfig_VersionPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Repository_MavenRepositoryConfig_VersionPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[10].Descriptor()
}

func (Repository_MavenRepositoryConfig_VersionPolicy) Type() protoreflect.EnumType {
	return &file_google_devtools_artifactregistry_v1_repository_proto_enumTypes[10]
}

func (x Repository_MavenRepositoryConfig_VersionPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Repository_MavenRepositoryConfig_VersionPolicy.Descriptor instead.
func (Repository_MavenRepositoryConfig_VersionPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{6, 0, 0}
}

// Artifact policy configuration for the repository contents.
type UpstreamPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user-provided ID of the upstream policy.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A reference to the repository resource, for example:
	// `projects/p1/locations/us-central1/repositories/repo1`.
	Repository string `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Entries with a greater priority value take precedence in the pull order.
	Priority int32 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *UpstreamPolicy) Reset() {
	*x = UpstreamPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamPolicy) ProtoMessage() {}

func (x *UpstreamPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamPolicy.ProtoReflect.Descriptor instead.
func (*UpstreamPolicy) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{0}
}

func (x *UpstreamPolicy) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UpstreamPolicy) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *UpstreamPolicy) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// CleanupPolicyCondition is a set of conditions attached to a CleanupPolicy.
// If multiple entries are set, all must be satisfied for the condition to be
// satisfied.
type CleanupPolicyCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Match versions by tag status.
	TagState *CleanupPolicyCondition_TagState `protobuf:"varint,2,opt,name=tag_state,json=tagState,proto3,enum=google.devtools.artifactregistry.v1.CleanupPolicyCondition_TagState,oneof" json:"tag_state,omitempty"`
	// Match versions by tag prefix. Applied on any prefix match.
	TagPrefixes []string `protobuf:"bytes,3,rep,name=tag_prefixes,json=tagPrefixes,proto3" json:"tag_prefixes,omitempty"`
	// Match versions by version name prefix. Applied on any prefix match.
	VersionNamePrefixes []string `protobuf:"bytes,4,rep,name=version_name_prefixes,json=versionNamePrefixes,proto3" json:"version_name_prefixes,omitempty"`
	// Match versions by package prefix. Applied on any prefix match.
	PackageNamePrefixes []string `protobuf:"bytes,5,rep,name=package_name_prefixes,json=packageNamePrefixes,proto3" json:"package_name_prefixes,omitempty"`
	// Match versions older than a duration.
	OlderThan *durationpb.Duration `protobuf:"bytes,6,opt,name=older_than,json=olderThan,proto3,oneof" json:"older_than,omitempty"`
	// Match versions newer than a duration.
	NewerThan *durationpb.Duration `protobuf:"bytes,7,opt,name=newer_than,json=newerThan,proto3,oneof" json:"newer_than,omitempty"`
}

func (x *CleanupPolicyCondition) Reset() {
	*x = CleanupPolicyCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CleanupPolicyCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CleanupPolicyCondition) ProtoMessage() {}

func (x *CleanupPolicyCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CleanupPolicyCondition.ProtoReflect.Descriptor instead.
func (*CleanupPolicyCondition) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{1}
}

func (x *CleanupPolicyCondition) GetTagState() CleanupPolicyCondition_TagState {
	if x != nil && x.TagState != nil {
		return *x.TagState
	}
	return CleanupPolicyCondition_TAG_STATE_UNSPECIFIED
}

func (x *CleanupPolicyCondition) GetTagPrefixes() []string {
	if x != nil {
		return x.TagPrefixes
	}
	return nil
}

func (x *CleanupPolicyCondition) GetVersionNamePrefixes() []string {
	if x != nil {
		return x.VersionNamePrefixes
	}
	return nil
}

func (x *CleanupPolicyCondition) GetPackageNamePrefixes() []string {
	if x != nil {
		return x.PackageNamePrefixes
	}
	return nil
}

func (x *CleanupPolicyCondition) GetOlderThan() *durationpb.Duration {
	if x != nil {
		return x.OlderThan
	}
	return nil
}

func (x *CleanupPolicyCondition) GetNewerThan() *durationpb.Duration {
	if x != nil {
		return x.NewerThan
	}
	return nil
}

// CleanupPolicyMostRecentVersions is an alternate condition of a CleanupPolicy
// for retaining a minimum number of versions.
type CleanupPolicyMostRecentVersions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of package name prefixes that will apply this rule.
	PackageNamePrefixes []string `protobuf:"bytes,1,rep,name=package_name_prefixes,json=packageNamePrefixes,proto3" json:"package_name_prefixes,omitempty"`
	// Minimum number of versions to keep.
	KeepCount *int32 `protobuf:"varint,2,opt,name=keep_count,json=keepCount,proto3,oneof" json:"keep_count,omitempty"`
}

func (x *CleanupPolicyMostRecentVersions) Reset() {
	*x = CleanupPolicyMostRecentVersions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CleanupPolicyMostRecentVersions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CleanupPolicyMostRecentVersions) ProtoMessage() {}

func (x *CleanupPolicyMostRecentVersions) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CleanupPolicyMostRecentVersions.ProtoReflect.Descriptor instead.
func (*CleanupPolicyMostRecentVersions) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{2}
}

func (x *CleanupPolicyMostRecentVersions) GetPackageNamePrefixes() []string {
	if x != nil {
		return x.PackageNamePrefixes
	}
	return nil
}

func (x *CleanupPolicyMostRecentVersions) GetKeepCount() int32 {
	if x != nil && x.KeepCount != nil {
		return *x.KeepCount
	}
	return 0
}

// Artifact policy configuration for repository cleanup policies.
type CleanupPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ConditionType:
	//
	//	*CleanupPolicy_Condition
	//	*CleanupPolicy_MostRecentVersions
	ConditionType isCleanupPolicy_ConditionType `protobuf_oneof:"condition_type"`
	// The user-provided ID of the cleanup policy.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Policy action.
	Action CleanupPolicy_Action `protobuf:"varint,3,opt,name=action,proto3,enum=google.devtools.artifactregistry.v1.CleanupPolicy_Action" json:"action,omitempty"`
}

func (x *CleanupPolicy) Reset() {
	*x = CleanupPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CleanupPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CleanupPolicy) ProtoMessage() {}

func (x *CleanupPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CleanupPolicy.ProtoReflect.Descriptor instead.
func (*CleanupPolicy) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{3}
}

func (m *CleanupPolicy) GetConditionType() isCleanupPolicy_ConditionType {
	if m != nil {
		return m.ConditionType
	}
	return nil
}

func (x *CleanupPolicy) GetCondition() *CleanupPolicyCondition {
	if x, ok := x.GetConditionType().(*CleanupPolicy_Condition); ok {
		return x.Condition
	}
	return nil
}

func (x *CleanupPolicy) GetMostRecentVersions() *CleanupPolicyMostRecentVersions {
	if x, ok := x.GetConditionType().(*CleanupPolicy_MostRecentVersions); ok {
		return x.MostRecentVersions
	}
	return nil
}

func (x *CleanupPolicy) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CleanupPolicy) GetAction() CleanupPolicy_Action {
	if x != nil {
		return x.Action
	}
	return CleanupPolicy_ACTION_UNSPECIFIED
}

type isCleanupPolicy_ConditionType interface {
	isCleanupPolicy_ConditionType()
}

type CleanupPolicy_Condition struct {
	// Policy condition for matching versions.
	Condition *CleanupPolicyCondition `protobuf:"bytes,2,opt,name=condition,proto3,oneof"`
}

type CleanupPolicy_MostRecentVersions struct {
	// Policy condition for retaining a minimum number of versions. May only be
	// specified with a Keep action.
	MostRecentVersions *CleanupPolicyMostRecentVersions `protobuf:"bytes,4,opt,name=most_recent_versions,json=mostRecentVersions,proto3,oneof"`
}

func (*CleanupPolicy_Condition) isCleanupPolicy_ConditionType() {}

func (*CleanupPolicy_MostRecentVersions) isCleanupPolicy_ConditionType() {}

// Virtual repository configuration.
type VirtualRepositoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Policies that configure the upstream artifacts distributed by the Virtual
	// Repository. Upstream policies cannot be set on a standard repository.
	UpstreamPolicies []*UpstreamPolicy `protobuf:"bytes,1,rep,name=upstream_policies,json=upstreamPolicies,proto3" json:"upstream_policies,omitempty"`
}

func (x *VirtualRepositoryConfig) Reset() {
	*x = VirtualRepositoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VirtualRepositoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualRepositoryConfig) ProtoMessage() {}

func (x *VirtualRepositoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualRepositoryConfig.ProtoReflect.Descriptor instead.
func (*VirtualRepositoryConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{4}
}

func (x *VirtualRepositoryConfig) GetUpstreamPolicies() []*UpstreamPolicy {
	if x != nil {
		return x.UpstreamPolicies
	}
	return nil
}

// Remote repository configuration.
type RemoteRepositoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings specific to the remote repository.
	//
	// Types that are assignable to RemoteSource:
	//
	//	*RemoteRepositoryConfig_DockerRepository_
	//	*RemoteRepositoryConfig_MavenRepository_
	//	*RemoteRepositoryConfig_NpmRepository_
	//	*RemoteRepositoryConfig_PythonRepository_
	//	*RemoteRepositoryConfig_AptRepository_
	//	*RemoteRepositoryConfig_YumRepository_
	RemoteSource isRemoteRepositoryConfig_RemoteSource `protobuf_oneof:"remote_source"`
	// The description of the remote source.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The credentials used to access the remote repository.
	UpstreamCredentials *RemoteRepositoryConfig_UpstreamCredentials `protobuf:"bytes,9,opt,name=upstream_credentials,json=upstreamCredentials,proto3" json:"upstream_credentials,omitempty"`
}

func (x *RemoteRepositoryConfig) Reset() {
	*x = RemoteRepositoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig) ProtoMessage() {}

func (x *RemoteRepositoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5}
}

func (m *RemoteRepositoryConfig) GetRemoteSource() isRemoteRepositoryConfig_RemoteSource {
	if m != nil {
		return m.RemoteSource
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetDockerRepository() *RemoteRepositoryConfig_DockerRepository {
	if x, ok := x.GetRemoteSource().(*RemoteRepositoryConfig_DockerRepository_); ok {
		return x.DockerRepository
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetMavenRepository() *RemoteRepositoryConfig_MavenRepository {
	if x, ok := x.GetRemoteSource().(*RemoteRepositoryConfig_MavenRepository_); ok {
		return x.MavenRepository
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetNpmRepository() *RemoteRepositoryConfig_NpmRepository {
	if x, ok := x.GetRemoteSource().(*RemoteRepositoryConfig_NpmRepository_); ok {
		return x.NpmRepository
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetPythonRepository() *RemoteRepositoryConfig_PythonRepository {
	if x, ok := x.GetRemoteSource().(*RemoteRepositoryConfig_PythonRepository_); ok {
		return x.PythonRepository
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetAptRepository() *RemoteRepositoryConfig_AptRepository {
	if x, ok := x.GetRemoteSource().(*RemoteRepositoryConfig_AptRepository_); ok {
		return x.AptRepository
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetYumRepository() *RemoteRepositoryConfig_YumRepository {
	if x, ok := x.GetRemoteSource().(*RemoteRepositoryConfig_YumRepository_); ok {
		return x.YumRepository
	}
	return nil
}

func (x *RemoteRepositoryConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RemoteRepositoryConfig) GetUpstreamCredentials() *RemoteRepositoryConfig_UpstreamCredentials {
	if x != nil {
		return x.UpstreamCredentials
	}
	return nil
}

type isRemoteRepositoryConfig_RemoteSource interface {
	isRemoteRepositoryConfig_RemoteSource()
}

type RemoteRepositoryConfig_DockerRepository_ struct {
	// Specific settings for a Docker remote repository.
	DockerRepository *RemoteRepositoryConfig_DockerRepository `protobuf:"bytes,2,opt,name=docker_repository,json=dockerRepository,proto3,oneof"`
}

type RemoteRepositoryConfig_MavenRepository_ struct {
	// Specific settings for a Maven remote repository.
	MavenRepository *RemoteRepositoryConfig_MavenRepository `protobuf:"bytes,3,opt,name=maven_repository,json=mavenRepository,proto3,oneof"`
}

type RemoteRepositoryConfig_NpmRepository_ struct {
	// Specific settings for an Npm remote repository.
	NpmRepository *RemoteRepositoryConfig_NpmRepository `protobuf:"bytes,4,opt,name=npm_repository,json=npmRepository,proto3,oneof"`
}

type RemoteRepositoryConfig_PythonRepository_ struct {
	// Specific settings for a Python remote repository.
	PythonRepository *RemoteRepositoryConfig_PythonRepository `protobuf:"bytes,5,opt,name=python_repository,json=pythonRepository,proto3,oneof"`
}

type RemoteRepositoryConfig_AptRepository_ struct {
	// Specific settings for an Apt remote repository.
	AptRepository *RemoteRepositoryConfig_AptRepository `protobuf:"bytes,6,opt,name=apt_repository,json=aptRepository,proto3,oneof"`
}

type RemoteRepositoryConfig_YumRepository_ struct {
	// Specific settings for a Yum remote repository.
	YumRepository *RemoteRepositoryConfig_YumRepository `protobuf:"bytes,7,opt,name=yum_repository,json=yumRepository,proto3,oneof"`
}

func (*RemoteRepositoryConfig_DockerRepository_) isRemoteRepositoryConfig_RemoteSource() {}

func (*RemoteRepositoryConfig_MavenRepository_) isRemoteRepositoryConfig_RemoteSource() {}

func (*RemoteRepositoryConfig_NpmRepository_) isRemoteRepositoryConfig_RemoteSource() {}

func (*RemoteRepositoryConfig_PythonRepository_) isRemoteRepositoryConfig_RemoteSource() {}

func (*RemoteRepositoryConfig_AptRepository_) isRemoteRepositoryConfig_RemoteSource() {}

func (*RemoteRepositoryConfig_YumRepository_) isRemoteRepositoryConfig_RemoteSource() {}

// A Repository for storing artifacts with a specific format.
type Repository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Repository-specific configurations.
	//
	// Types that are assignable to FormatConfig:
	//
	//	*Repository_MavenConfig
	//	*Repository_DockerConfig
	FormatConfig isRepository_FormatConfig `protobuf_oneof:"format_config"`
	// Repository configuration specific to the Mode value being selected (Remote
	// or Virtual)
	//
	// Types that are assignable to ModeConfig:
	//
	//	*Repository_VirtualRepositoryConfig
	//	*Repository_RemoteRepositoryConfig
	ModeConfig isRepository_ModeConfig `protobuf_oneof:"mode_config"`
	// The name of the repository, for example:
	// `projects/p1/locations/us-central1/repositories/repo1`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The format of packages that are stored in the repository.
	Format Repository_Format `protobuf:"varint,2,opt,name=format,proto3,enum=google.devtools.artifactregistry.v1.Repository_Format" json:"format,omitempty"`
	// The user-provided description of the repository.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Labels with user-defined metadata.
	// This field may contain up to 64 entries. Label keys and values may be no
	// longer than 63 characters. Label keys must begin with a lowercase letter
	// and may only contain lowercase letters, numeric characters, underscores,
	// and dashes.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time when the repository was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the repository was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The Cloud KMS resource name of the customer managed encryption key that's
	// used to encrypt the contents of the Repository. Has the form:
	// `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
	// This value may not be changed after the Repository has been created.
	KmsKeyName string `protobuf:"bytes,8,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Optional. The mode of the repository.
	Mode Repository_Mode `protobuf:"varint,10,opt,name=mode,proto3,enum=google.devtools.artifactregistry.v1.Repository_Mode" json:"mode,omitempty"`
	// Optional. Cleanup policies for this repository. Cleanup policies indicate
	// when certain package versions can be automatically deleted. Map keys are
	// policy IDs supplied by users during policy creation. They must unique
	// within a repository and be under 128 characters in length.
	CleanupPolicies map[string]*CleanupPolicy `protobuf:"bytes,12,rep,name=cleanup_policies,json=cleanupPolicies,proto3" json:"cleanup_policies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The size, in bytes, of all artifact storage in this
	// repository. Repositories that are generally available or in public preview
	//
	//	use this to calculate storage costs.
	SizeBytes int64 `protobuf:"varint,13,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. If set, the repository satisfies physical zone separation.
	SatisfiesPzs bool `protobuf:"varint,16,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Optional. If true, the cleanup pipeline is prevented from deleting versions
	// in this repository.
	CleanupPolicyDryRun bool `protobuf:"varint,18,opt,name=cleanup_policy_dry_run,json=cleanupPolicyDryRun,proto3" json:"cleanup_policy_dry_run,omitempty"`
}

func (x *Repository) Reset() {
	*x = Repository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository) ProtoMessage() {}

func (x *Repository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository.ProtoReflect.Descriptor instead.
func (*Repository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{6}
}

func (m *Repository) GetFormatConfig() isRepository_FormatConfig {
	if m != nil {
		return m.FormatConfig
	}
	return nil
}

func (x *Repository) GetMavenConfig() *Repository_MavenRepositoryConfig {
	if x, ok := x.GetFormatConfig().(*Repository_MavenConfig); ok {
		return x.MavenConfig
	}
	return nil
}

func (x *Repository) GetDockerConfig() *Repository_DockerRepositoryConfig {
	if x, ok := x.GetFormatConfig().(*Repository_DockerConfig); ok {
		return x.DockerConfig
	}
	return nil
}

func (m *Repository) GetModeConfig() isRepository_ModeConfig {
	if m != nil {
		return m.ModeConfig
	}
	return nil
}

func (x *Repository) GetVirtualRepositoryConfig() *VirtualRepositoryConfig {
	if x, ok := x.GetModeConfig().(*Repository_VirtualRepositoryConfig); ok {
		return x.VirtualRepositoryConfig
	}
	return nil
}

func (x *Repository) GetRemoteRepositoryConfig() *RemoteRepositoryConfig {
	if x, ok := x.GetModeConfig().(*Repository_RemoteRepositoryConfig); ok {
		return x.RemoteRepositoryConfig
	}
	return nil
}

func (x *Repository) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Repository) GetFormat() Repository_Format {
	if x != nil {
		return x.Format
	}
	return Repository_FORMAT_UNSPECIFIED
}

func (x *Repository) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Repository) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Repository) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Repository) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Repository) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Repository) GetMode() Repository_Mode {
	if x != nil {
		return x.Mode
	}
	return Repository_MODE_UNSPECIFIED
}

func (x *Repository) GetCleanupPolicies() map[string]*CleanupPolicy {
	if x != nil {
		return x.CleanupPolicies
	}
	return nil
}

func (x *Repository) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *Repository) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Repository) GetCleanupPolicyDryRun() bool {
	if x != nil {
		return x.CleanupPolicyDryRun
	}
	return false
}

type isRepository_FormatConfig interface {
	isRepository_FormatConfig()
}

type Repository_MavenConfig struct {
	// Maven repository config contains repository level configuration
	// for the repositories of maven type.
	MavenConfig *Repository_MavenRepositoryConfig `protobuf:"bytes,9,opt,name=maven_config,json=mavenConfig,proto3,oneof"`
}

type Repository_DockerConfig struct {
	// Docker repository config contains repository level configuration
	// for the repositories of docker type.
	DockerConfig *Repository_DockerRepositoryConfig `protobuf:"bytes,17,opt,name=docker_config,json=dockerConfig,proto3,oneof"`
}

func (*Repository_MavenConfig) isRepository_FormatConfig() {}

func (*Repository_DockerConfig) isRepository_FormatConfig() {}

type isRepository_ModeConfig interface {
	isRepository_ModeConfig()
}

type Repository_VirtualRepositoryConfig struct {
	// Configuration specific for a Virtual Repository.
	VirtualRepositoryConfig *VirtualRepositoryConfig `protobuf:"bytes,14,opt,name=virtual_repository_config,json=virtualRepositoryConfig,proto3,oneof"`
}

type Repository_RemoteRepositoryConfig struct {
	// Configuration specific for a Remote Repository.
	RemoteRepositoryConfig *RemoteRepositoryConfig `protobuf:"bytes,15,opt,name=remote_repository_config,json=remoteRepositoryConfig,proto3,oneof"`
}

func (*Repository_VirtualRepositoryConfig) isRepository_ModeConfig() {}

func (*Repository_RemoteRepositoryConfig) isRepository_ModeConfig() {}

// The request to list repositories.
type ListRepositoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent resource whose repositories will be
	// listed.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of repositories to return. Maximum page size is 1,000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRepositoriesRequest) Reset() {
	*x = ListRepositoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesRequest) ProtoMessage() {}

func (x *ListRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRepositoriesRequest.ProtoReflect.Descriptor instead.
func (*ListRepositoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{7}
}

func (x *ListRepositoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRepositoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from listing repositories.
type ListRepositoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repositories returned.
	Repositories []*Repository `protobuf:"bytes,1,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// The token to retrieve the next page of repositories, or empty if there are
	// no more repositories to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRepositoriesResponse) Reset() {
	*x = ListRepositoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesResponse) ProtoMessage() {}

func (x *ListRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRepositoriesResponse.ProtoReflect.Descriptor instead.
func (*ListRepositoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{8}
}

func (x *ListRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *ListRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to retrieve a repository.
type GetRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the repository to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRepositoryRequest) Reset() {
	*x = GetRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryRequest) ProtoMessage() {}

func (x *GetRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRepositoryRequest.ProtoReflect.Descriptor instead.
func (*GetRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{9}
}

func (x *GetRepositoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to create a new repository.
type CreateRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent resource where the repository will be
	// created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The repository id to use for this repository.
	RepositoryId string `protobuf:"bytes,2,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// Required. The repository to be created.
	Repository *Repository `protobuf:"bytes,3,opt,name=repository,proto3" json:"repository,omitempty"`
}

func (x *CreateRepositoryRequest) Reset() {
	*x = CreateRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryRequest) ProtoMessage() {}

func (x *CreateRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRepositoryRequest.ProtoReflect.Descriptor instead.
func (*CreateRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{10}
}

func (x *CreateRepositoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRepositoryRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *CreateRepositoryRequest) GetRepository() *Repository {
	if x != nil {
		return x.Repository
	}
	return nil
}

// The request to update a repository.
type UpdateRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repository that replaces the resource on the server.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRepositoryRequest) Reset() {
	*x = UpdateRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositoryRequest) ProtoMessage() {}

func (x *UpdateRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRepositoryRequest.ProtoReflect.Descriptor instead.
func (*UpdateRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateRepositoryRequest) GetRepository() *Repository {
	if x != nil {
		return x.Repository
	}
	return nil
}

func (x *UpdateRepositoryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a repository.
type DeleteRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the repository to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRepositoryRequest) Reset() {
	*x = DeleteRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryRequest) ProtoMessage() {}

func (x *DeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRepositoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteRepositoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The credentials to access the remote repository.
type RemoteRepositoryConfig_UpstreamCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Credentials:
	//
	//	*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials_
	Credentials isRemoteRepositoryConfig_UpstreamCredentials_Credentials `protobuf_oneof:"credentials"`
}

func (x *RemoteRepositoryConfig_UpstreamCredentials) Reset() {
	*x = RemoteRepositoryConfig_UpstreamCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_UpstreamCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_UpstreamCredentials) ProtoMessage() {}

func (x *RemoteRepositoryConfig_UpstreamCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_UpstreamCredentials.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_UpstreamCredentials) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 0}
}

func (m *RemoteRepositoryConfig_UpstreamCredentials) GetCredentials() isRemoteRepositoryConfig_UpstreamCredentials_Credentials {
	if m != nil {
		return m.Credentials
	}
	return nil
}

func (x *RemoteRepositoryConfig_UpstreamCredentials) GetUsernamePasswordCredentials() *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials {
	if x, ok := x.GetCredentials().(*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials_); ok {
		return x.UsernamePasswordCredentials
	}
	return nil
}

type isRemoteRepositoryConfig_UpstreamCredentials_Credentials interface {
	isRemoteRepositoryConfig_UpstreamCredentials_Credentials()
}

type RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials_ struct {
	// Use username and password to access the remote repository.
	UsernamePasswordCredentials *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials `protobuf:"bytes,1,opt,name=username_password_credentials,json=usernamePasswordCredentials,proto3,oneof"`
}

func (*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials_) isRemoteRepositoryConfig_UpstreamCredentials_Credentials() {
}

// Configuration for a Docker remote repository.
type RemoteRepositoryConfig_DockerRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the remote repository.
	//
	// Types that are assignable to Upstream:
	//
	//	*RemoteRepositoryConfig_DockerRepository_PublicRepository_
	Upstream isRemoteRepositoryConfig_DockerRepository_Upstream `protobuf_oneof:"upstream"`
}

func (x *RemoteRepositoryConfig_DockerRepository) Reset() {
	*x = RemoteRepositoryConfig_DockerRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_DockerRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_DockerRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_DockerRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_DockerRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_DockerRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 1}
}

func (m *RemoteRepositoryConfig_DockerRepository) GetUpstream() isRemoteRepositoryConfig_DockerRepository_Upstream {
	if m != nil {
		return m.Upstream
	}
	return nil
}

func (x *RemoteRepositoryConfig_DockerRepository) GetPublicRepository() RemoteRepositoryConfig_DockerRepository_PublicRepository {
	if x, ok := x.GetUpstream().(*RemoteRepositoryConfig_DockerRepository_PublicRepository_); ok {
		return x.PublicRepository
	}
	return RemoteRepositoryConfig_DockerRepository_PUBLIC_REPOSITORY_UNSPECIFIED
}

type isRemoteRepositoryConfig_DockerRepository_Upstream interface {
	isRemoteRepositoryConfig_DockerRepository_Upstream()
}

type RemoteRepositoryConfig_DockerRepository_PublicRepository_ struct {
	// One of the publicly available Docker repositories supported by Artifact
	// Registry.
	PublicRepository RemoteRepositoryConfig_DockerRepository_PublicRepository `protobuf:"varint,1,opt,name=public_repository,json=publicRepository,proto3,enum=google.devtools.artifactregistry.v1.RemoteRepositoryConfig_DockerRepository_PublicRepository,oneof"`
}

func (*RemoteRepositoryConfig_DockerRepository_PublicRepository_) isRemoteRepositoryConfig_DockerRepository_Upstream() {
}

// Configuration for a Maven remote repository.
type RemoteRepositoryConfig_MavenRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the remote repository.
	//
	// Types that are assignable to Upstream:
	//
	//	*RemoteRepositoryConfig_MavenRepository_PublicRepository_
	Upstream isRemoteRepositoryConfig_MavenRepository_Upstream `protobuf_oneof:"upstream"`
}

func (x *RemoteRepositoryConfig_MavenRepository) Reset() {
	*x = RemoteRepositoryConfig_MavenRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_MavenRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_MavenRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_MavenRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_MavenRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_MavenRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 2}
}

func (m *RemoteRepositoryConfig_MavenRepository) GetUpstream() isRemoteRepositoryConfig_MavenRepository_Upstream {
	if m != nil {
		return m.Upstream
	}
	return nil
}

func (x *RemoteRepositoryConfig_MavenRepository) GetPublicRepository() RemoteRepositoryConfig_MavenRepository_PublicRepository {
	if x, ok := x.GetUpstream().(*RemoteRepositoryConfig_MavenRepository_PublicRepository_); ok {
		return x.PublicRepository
	}
	return RemoteRepositoryConfig_MavenRepository_PUBLIC_REPOSITORY_UNSPECIFIED
}

type isRemoteRepositoryConfig_MavenRepository_Upstream interface {
	isRemoteRepositoryConfig_MavenRepository_Upstream()
}

type RemoteRepositoryConfig_MavenRepository_PublicRepository_ struct {
	// One of the publicly available Maven repositories supported by Artifact
	// Registry.
	PublicRepository RemoteRepositoryConfig_MavenRepository_PublicRepository `protobuf:"varint,1,opt,name=public_repository,json=publicRepository,proto3,enum=google.devtools.artifactregistry.v1.RemoteRepositoryConfig_MavenRepository_PublicRepository,oneof"`
}

func (*RemoteRepositoryConfig_MavenRepository_PublicRepository_) isRemoteRepositoryConfig_MavenRepository_Upstream() {
}

// Configuration for a Npm remote repository.
type RemoteRepositoryConfig_NpmRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the remote repository
	//
	// Types that are assignable to Upstream:
	//
	//	*RemoteRepositoryConfig_NpmRepository_PublicRepository_
	Upstream isRemoteRepositoryConfig_NpmRepository_Upstream `protobuf_oneof:"upstream"`
}

func (x *RemoteRepositoryConfig_NpmRepository) Reset() {
	*x = RemoteRepositoryConfig_NpmRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_NpmRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_NpmRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_NpmRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_NpmRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_NpmRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 3}
}

func (m *RemoteRepositoryConfig_NpmRepository) GetUpstream() isRemoteRepositoryConfig_NpmRepository_Upstream {
	if m != nil {
		return m.Upstream
	}
	return nil
}

func (x *RemoteRepositoryConfig_NpmRepository) GetPublicRepository() RemoteRepositoryConfig_NpmRepository_PublicRepository {
	if x, ok := x.GetUpstream().(*RemoteRepositoryConfig_NpmRepository_PublicRepository_); ok {
		return x.PublicRepository
	}
	return RemoteRepositoryConfig_NpmRepository_PUBLIC_REPOSITORY_UNSPECIFIED
}

type isRemoteRepositoryConfig_NpmRepository_Upstream interface {
	isRemoteRepositoryConfig_NpmRepository_Upstream()
}

type RemoteRepositoryConfig_NpmRepository_PublicRepository_ struct {
	// One of the publicly available Npm repositories supported by Artifact
	// Registry.
	PublicRepository RemoteRepositoryConfig_NpmRepository_PublicRepository `protobuf:"varint,1,opt,name=public_repository,json=publicRepository,proto3,enum=google.devtools.artifactregistry.v1.RemoteRepositoryConfig_NpmRepository_PublicRepository,oneof"`
}

func (*RemoteRepositoryConfig_NpmRepository_PublicRepository_) isRemoteRepositoryConfig_NpmRepository_Upstream() {
}

// Configuration for a Python remote repository.
type RemoteRepositoryConfig_PythonRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the remote repository.
	//
	// Types that are assignable to Upstream:
	//
	//	*RemoteRepositoryConfig_PythonRepository_PublicRepository_
	Upstream isRemoteRepositoryConfig_PythonRepository_Upstream `protobuf_oneof:"upstream"`
}

func (x *RemoteRepositoryConfig_PythonRepository) Reset() {
	*x = RemoteRepositoryConfig_PythonRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_PythonRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_PythonRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_PythonRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_PythonRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_PythonRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 4}
}

func (m *RemoteRepositoryConfig_PythonRepository) GetUpstream() isRemoteRepositoryConfig_PythonRepository_Upstream {
	if m != nil {
		return m.Upstream
	}
	return nil
}

func (x *RemoteRepositoryConfig_PythonRepository) GetPublicRepository() RemoteRepositoryConfig_PythonRepository_PublicRepository {
	if x, ok := x.GetUpstream().(*RemoteRepositoryConfig_PythonRepository_PublicRepository_); ok {
		return x.PublicRepository
	}
	return RemoteRepositoryConfig_PythonRepository_PUBLIC_REPOSITORY_UNSPECIFIED
}

type isRemoteRepositoryConfig_PythonRepository_Upstream interface {
	isRemoteRepositoryConfig_PythonRepository_Upstream()
}

type RemoteRepositoryConfig_PythonRepository_PublicRepository_ struct {
	// One of the publicly available Python repositories supported by Artifact
	// Registry.
	PublicRepository RemoteRepositoryConfig_PythonRepository_PublicRepository `protobuf:"varint,1,opt,name=public_repository,json=publicRepository,proto3,enum=google.devtools.artifactregistry.v1.RemoteRepositoryConfig_PythonRepository_PublicRepository,oneof"`
}

func (*RemoteRepositoryConfig_PythonRepository_PublicRepository_) isRemoteRepositoryConfig_PythonRepository_Upstream() {
}

// Configuration for an Apt remote repository.
type RemoteRepositoryConfig_AptRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the remote repository.
	//
	// Types that are assignable to Upstream:
	//
	//	*RemoteRepositoryConfig_AptRepository_PublicRepository_
	Upstream isRemoteRepositoryConfig_AptRepository_Upstream `protobuf_oneof:"upstream"`
}

func (x *RemoteRepositoryConfig_AptRepository) Reset() {
	*x = RemoteRepositoryConfig_AptRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_AptRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_AptRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_AptRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_AptRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_AptRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 5}
}

func (m *RemoteRepositoryConfig_AptRepository) GetUpstream() isRemoteRepositoryConfig_AptRepository_Upstream {
	if m != nil {
		return m.Upstream
	}
	return nil
}

func (x *RemoteRepositoryConfig_AptRepository) GetPublicRepository() *RemoteRepositoryConfig_AptRepository_PublicRepository {
	if x, ok := x.GetUpstream().(*RemoteRepositoryConfig_AptRepository_PublicRepository_); ok {
		return x.PublicRepository
	}
	return nil
}

type isRemoteRepositoryConfig_AptRepository_Upstream interface {
	isRemoteRepositoryConfig_AptRepository_Upstream()
}

type RemoteRepositoryConfig_AptRepository_PublicRepository_ struct {
	// One of the publicly available Apt repositories supported by Artifact
	// Registry.
	PublicRepository *RemoteRepositoryConfig_AptRepository_PublicRepository `protobuf:"bytes,1,opt,name=public_repository,json=publicRepository,proto3,oneof"`
}

func (*RemoteRepositoryConfig_AptRepository_PublicRepository_) isRemoteRepositoryConfig_AptRepository_Upstream() {
}

// Configuration for a Yum remote repository.
type RemoteRepositoryConfig_YumRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the remote repository.
	//
	// Types that are assignable to Upstream:
	//
	//	*RemoteRepositoryConfig_YumRepository_PublicRepository_
	Upstream isRemoteRepositoryConfig_YumRepository_Upstream `protobuf_oneof:"upstream"`
}

func (x *RemoteRepositoryConfig_YumRepository) Reset() {
	*x = RemoteRepositoryConfig_YumRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_YumRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_YumRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_YumRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_YumRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_YumRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 6}
}

func (m *RemoteRepositoryConfig_YumRepository) GetUpstream() isRemoteRepositoryConfig_YumRepository_Upstream {
	if m != nil {
		return m.Upstream
	}
	return nil
}

func (x *RemoteRepositoryConfig_YumRepository) GetPublicRepository() *RemoteRepositoryConfig_YumRepository_PublicRepository {
	if x, ok := x.GetUpstream().(*RemoteRepositoryConfig_YumRepository_PublicRepository_); ok {
		return x.PublicRepository
	}
	return nil
}

type isRemoteRepositoryConfig_YumRepository_Upstream interface {
	isRemoteRepositoryConfig_YumRepository_Upstream()
}

type RemoteRepositoryConfig_YumRepository_PublicRepository_ struct {
	// One of the publicly available Yum repositories supported by Artifact
	// Registry.
	PublicRepository *RemoteRepositoryConfig_YumRepository_PublicRepository `protobuf:"bytes,1,opt,name=public_repository,json=publicRepository,proto3,oneof"`
}

func (*RemoteRepositoryConfig_YumRepository_PublicRepository_) isRemoteRepositoryConfig_YumRepository_Upstream() {
}

// Username and password credentials.
type RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The username to access the remote repository.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The Secret Manager key version that holds the password to access the
	// remote repository. Must be in the format of
	// `projects/{project}/secrets/{secret}/versions/{version}`.
	PasswordSecretVersion string `protobuf:"bytes,2,opt,name=password_secret_version,json=passwordSecretVersion,proto3" json:"password_secret_version,omitempty"`
}

func (x *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) Reset() {
	*x = RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) ProtoMessage() {}

func (x *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials) GetPasswordSecretVersion() string {
	if x != nil {
		return x.PasswordSecretVersion
	}
	return ""
}

// Publicly available Apt repositories constructed from a common repository
// base and a custom repository path.
type RemoteRepositoryConfig_AptRepository_PublicRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A common public repository base for Apt.
	RepositoryBase RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase `protobuf:"varint,1,opt,name=repository_base,json=repositoryBase,proto3,enum=google.devtools.artifactregistry.v1.RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase" json:"repository_base,omitempty"`
	// A custom field to define a path to a specific repository from the base.
	RepositoryPath string `protobuf:"bytes,2,opt,name=repository_path,json=repositoryPath,proto3" json:"repository_path,omitempty"`
}

func (x *RemoteRepositoryConfig_AptRepository_PublicRepository) Reset() {
	*x = RemoteRepositoryConfig_AptRepository_PublicRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_AptRepository_PublicRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_AptRepository_PublicRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_AptRepository_PublicRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_AptRepository_PublicRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_AptRepository_PublicRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 5, 0}
}

func (x *RemoteRepositoryConfig_AptRepository_PublicRepository) GetRepositoryBase() RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase {
	if x != nil {
		return x.RepositoryBase
	}
	return RemoteRepositoryConfig_AptRepository_PublicRepository_REPOSITORY_BASE_UNSPECIFIED
}

func (x *RemoteRepositoryConfig_AptRepository_PublicRepository) GetRepositoryPath() string {
	if x != nil {
		return x.RepositoryPath
	}
	return ""
}

// Publicly available Yum repositories constructed from a common repository
// base and a custom repository path.
type RemoteRepositoryConfig_YumRepository_PublicRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A common public repository base for Yum.
	RepositoryBase RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase `protobuf:"varint,1,opt,name=repository_base,json=repositoryBase,proto3,enum=google.devtools.artifactregistry.v1.RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase" json:"repository_base,omitempty"`
	// A custom field to define a path to a specific repository from the base.
	RepositoryPath string `protobuf:"bytes,2,opt,name=repository_path,json=repositoryPath,proto3" json:"repository_path,omitempty"`
}

func (x *RemoteRepositoryConfig_YumRepository_PublicRepository) Reset() {
	*x = RemoteRepositoryConfig_YumRepository_PublicRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteRepositoryConfig_YumRepository_PublicRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteRepositoryConfig_YumRepository_PublicRepository) ProtoMessage() {}

func (x *RemoteRepositoryConfig_YumRepository_PublicRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteRepositoryConfig_YumRepository_PublicRepository.ProtoReflect.Descriptor instead.
func (*RemoteRepositoryConfig_YumRepository_PublicRepository) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{5, 6, 0}
}

func (x *RemoteRepositoryConfig_YumRepository_PublicRepository) GetRepositoryBase() RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase {
	if x != nil {
		return x.RepositoryBase
	}
	return RemoteRepositoryConfig_YumRepository_PublicRepository_REPOSITORY_BASE_UNSPECIFIED
}

func (x *RemoteRepositoryConfig_YumRepository_PublicRepository) GetRepositoryPath() string {
	if x != nil {
		return x.RepositoryPath
	}
	return ""
}

// MavenRepositoryConfig is maven related repository details.
// Provides additional configuration details for repositories of the maven
// format type.
type Repository_MavenRepositoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repository with this flag will allow publishing
	// the same snapshot versions.
	AllowSnapshotOverwrites bool `protobuf:"varint,1,opt,name=allow_snapshot_overwrites,json=allowSnapshotOverwrites,proto3" json:"allow_snapshot_overwrites,omitempty"`
	// Version policy defines the versions that the registry will accept.
	VersionPolicy Repository_MavenRepositoryConfig_VersionPolicy `protobuf:"varint,2,opt,name=version_policy,json=versionPolicy,proto3,enum=google.devtools.artifactregistry.v1.Repository_MavenRepositoryConfig_VersionPolicy" json:"version_policy,omitempty"`
}

func (x *Repository_MavenRepositoryConfig) Reset() {
	*x = Repository_MavenRepositoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository_MavenRepositoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository_MavenRepositoryConfig) ProtoMessage() {}

func (x *Repository_MavenRepositoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository_MavenRepositoryConfig.ProtoReflect.Descriptor instead.
func (*Repository_MavenRepositoryConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Repository_MavenRepositoryConfig) GetAllowSnapshotOverwrites() bool {
	if x != nil {
		return x.AllowSnapshotOverwrites
	}
	return false
}

func (x *Repository_MavenRepositoryConfig) GetVersionPolicy() Repository_MavenRepositoryConfig_VersionPolicy {
	if x != nil {
		return x.VersionPolicy
	}
	return Repository_MavenRepositoryConfig_VERSION_POLICY_UNSPECIFIED
}

// DockerRepositoryConfig is docker related repository details.
// Provides additional configuration details for repositories of the docker
// format type.
type Repository_DockerRepositoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repository which enabled this flag prevents all tags from being
	// modified, moved or deleted. This does not prevent tags from being
	// created.
	ImmutableTags bool `protobuf:"varint,1,opt,name=immutable_tags,json=immutableTags,proto3" json:"immutable_tags,omitempty"`
}

func (x *Repository_DockerRepositoryConfig) Reset() {
	*x = Repository_DockerRepositoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository_DockerRepositoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository_DockerRepositoryConfig) ProtoMessage() {}

func (x *Repository_DockerRepositoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository_DockerRepositoryConfig.ProtoReflect.Descriptor instead.
func (*Repository_DockerRepositoryConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Repository_DockerRepositoryConfig) GetImmutableTags() bool {
	if x != nil {
		return x.ImmutableTags
	}
	return false
}

var File_google_devtools_artifactregistry_v1_repository_proto protoreflect.FileDescriptor

var file_google_devtools_artifactregistry_v1_repository_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x01, 0x0a, 0x0e, 0x55,
	0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x4f, 0x0a,
	0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0xff, 0x03, 0x0a, 0x16, 0x43,
	0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x09, 0x74, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00,
	0x52, 0x08, 0x74, 0x61, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x21, 0x0a,
	0x0c, 0x74, 0x61, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x61, 0x67, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73,
	0x12, 0x32, 0x0a, 0x15, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x13, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x13, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x09, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x54, 0x68, 0x61, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x65, 0x72,
	0x5f, 0x74, 0x68, 0x61, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x02, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x65, 0x72, 0x54,
	0x68, 0x61, 0x6e, 0x88, 0x01, 0x01, 0x22, 0x48, 0x0a, 0x08, 0x54, 0x61, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x54, 0x41, 0x47, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x54,
	0x41, 0x47, 0x47, 0x45, 0x44, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x03,
	0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x6e, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0x88, 0x01, 0x0a,
	0x1f, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f,
	0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x32, 0x0a, 0x15, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x13, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x6b, 0x65, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x6b, 0x65, 0x65, 0x70,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6b, 0x65, 0x65,
	0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x93, 0x03, 0x0a, 0x0d, 0x43, 0x6c, 0x65, 0x61,
	0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5b, 0x0a, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x14, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x72,
	0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x6e,
	0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x63, 0x65,
	0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x6d, 0x6f,
	0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x51, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x36, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a,
	0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x4b, 0x45, 0x45, 0x50, 0x10, 0x02, 0x42, 0x10, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x7b, 0x0a,
	0x17, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x11, 0x75, 0x70, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22, 0xc2, 0x19, 0x0a, 0x16, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00,
	0x52, 0x10, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x78, 0x0a, 0x10, 0x6d, 0x61, 0x76, 0x65, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x76,
	0x65, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x72, 0x0a, 0x0e,
	0x6e, 0x70, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4e, 0x70, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48,
	0x00, 0x52, 0x0d, 0x6e, 0x70, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x7b, 0x0a, 0x11, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x70, 0x79, 0x74,
	0x68, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x72, 0x0a,
	0x0e, 0x61, 0x70, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x0d, 0x61, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x72, 0x0a, 0x0e, 0x79, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x79, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x87, 0x01, 0x0a, 0x14, 0x75, 0x70, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x75, 0x70,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x1a, 0xfd, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0xb1, 0x01, 0x0a, 0x1d, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x55,
	0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x1b, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x1a, 0xa2, 0x01,
	0x0a, 0x1b, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1a, 0x0a,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x17, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x1a, 0xf4, 0x01, 0x0a, 0x10, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x8c, 0x01, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x48, 0x00, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x45, 0x0a, 0x10, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x55, 0x42,
	0x4c, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x44, 0x4f, 0x43, 0x4b, 0x45, 0x52, 0x5f, 0x48, 0x55, 0x42, 0x10, 0x01, 0x42, 0x0a, 0x0a, 0x08,
	0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0xf5, 0x01, 0x0a, 0x0f, 0x4d, 0x61, 0x76,
	0x65, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x8b, 0x01, 0x0a,
	0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x48, 0x0a, 0x10, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x21,
	0x0a, 0x1d, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54,
	0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x41, 0x56, 0x45, 0x4e, 0x5f, 0x43, 0x45, 0x4e, 0x54, 0x52,
	0x41, 0x4c, 0x10, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x1a, 0xe9, 0x01, 0x0a, 0x0d, 0x4e, 0x70, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x89, 0x01, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x70, 0x6d, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x40,
	0x0a, 0x10, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x50,
	0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x50, 0x4d, 0x4a, 0x53, 0x10, 0x01,
	0x42, 0x0a, 0x0a, 0x08, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0xee, 0x01, 0x0a,
	0x10, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x8c, 0x01, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x79, 0x74, 0x68, 0x6f,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x22, 0x3f, 0x0a, 0x10, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x52,
	0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x59, 0x50, 0x49, 0x10,
	0x01, 0x42, 0x0a, 0x0a, 0x08, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0xc5, 0x03,
	0x0a, 0x0d, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x89, 0x01, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0x9b, 0x02, 0x0a, 0x10,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x92, 0x01, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0x61, 0x73, 0x65, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0x61, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x61, 0x74, 0x68, 0x22, 0x49,
	0x0a, 0x0e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x73, 0x65,
	0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x42,
	0x41, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x42, 0x49, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x55, 0x42, 0x55, 0x4e, 0x54, 0x55, 0x10, 0x02, 0x42, 0x0a, 0x0a, 0x08, 0x75, 0x70, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0x86, 0x04, 0x0a, 0x0d, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x89, 0x01, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48,
	0x00, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x1a, 0xdc, 0x02, 0x0a, 0x10, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x92, 0x01, 0x0a, 0x0f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x59, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x73, 0x65, 0x52, 0x0e, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x73, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x50, 0x61, 0x74, 0x68, 0x22, 0x89, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x50,
	0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x45,
	0x4e, 0x54, 0x4f, 0x53, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x45, 0x4e, 0x54, 0x4f, 0x53,
	0x5f, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x45, 0x4e, 0x54,
	0x4f, 0x53, 0x5f, 0x56, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x45,
	0x4e, 0x54, 0x4f, 0x53, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x04, 0x12, 0x09, 0x0a,
	0x05, 0x52, 0x4f, 0x43, 0x4b, 0x59, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x50, 0x45, 0x4c,
	0x10, 0x06, 0x42, 0x0a, 0x0a, 0x08, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x0f,
	0x0a, 0x0d, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0xac, 0x10, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x6a,
	0x0a, 0x0c, 0x6d, 0x61, 0x76, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x6d,
	0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x0d, 0x64, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x2e, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x6f, 0x63,
	0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a, 0x19, 0x76, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x01, 0x52, 0x17, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x77, 0x0a, 0x18, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x01, 0x52, 0x16, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x53, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x12, 0x74, 0x0a, 0x10, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x43,
	0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75,
	0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x28, 0x0a,
	0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73,
	0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x38, 0x0a, 0x16, 0x63, 0x6c, 0x65, 0x61, 0x6e,
	0x75, 0x70, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75,
	0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x63, 0x6c,
	0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x72, 0x79, 0x52, 0x75,
	0x6e, 0x1a, 0x9b, 0x02, 0x0a, 0x15, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x19, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6f, 0x76,
	0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4f, 0x76, 0x65,
	0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x7a, 0x0a, 0x0e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x4a, 0x0a, 0x0d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x1e, 0x0a, 0x1a, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x10, 0x02, 0x1a,
	0x3f, 0x0a, 0x16, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6d, 0x6d,
	0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0d, 0x69, 0x6d, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x61, 0x67, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x76, 0x0a, 0x14, 0x43,
	0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x6e,
	0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x6f, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a,
	0x12, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x43, 0x4b, 0x45, 0x52, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x41, 0x56, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03,
	0x4e, 0x50, 0x4d, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x50, 0x54, 0x10, 0x05, 0x12, 0x07,
	0x0a, 0x03, 0x59, 0x55, 0x4d, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x59, 0x54, 0x48, 0x4f,
	0x4e, 0x10, 0x08, 0x12, 0x07, 0x0a, 0x03, 0x4b, 0x46, 0x50, 0x10, 0x09, 0x12, 0x06, 0x0a, 0x02,
	0x47, 0x4f, 0x10, 0x0a, 0x22, 0x64, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x52,
	0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x56,
	0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52,
	0x59, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x52, 0x45,
	0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x03, 0x3a, 0x72, 0xea, 0x41, 0x6f, 0x0a,
	0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x41, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0x42, 0x0f,
	0x0a, 0x0d, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x0d, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa1,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x12, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x53, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe5, 0x01, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x12, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x54,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x22, 0xa7, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x61,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x42, 0xe8, 0x02, 0xea, 0x41, 0x6b, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x70, 0x62, 0x3b, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x70, 0x62,
	0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_artifactregistry_v1_repository_proto_rawDescOnce sync.Once
	file_google_devtools_artifactregistry_v1_repository_proto_rawDescData = file_google_devtools_artifactregistry_v1_repository_proto_rawDesc
)

func file_google_devtools_artifactregistry_v1_repository_proto_rawDescGZIP() []byte {
	file_google_devtools_artifactregistry_v1_repository_proto_rawDescOnce.Do(func() {
		file_google_devtools_artifactregistry_v1_repository_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_artifactregistry_v1_repository_proto_rawDescData)
	})
	return file_google_devtools_artifactregistry_v1_repository_proto_rawDescData
}

var file_google_devtools_artifactregistry_v1_repository_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_devtools_artifactregistry_v1_repository_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_google_devtools_artifactregistry_v1_repository_proto_goTypes = []any{
	(CleanupPolicyCondition_TagState)(0),                                           // 0: google.devtools.artifactregistry.v1.CleanupPolicyCondition.TagState
	(CleanupPolicy_Action)(0),                                                      // 1: google.devtools.artifactregistry.v1.CleanupPolicy.Action
	(RemoteRepositoryConfig_DockerRepository_PublicRepository)(0),                  // 2: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.DockerRepository.PublicRepository
	(RemoteRepositoryConfig_MavenRepository_PublicRepository)(0),                   // 3: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.MavenRepository.PublicRepository
	(RemoteRepositoryConfig_NpmRepository_PublicRepository)(0),                     // 4: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.NpmRepository.PublicRepository
	(RemoteRepositoryConfig_PythonRepository_PublicRepository)(0),                  // 5: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.PythonRepository.PublicRepository
	(RemoteRepositoryConfig_AptRepository_PublicRepository_RepositoryBase)(0),      // 6: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository.PublicRepository.RepositoryBase
	(RemoteRepositoryConfig_YumRepository_PublicRepository_RepositoryBase)(0),      // 7: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository.PublicRepository.RepositoryBase
	(Repository_Format)(0),                                                         // 8: google.devtools.artifactregistry.v1.Repository.Format
	(Repository_Mode)(0),                                                           // 9: google.devtools.artifactregistry.v1.Repository.Mode
	(Repository_MavenRepositoryConfig_VersionPolicy)(0),                            // 10: google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig.VersionPolicy
	(*UpstreamPolicy)(nil),                                                         // 11: google.devtools.artifactregistry.v1.UpstreamPolicy
	(*CleanupPolicyCondition)(nil),                                                 // 12: google.devtools.artifactregistry.v1.CleanupPolicyCondition
	(*CleanupPolicyMostRecentVersions)(nil),                                        // 13: google.devtools.artifactregistry.v1.CleanupPolicyMostRecentVersions
	(*CleanupPolicy)(nil),                                                          // 14: google.devtools.artifactregistry.v1.CleanupPolicy
	(*VirtualRepositoryConfig)(nil),                                                // 15: google.devtools.artifactregistry.v1.VirtualRepositoryConfig
	(*RemoteRepositoryConfig)(nil),                                                 // 16: google.devtools.artifactregistry.v1.RemoteRepositoryConfig
	(*Repository)(nil),                                                             // 17: google.devtools.artifactregistry.v1.Repository
	(*ListRepositoriesRequest)(nil),                                                // 18: google.devtools.artifactregistry.v1.ListRepositoriesRequest
	(*ListRepositoriesResponse)(nil),                                               // 19: google.devtools.artifactregistry.v1.ListRepositoriesResponse
	(*GetRepositoryRequest)(nil),                                                   // 20: google.devtools.artifactregistry.v1.GetRepositoryRequest
	(*CreateRepositoryRequest)(nil),                                                // 21: google.devtools.artifactregistry.v1.CreateRepositoryRequest
	(*UpdateRepositoryRequest)(nil),                                                // 22: google.devtools.artifactregistry.v1.UpdateRepositoryRequest
	(*DeleteRepositoryRequest)(nil),                                                // 23: google.devtools.artifactregistry.v1.DeleteRepositoryRequest
	(*RemoteRepositoryConfig_UpstreamCredentials)(nil),                             // 24: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.UpstreamCredentials
	(*RemoteRepositoryConfig_DockerRepository)(nil),                                // 25: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.DockerRepository
	(*RemoteRepositoryConfig_MavenRepository)(nil),                                 // 26: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.MavenRepository
	(*RemoteRepositoryConfig_NpmRepository)(nil),                                   // 27: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.NpmRepository
	(*RemoteRepositoryConfig_PythonRepository)(nil),                                // 28: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.PythonRepository
	(*RemoteRepositoryConfig_AptRepository)(nil),                                   // 29: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository
	(*RemoteRepositoryConfig_YumRepository)(nil),                                   // 30: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository
	(*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials)(nil), // 31: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.UpstreamCredentials.UsernamePasswordCredentials
	(*RemoteRepositoryConfig_AptRepository_PublicRepository)(nil),                  // 32: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository.PublicRepository
	(*RemoteRepositoryConfig_YumRepository_PublicRepository)(nil),                  // 33: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository.PublicRepository
	(*Repository_MavenRepositoryConfig)(nil),                                       // 34: google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig
	(*Repository_DockerRepositoryConfig)(nil),                                      // 35: google.devtools.artifactregistry.v1.Repository.DockerRepositoryConfig
	nil,                           // 36: google.devtools.artifactregistry.v1.Repository.LabelsEntry
	nil,                           // 37: google.devtools.artifactregistry.v1.Repository.CleanupPoliciesEntry
	(*durationpb.Duration)(nil),   // 38: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil), // 39: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil), // 40: google.protobuf.FieldMask
}
var file_google_devtools_artifactregistry_v1_repository_proto_depIdxs = []int32{
	0,  // 0: google.devtools.artifactregistry.v1.CleanupPolicyCondition.tag_state:type_name -> google.devtools.artifactregistry.v1.CleanupPolicyCondition.TagState
	38, // 1: google.devtools.artifactregistry.v1.CleanupPolicyCondition.older_than:type_name -> google.protobuf.Duration
	38, // 2: google.devtools.artifactregistry.v1.CleanupPolicyCondition.newer_than:type_name -> google.protobuf.Duration
	12, // 3: google.devtools.artifactregistry.v1.CleanupPolicy.condition:type_name -> google.devtools.artifactregistry.v1.CleanupPolicyCondition
	13, // 4: google.devtools.artifactregistry.v1.CleanupPolicy.most_recent_versions:type_name -> google.devtools.artifactregistry.v1.CleanupPolicyMostRecentVersions
	1,  // 5: google.devtools.artifactregistry.v1.CleanupPolicy.action:type_name -> google.devtools.artifactregistry.v1.CleanupPolicy.Action
	11, // 6: google.devtools.artifactregistry.v1.VirtualRepositoryConfig.upstream_policies:type_name -> google.devtools.artifactregistry.v1.UpstreamPolicy
	25, // 7: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.docker_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.DockerRepository
	26, // 8: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.maven_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.MavenRepository
	27, // 9: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.npm_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.NpmRepository
	28, // 10: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.python_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.PythonRepository
	29, // 11: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.apt_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository
	30, // 12: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.yum_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository
	24, // 13: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.upstream_credentials:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.UpstreamCredentials
	34, // 14: google.devtools.artifactregistry.v1.Repository.maven_config:type_name -> google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig
	35, // 15: google.devtools.artifactregistry.v1.Repository.docker_config:type_name -> google.devtools.artifactregistry.v1.Repository.DockerRepositoryConfig
	15, // 16: google.devtools.artifactregistry.v1.Repository.virtual_repository_config:type_name -> google.devtools.artifactregistry.v1.VirtualRepositoryConfig
	16, // 17: google.devtools.artifactregistry.v1.Repository.remote_repository_config:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig
	8,  // 18: google.devtools.artifactregistry.v1.Repository.format:type_name -> google.devtools.artifactregistry.v1.Repository.Format
	36, // 19: google.devtools.artifactregistry.v1.Repository.labels:type_name -> google.devtools.artifactregistry.v1.Repository.LabelsEntry
	39, // 20: google.devtools.artifactregistry.v1.Repository.create_time:type_name -> google.protobuf.Timestamp
	39, // 21: google.devtools.artifactregistry.v1.Repository.update_time:type_name -> google.protobuf.Timestamp
	9,  // 22: google.devtools.artifactregistry.v1.Repository.mode:type_name -> google.devtools.artifactregistry.v1.Repository.Mode
	37, // 23: google.devtools.artifactregistry.v1.Repository.cleanup_policies:type_name -> google.devtools.artifactregistry.v1.Repository.CleanupPoliciesEntry
	17, // 24: google.devtools.artifactregistry.v1.ListRepositoriesResponse.repositories:type_name -> google.devtools.artifactregistry.v1.Repository
	17, // 25: google.devtools.artifactregistry.v1.CreateRepositoryRequest.repository:type_name -> google.devtools.artifactregistry.v1.Repository
	17, // 26: google.devtools.artifactregistry.v1.UpdateRepositoryRequest.repository:type_name -> google.devtools.artifactregistry.v1.Repository
	40, // 27: google.devtools.artifactregistry.v1.UpdateRepositoryRequest.update_mask:type_name -> google.protobuf.FieldMask
	31, // 28: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.UpstreamCredentials.username_password_credentials:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.UpstreamCredentials.UsernamePasswordCredentials
	2,  // 29: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.DockerRepository.public_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.DockerRepository.PublicRepository
	3,  // 30: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.MavenRepository.public_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.MavenRepository.PublicRepository
	4,  // 31: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.NpmRepository.public_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.NpmRepository.PublicRepository
	5,  // 32: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.PythonRepository.public_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.PythonRepository.PublicRepository
	32, // 33: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository.public_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository.PublicRepository
	33, // 34: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository.public_repository:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository.PublicRepository
	6,  // 35: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository.PublicRepository.repository_base:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.AptRepository.PublicRepository.RepositoryBase
	7,  // 36: google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository.PublicRepository.repository_base:type_name -> google.devtools.artifactregistry.v1.RemoteRepositoryConfig.YumRepository.PublicRepository.RepositoryBase
	10, // 37: google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig.version_policy:type_name -> google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig.VersionPolicy
	14, // 38: google.devtools.artifactregistry.v1.Repository.CleanupPoliciesEntry.value:type_name -> google.devtools.artifactregistry.v1.CleanupPolicy
	39, // [39:39] is the sub-list for method output_type
	39, // [39:39] is the sub-list for method input_type
	39, // [39:39] is the sub-list for extension type_name
	39, // [39:39] is the sub-list for extension extendee
	0,  // [0:39] is the sub-list for field type_name
}

func init() { file_google_devtools_artifactregistry_v1_repository_proto_init() }
func file_google_devtools_artifactregistry_v1_repository_proto_init() {
	if File_google_devtools_artifactregistry_v1_repository_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*UpstreamPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*CleanupPolicyCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*CleanupPolicyMostRecentVersions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*CleanupPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*VirtualRepositoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Repository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ListRepositoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ListRepositoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*GetRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CreateRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_UpstreamCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_DockerRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_MavenRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_NpmRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_PythonRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_AptRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_YumRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_AptRepository_PublicRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*RemoteRepositoryConfig_YumRepository_PublicRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*Repository_MavenRepositoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*Repository_DockerRepositoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[2].OneofWrappers = []any{}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[3].OneofWrappers = []any{
		(*CleanupPolicy_Condition)(nil),
		(*CleanupPolicy_MostRecentVersions)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[5].OneofWrappers = []any{
		(*RemoteRepositoryConfig_DockerRepository_)(nil),
		(*RemoteRepositoryConfig_MavenRepository_)(nil),
		(*RemoteRepositoryConfig_NpmRepository_)(nil),
		(*RemoteRepositoryConfig_PythonRepository_)(nil),
		(*RemoteRepositoryConfig_AptRepository_)(nil),
		(*RemoteRepositoryConfig_YumRepository_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[6].OneofWrappers = []any{
		(*Repository_MavenConfig)(nil),
		(*Repository_DockerConfig)(nil),
		(*Repository_VirtualRepositoryConfig)(nil),
		(*Repository_RemoteRepositoryConfig)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[13].OneofWrappers = []any{
		(*RemoteRepositoryConfig_UpstreamCredentials_UsernamePasswordCredentials_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[14].OneofWrappers = []any{
		(*RemoteRepositoryConfig_DockerRepository_PublicRepository_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[15].OneofWrappers = []any{
		(*RemoteRepositoryConfig_MavenRepository_PublicRepository_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[16].OneofWrappers = []any{
		(*RemoteRepositoryConfig_NpmRepository_PublicRepository_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[17].OneofWrappers = []any{
		(*RemoteRepositoryConfig_PythonRepository_PublicRepository_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[18].OneofWrappers = []any{
		(*RemoteRepositoryConfig_AptRepository_PublicRepository_)(nil),
	}
	file_google_devtools_artifactregistry_v1_repository_proto_msgTypes[19].OneofWrappers = []any{
		(*RemoteRepositoryConfig_YumRepository_PublicRepository_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_artifactregistry_v1_repository_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_artifactregistry_v1_repository_proto_goTypes,
		DependencyIndexes: file_google_devtools_artifactregistry_v1_repository_proto_depIdxs,
		EnumInfos:         file_google_devtools_artifactregistry_v1_repository_proto_enumTypes,
		MessageInfos:      file_google_devtools_artifactregistry_v1_repository_proto_msgTypes,
	}.Build()
	File_google_devtools_artifactregistry_v1_repository_proto = out.File
	file_google_devtools_artifactregistry_v1_repository_proto_rawDesc = nil
	file_google_devtools_artifactregistry_v1_repository_proto_goTypes = nil
	file_google_devtools_artifactregistry_v1_repository_proto_depIdxs = nil
}
