// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/aiplatform/v1/batch_prediction_job.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A job that uses a [Model][google.cloud.aiplatform.v1.BatchPredictionJob.model] to produce predictions
// on multiple [input instances][google.cloud.aiplatform.v1.BatchPredictionJob.input_config]. If
// predictions for significant portion of the instances fail, the job may finish
// without attempting predictions for all remaining instances.
type BatchPredictionJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the BatchPredictionJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-defined name of this BatchPredictionJob.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The name of the Model resource that produces the predictions via this job,
	// must share the same ancestor Location.
	// Starting this job has no impact on any existing deployments of the Model
	// and their resources.
	// Exactly one of model and unmanaged_container_model must be set.
	//
	// The model resource name may contain version id or version alias to specify
	// the version, if no version is specified, the default version will be used.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. The version ID of the Model that produces the predictions via this job.
	ModelVersionId string `protobuf:"bytes,30,opt,name=model_version_id,json=modelVersionId,proto3" json:"model_version_id,omitempty"`
	// Contains model information necessary to perform batch prediction without
	// requiring uploading to model registry.
	// Exactly one of model and unmanaged_container_model must be set.
	UnmanagedContainerModel *UnmanagedContainerModel `protobuf:"bytes,28,opt,name=unmanaged_container_model,json=unmanagedContainerModel,proto3" json:"unmanaged_container_model,omitempty"`
	// Required. Input configuration of the instances on which predictions are performed.
	// The schema of any single instance may be specified via
	// the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
	InputConfig *BatchPredictionJob_InputConfig `protobuf:"bytes,4,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The parameters that govern the predictions. The schema of the parameters
	// may be specified via the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
	ModelParameters *structpb.Value `protobuf:"bytes,5,opt,name=model_parameters,json=modelParameters,proto3" json:"model_parameters,omitempty"`
	// Required. The Configuration specifying where output predictions should
	// be written.
	// The schema of any single prediction may be specified as a concatenation
	// of [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
	// and
	// [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
	OutputConfig *BatchPredictionJob_OutputConfig `protobuf:"bytes,6,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// The config of resources used by the Model during the batch prediction. If
	// the Model [supports][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types]
	// DEDICATED_RESOURCES this config may be provided (and the job will use these
	// resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
	// must be provided.
	DedicatedResources *BatchDedicatedResources `protobuf:"bytes,7,opt,name=dedicated_resources,json=dedicatedResources,proto3" json:"dedicated_resources,omitempty"`
	// The service account that the DeployedModel's container runs as. If not
	// specified, a system generated one will be used, which
	// has minimal permissions and the custom container, if used, may not have
	// enough permission to access other Google Cloud resources.
	//
	// Users deploying the Model must have the `iam.serviceAccounts.actAs`
	// permission on this service account.
	ServiceAccount string `protobuf:"bytes,29,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Immutable. Parameters configuring the batch behavior. Currently only applicable when
	// [dedicated_resources][google.cloud.aiplatform.v1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
	// the tuning itself).
	ManualBatchTuningParameters *ManualBatchTuningParameters `protobuf:"bytes,8,opt,name=manual_batch_tuning_parameters,json=manualBatchTuningParameters,proto3" json:"manual_batch_tuning_parameters,omitempty"`
	// Generate explanation with the batch prediction results.
	//
	// When set to `true`, the batch prediction output changes based on the
	// `predictions_format` field of the
	// [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config] object:
	//
	//   - `bigquery`: output includes a column named `explanation`. The value
	//     is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
	//   - `jsonl`: The JSON objects on each line include an additional entry
	//     keyed `explanation`. The value of the entry is a JSON object that
	//     conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
	//   - `csv`: Generating explanations for CSV format is not supported.
	//
	// If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] or
	// [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] must be populated.
	GenerateExplanation bool `protobuf:"varint,23,opt,name=generate_explanation,json=generateExplanation,proto3" json:"generate_explanation,omitempty"`
	// Explanation configuration for this BatchPredictionJob. Can be
	// specified only if [generate_explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation] is set to `true`.
	//
	// This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
	// [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
	// [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
	// the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] object is inherited.
	ExplanationSpec *ExplanationSpec `protobuf:"bytes,25,opt,name=explanation_spec,json=explanationSpec,proto3" json:"explanation_spec,omitempty"`
	// Output only. Information further describing the output of this job.
	OutputInfo *BatchPredictionJob_OutputInfo `protobuf:"bytes,9,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
	// Output only. The detailed state of the job.
	State JobState `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.aiplatform.v1.JobState" json:"state,omitempty"`
	// Output only. Only populated when the job's state is JOB_STATE_FAILED or
	// JOB_STATE_CANCELLED.
	Error *status.Status `protobuf:"bytes,11,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Partial failures encountered.
	// For example, single files that can't be read.
	// This field never exceeds 20 entries.
	// Status details fields contain standard Google Cloud error details.
	PartialFailures []*status.Status `protobuf:"bytes,12,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Information about resources that had been consumed by this job.
	// Provided in real time at best effort basis, as well as a final value
	// once the job completes.
	//
	// Note: This field currently may be not populated for batch predictions that
	// use AutoML Models.
	ResourcesConsumed *ResourcesConsumed `protobuf:"bytes,13,opt,name=resources_consumed,json=resourcesConsumed,proto3" json:"resources_consumed,omitempty"`
	// Output only. Statistics on completed and failed prediction instances.
	CompletionStats *CompletionStats `protobuf:"bytes,14,opt,name=completion_stats,json=completionStats,proto3" json:"completion_stats,omitempty"`
	// Output only. Time when the BatchPredictionJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the BatchPredictionJob for the first time entered the
	// `JOB_STATE_RUNNING` state.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the BatchPredictionJob entered any of the following states:
	// `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Time when the BatchPredictionJob was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels with user-defined metadata to organize BatchPredictionJobs.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,19,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Customer-managed encryption key options for a BatchPredictionJob. If this
	// is set, then all resources created by the BatchPredictionJob will be
	// encrypted with the provided encryption key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,24,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
}

func (x *BatchPredictionJob) Reset() {
	*x = BatchPredictionJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictionJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictionJob) ProtoMessage() {}

func (x *BatchPredictionJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictionJob.ProtoReflect.Descriptor instead.
func (*BatchPredictionJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescGZIP(), []int{0}
}

func (x *BatchPredictionJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BatchPredictionJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *BatchPredictionJob) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *BatchPredictionJob) GetModelVersionId() string {
	if x != nil {
		return x.ModelVersionId
	}
	return ""
}

func (x *BatchPredictionJob) GetUnmanagedContainerModel() *UnmanagedContainerModel {
	if x != nil {
		return x.UnmanagedContainerModel
	}
	return nil
}

func (x *BatchPredictionJob) GetInputConfig() *BatchPredictionJob_InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *BatchPredictionJob) GetModelParameters() *structpb.Value {
	if x != nil {
		return x.ModelParameters
	}
	return nil
}

func (x *BatchPredictionJob) GetOutputConfig() *BatchPredictionJob_OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *BatchPredictionJob) GetDedicatedResources() *BatchDedicatedResources {
	if x != nil {
		return x.DedicatedResources
	}
	return nil
}

func (x *BatchPredictionJob) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *BatchPredictionJob) GetManualBatchTuningParameters() *ManualBatchTuningParameters {
	if x != nil {
		return x.ManualBatchTuningParameters
	}
	return nil
}

func (x *BatchPredictionJob) GetGenerateExplanation() bool {
	if x != nil {
		return x.GenerateExplanation
	}
	return false
}

func (x *BatchPredictionJob) GetExplanationSpec() *ExplanationSpec {
	if x != nil {
		return x.ExplanationSpec
	}
	return nil
}

func (x *BatchPredictionJob) GetOutputInfo() *BatchPredictionJob_OutputInfo {
	if x != nil {
		return x.OutputInfo
	}
	return nil
}

func (x *BatchPredictionJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *BatchPredictionJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BatchPredictionJob) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *BatchPredictionJob) GetResourcesConsumed() *ResourcesConsumed {
	if x != nil {
		return x.ResourcesConsumed
	}
	return nil
}

func (x *BatchPredictionJob) GetCompletionStats() *CompletionStats {
	if x != nil {
		return x.CompletionStats
	}
	return nil
}

func (x *BatchPredictionJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchPredictionJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *BatchPredictionJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BatchPredictionJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BatchPredictionJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *BatchPredictionJob) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

// Configures the input to [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
// See [Model.supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats] for Model's supported input
// formats, and how instances should be expressed via any of them.
type BatchPredictionJob_InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source of the input.
	//
	// Types that are assignable to Source:
	//
	//	*BatchPredictionJob_InputConfig_GcsSource
	//	*BatchPredictionJob_InputConfig_BigquerySource
	Source isBatchPredictionJob_InputConfig_Source `protobuf_oneof:"source"`
	// Required. The format in which instances are given, must be one of the
	// [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
	// [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats].
	InstancesFormat string `protobuf:"bytes,1,opt,name=instances_format,json=instancesFormat,proto3" json:"instances_format,omitempty"`
}

func (x *BatchPredictionJob_InputConfig) Reset() {
	*x = BatchPredictionJob_InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictionJob_InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictionJob_InputConfig) ProtoMessage() {}

func (x *BatchPredictionJob_InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictionJob_InputConfig.ProtoReflect.Descriptor instead.
func (*BatchPredictionJob_InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescGZIP(), []int{0, 0}
}

func (m *BatchPredictionJob_InputConfig) GetSource() isBatchPredictionJob_InputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *BatchPredictionJob_InputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*BatchPredictionJob_InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *BatchPredictionJob_InputConfig) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*BatchPredictionJob_InputConfig_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *BatchPredictionJob_InputConfig) GetInstancesFormat() string {
	if x != nil {
		return x.InstancesFormat
	}
	return ""
}

type isBatchPredictionJob_InputConfig_Source interface {
	isBatchPredictionJob_InputConfig_Source()
}

type BatchPredictionJob_InputConfig_GcsSource struct {
	// The Cloud Storage location for the input instances.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type BatchPredictionJob_InputConfig_BigquerySource struct {
	// The BigQuery location of the input table.
	// The schema of the table should be in the format described by the given
	// context OpenAPI Schema, if one is provided. The table may contain
	// additional columns that are not described by the schema, and they will
	// be ignored.
	BigquerySource *BigQuerySource `protobuf:"bytes,3,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*BatchPredictionJob_InputConfig_GcsSource) isBatchPredictionJob_InputConfig_Source() {}

func (*BatchPredictionJob_InputConfig_BigquerySource) isBatchPredictionJob_InputConfig_Source() {}

// Configures the output of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
// See [Model.supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats] for supported output
// formats, and how predictions are expressed via any of them.
type BatchPredictionJob_OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The destination of the output.
	//
	// Types that are assignable to Destination:
	//
	//	*BatchPredictionJob_OutputConfig_GcsDestination
	//	*BatchPredictionJob_OutputConfig_BigqueryDestination
	Destination isBatchPredictionJob_OutputConfig_Destination `protobuf_oneof:"destination"`
	// Required. The format in which Vertex AI gives the predictions, must be one of the
	// [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
	// [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
	PredictionsFormat string `protobuf:"bytes,1,opt,name=predictions_format,json=predictionsFormat,proto3" json:"predictions_format,omitempty"`
}

func (x *BatchPredictionJob_OutputConfig) Reset() {
	*x = BatchPredictionJob_OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictionJob_OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictionJob_OutputConfig) ProtoMessage() {}

func (x *BatchPredictionJob_OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictionJob_OutputConfig.ProtoReflect.Descriptor instead.
func (*BatchPredictionJob_OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescGZIP(), []int{0, 1}
}

func (m *BatchPredictionJob_OutputConfig) GetDestination() isBatchPredictionJob_OutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *BatchPredictionJob_OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*BatchPredictionJob_OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *BatchPredictionJob_OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*BatchPredictionJob_OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

func (x *BatchPredictionJob_OutputConfig) GetPredictionsFormat() string {
	if x != nil {
		return x.PredictionsFormat
	}
	return ""
}

type isBatchPredictionJob_OutputConfig_Destination interface {
	isBatchPredictionJob_OutputConfig_Destination()
}

type BatchPredictionJob_OutputConfig_GcsDestination struct {
	// The Cloud Storage location of the directory where the output is
	// to be written to. In the given directory a new directory is created.
	// Its name is `prediction-<model-display-name>-<job-create-time>`,
	// where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
	// Inside of it files `predictions_0001.<extension>`,
	// `predictions_0002.<extension>`, ..., `predictions_N.<extension>`
	// are created where `<extension>` depends on chosen
	// [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
	// number of successfully predicted instances.
	// If the Model has both [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
	// and [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri] schemata
	// defined then each such file contains predictions as per the
	// [predictions_format][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.predictions_format].
	// If prediction for any instance failed (partially or completely), then
	// an additional `errors_0001.<extension>`, `errors_0002.<extension>`,...,
	// `errors_N.<extension>` files are created (N depends on total number
	// of failed predictions). These files contain the failed instances,
	// as per their schema, followed by an additional `error` field which as
	// value has [google.rpc.Status][google.rpc.Status]
	// containing only `code` and `message` fields.
	GcsDestination *GcsDestination `protobuf:"bytes,2,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type BatchPredictionJob_OutputConfig_BigqueryDestination struct {
	// The BigQuery project or dataset location where the output is to be
	// written to. If project is provided, a new dataset is created with name
	// `prediction_<model-display-name>_<job-create-time>`
	// where <model-display-name> is made
	// BigQuery-dataset-name compatible (for example, most special characters
	// become underscores), and timestamp is in
	// YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
	// two tables will be created, `predictions`, and `errors`.
	// If the Model has both [instance][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
	// and [prediction][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri] schemata
	// defined then the tables have columns as follows: The `predictions`
	// table contains instances for which the prediction succeeded, it
	// has columns as per a concatenation of the Model's instance and
	// prediction schemata. The `errors` table contains rows for which the
	// prediction has failed, it has instance columns, as per the
	// instance schema, followed by a single "errors" column, which as values
	// has [google.rpc.Status][google.rpc.Status]
	// represented as a STRUCT, and containing only `code` and `message`.
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,3,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*BatchPredictionJob_OutputConfig_GcsDestination) isBatchPredictionJob_OutputConfig_Destination() {
}

func (*BatchPredictionJob_OutputConfig_BigqueryDestination) isBatchPredictionJob_OutputConfig_Destination() {
}

// Further describes this job's output.
// Supplements [output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
type BatchPredictionJob_OutputInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output location into which prediction output is written.
	//
	// Types that are assignable to OutputLocation:
	//
	//	*BatchPredictionJob_OutputInfo_GcsOutputDirectory
	//	*BatchPredictionJob_OutputInfo_BigqueryOutputDataset
	OutputLocation isBatchPredictionJob_OutputInfo_OutputLocation `protobuf_oneof:"output_location"`
	// Output only. The name of the BigQuery table created, in
	// `predictions_<timestamp>`
	// format, into which the prediction output is written.
	// Can be used by UI to generate the BigQuery output path, for example.
	BigqueryOutputTable string `protobuf:"bytes,4,opt,name=bigquery_output_table,json=bigqueryOutputTable,proto3" json:"bigquery_output_table,omitempty"`
}

func (x *BatchPredictionJob_OutputInfo) Reset() {
	*x = BatchPredictionJob_OutputInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictionJob_OutputInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictionJob_OutputInfo) ProtoMessage() {}

func (x *BatchPredictionJob_OutputInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictionJob_OutputInfo.ProtoReflect.Descriptor instead.
func (*BatchPredictionJob_OutputInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescGZIP(), []int{0, 2}
}

func (m *BatchPredictionJob_OutputInfo) GetOutputLocation() isBatchPredictionJob_OutputInfo_OutputLocation {
	if m != nil {
		return m.OutputLocation
	}
	return nil
}

func (x *BatchPredictionJob_OutputInfo) GetGcsOutputDirectory() string {
	if x, ok := x.GetOutputLocation().(*BatchPredictionJob_OutputInfo_GcsOutputDirectory); ok {
		return x.GcsOutputDirectory
	}
	return ""
}

func (x *BatchPredictionJob_OutputInfo) GetBigqueryOutputDataset() string {
	if x, ok := x.GetOutputLocation().(*BatchPredictionJob_OutputInfo_BigqueryOutputDataset); ok {
		return x.BigqueryOutputDataset
	}
	return ""
}

func (x *BatchPredictionJob_OutputInfo) GetBigqueryOutputTable() string {
	if x != nil {
		return x.BigqueryOutputTable
	}
	return ""
}

type isBatchPredictionJob_OutputInfo_OutputLocation interface {
	isBatchPredictionJob_OutputInfo_OutputLocation()
}

type BatchPredictionJob_OutputInfo_GcsOutputDirectory struct {
	// Output only. The full path of the Cloud Storage directory created, into which
	// the prediction output is written.
	GcsOutputDirectory string `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3,oneof"`
}

type BatchPredictionJob_OutputInfo_BigqueryOutputDataset struct {
	// Output only. The path of the BigQuery dataset created, in
	// `bq://projectId.bqDatasetId`
	// format, into which the prediction output is written.
	BigqueryOutputDataset string `protobuf:"bytes,2,opt,name=bigquery_output_dataset,json=bigqueryOutputDataset,proto3,oneof"`
}

func (*BatchPredictionJob_OutputInfo_GcsOutputDirectory) isBatchPredictionJob_OutputInfo_OutputLocation() {
}

func (*BatchPredictionJob_OutputInfo_BigqueryOutputDataset) isBatchPredictionJob_OutputInfo_OutputLocation() {
}

var File_google_cloud_aiplatform_v1_batch_prediction_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xec, 0x15, 0x0a,
	0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x6f, 0x0a, 0x19, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x17, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x62, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x65, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64,
	0x0a, 0x13, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x12, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x81, 0x01,
	0x0a, 0x1e, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x1b, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x31, 0x0a, 0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x0b,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3f, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x42, 0x0a,
	0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x73, 0x12, 0x61, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x52, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x1a, 0xe6, 0x01, 0x0a, 0x0b, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x0a, 0x67, 0x63,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x1a, 0x8e, 0x02, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x14, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x32, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xd0, 0x01, 0x0a, 0x0a, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x37, 0x0a, 0x14, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x12, 0x67, 0x63, 0x73, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x17,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0x86, 0x01, 0xea, 0x41, 0x82, 0x01, 0x0a, 0x2c, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0xdb, 0x01, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x17,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0xaa,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescData = file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_aiplatform_v1_batch_prediction_job_proto_goTypes = []interface{}{
	(*BatchPredictionJob)(nil),              // 0: google.cloud.aiplatform.v1.BatchPredictionJob
	(*BatchPredictionJob_InputConfig)(nil),  // 1: google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig
	(*BatchPredictionJob_OutputConfig)(nil), // 2: google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig
	(*BatchPredictionJob_OutputInfo)(nil),   // 3: google.cloud.aiplatform.v1.BatchPredictionJob.OutputInfo
	nil,                                     // 4: google.cloud.aiplatform.v1.BatchPredictionJob.LabelsEntry
	(*UnmanagedContainerModel)(nil),         // 5: google.cloud.aiplatform.v1.UnmanagedContainerModel
	(*structpb.Value)(nil),                  // 6: google.protobuf.Value
	(*BatchDedicatedResources)(nil),         // 7: google.cloud.aiplatform.v1.BatchDedicatedResources
	(*ManualBatchTuningParameters)(nil),     // 8: google.cloud.aiplatform.v1.ManualBatchTuningParameters
	(*ExplanationSpec)(nil),                 // 9: google.cloud.aiplatform.v1.ExplanationSpec
	(JobState)(0),                           // 10: google.cloud.aiplatform.v1.JobState
	(*status.Status)(nil),                   // 11: google.rpc.Status
	(*ResourcesConsumed)(nil),               // 12: google.cloud.aiplatform.v1.ResourcesConsumed
	(*CompletionStats)(nil),                 // 13: google.cloud.aiplatform.v1.CompletionStats
	(*timestamppb.Timestamp)(nil),           // 14: google.protobuf.Timestamp
	(*EncryptionSpec)(nil),                  // 15: google.cloud.aiplatform.v1.EncryptionSpec
	(*GcsSource)(nil),                       // 16: google.cloud.aiplatform.v1.GcsSource
	(*BigQuerySource)(nil),                  // 17: google.cloud.aiplatform.v1.BigQuerySource
	(*GcsDestination)(nil),                  // 18: google.cloud.aiplatform.v1.GcsDestination
	(*BigQueryDestination)(nil),             // 19: google.cloud.aiplatform.v1.BigQueryDestination
}
var file_google_cloud_aiplatform_v1_batch_prediction_job_proto_depIdxs = []int32{
	5,  // 0: google.cloud.aiplatform.v1.BatchPredictionJob.unmanaged_container_model:type_name -> google.cloud.aiplatform.v1.UnmanagedContainerModel
	1,  // 1: google.cloud.aiplatform.v1.BatchPredictionJob.input_config:type_name -> google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig
	6,  // 2: google.cloud.aiplatform.v1.BatchPredictionJob.model_parameters:type_name -> google.protobuf.Value
	2,  // 3: google.cloud.aiplatform.v1.BatchPredictionJob.output_config:type_name -> google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig
	7,  // 4: google.cloud.aiplatform.v1.BatchPredictionJob.dedicated_resources:type_name -> google.cloud.aiplatform.v1.BatchDedicatedResources
	8,  // 5: google.cloud.aiplatform.v1.BatchPredictionJob.manual_batch_tuning_parameters:type_name -> google.cloud.aiplatform.v1.ManualBatchTuningParameters
	9,  // 6: google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec:type_name -> google.cloud.aiplatform.v1.ExplanationSpec
	3,  // 7: google.cloud.aiplatform.v1.BatchPredictionJob.output_info:type_name -> google.cloud.aiplatform.v1.BatchPredictionJob.OutputInfo
	10, // 8: google.cloud.aiplatform.v1.BatchPredictionJob.state:type_name -> google.cloud.aiplatform.v1.JobState
	11, // 9: google.cloud.aiplatform.v1.BatchPredictionJob.error:type_name -> google.rpc.Status
	11, // 10: google.cloud.aiplatform.v1.BatchPredictionJob.partial_failures:type_name -> google.rpc.Status
	12, // 11: google.cloud.aiplatform.v1.BatchPredictionJob.resources_consumed:type_name -> google.cloud.aiplatform.v1.ResourcesConsumed
	13, // 12: google.cloud.aiplatform.v1.BatchPredictionJob.completion_stats:type_name -> google.cloud.aiplatform.v1.CompletionStats
	14, // 13: google.cloud.aiplatform.v1.BatchPredictionJob.create_time:type_name -> google.protobuf.Timestamp
	14, // 14: google.cloud.aiplatform.v1.BatchPredictionJob.start_time:type_name -> google.protobuf.Timestamp
	14, // 15: google.cloud.aiplatform.v1.BatchPredictionJob.end_time:type_name -> google.protobuf.Timestamp
	14, // 16: google.cloud.aiplatform.v1.BatchPredictionJob.update_time:type_name -> google.protobuf.Timestamp
	4,  // 17: google.cloud.aiplatform.v1.BatchPredictionJob.labels:type_name -> google.cloud.aiplatform.v1.BatchPredictionJob.LabelsEntry
	15, // 18: google.cloud.aiplatform.v1.BatchPredictionJob.encryption_spec:type_name -> google.cloud.aiplatform.v1.EncryptionSpec
	16, // 19: google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source:type_name -> google.cloud.aiplatform.v1.GcsSource
	17, // 20: google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source:type_name -> google.cloud.aiplatform.v1.BigQuerySource
	18, // 21: google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination:type_name -> google.cloud.aiplatform.v1.GcsDestination
	19, // 22: google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination:type_name -> google.cloud.aiplatform.v1.BigQueryDestination
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_batch_prediction_job_proto_init() }
func file_google_cloud_aiplatform_v1_batch_prediction_job_proto_init() {
	if File_google_cloud_aiplatform_v1_batch_prediction_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_completion_stats_proto_init()
	file_google_cloud_aiplatform_v1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1_explanation_proto_init()
	file_google_cloud_aiplatform_v1_io_proto_init()
	file_google_cloud_aiplatform_v1_job_state_proto_init()
	file_google_cloud_aiplatform_v1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1_manual_batch_tuning_parameters_proto_init()
	file_google_cloud_aiplatform_v1_unmanaged_container_model_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictionJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictionJob_InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictionJob_OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictionJob_OutputInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*BatchPredictionJob_InputConfig_GcsSource)(nil),
		(*BatchPredictionJob_InputConfig_BigquerySource)(nil),
	}
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*BatchPredictionJob_OutputConfig_GcsDestination)(nil),
		(*BatchPredictionJob_OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*BatchPredictionJob_OutputInfo_GcsOutputDirectory)(nil),
		(*BatchPredictionJob_OutputInfo_BigqueryOutputDataset)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_batch_prediction_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_batch_prediction_job_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_batch_prediction_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_batch_prediction_job_proto = out.File
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_batch_prediction_job_proto_depIdxs = nil
}
