/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.movie;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.igoweb.go.Game;
import org.igoweb.go.swing.BoardBackground;
import org.igoweb.go.swing.GobanWidget;

public class PointerGoban
extends GobanWidget {
    private BufferedImage pointerImage;
    private int pointerSize = -1;
    private boolean pointerVisible = false;
    private float pointerX;
    private float pointerY;

    public PointerGoban(Game game) {
        super(game);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.pointerVisible) {
            BoardBackground bb = this.getBoardBackground();
            if (bb.gridW > 1) {
                if (this.pointerSize != bb.gridW) {
                    this.drawPointer(bb.gridW);
                }
                g.drawImage(this.pointerImage, this.getPointerXy(this.getXOffset(), this.pointerX), this.getPointerXy(this.getYOffset(), this.pointerY), this);
            }
        }
    }

    public void hidePointer() {
        if (this.pointerVisible) {
            this.pointerVisible = false;
            if (this.pointerSize > 0) {
                this.repaint(this.getPointerXy(this.getXOffset(), this.pointerX), this.getPointerXy(this.getYOffset(), this.pointerY), this.pointerSize, this.pointerSize);
            }
        }
    }

    public void movePointer(float newX, float newY) {
        if (this.pointerVisible) {
            this.repaint(this.getPointerXy(this.getXOffset(), this.pointerX), this.getPointerXy(this.getYOffset(), this.pointerY), this.pointerSize, this.pointerSize);
        } else {
            this.pointerVisible = true;
        }
        this.pointerX = newX;
        this.pointerY = newY;
        if (this.pointerSize > 0) {
            this.repaint(this.getPointerXy(this.getXOffset(), this.pointerX), this.getPointerXy(this.getYOffset(), this.pointerY), this.pointerSize, this.pointerSize);
        }
    }

    private int getPointerXy(int off, float pos) {
        BoardBackground bb = this.getBoardBackground();
        return bb == null ? 0 : off + bb.gridOffset + (int)((float)bb.gridW * pos);
    }

    @Override
    public void removeNotify() {
        if (this.pointerImage != null) {
            this.pointerImage.flush();
            this.pointerImage = null;
            this.pointerSize = -1;
        }
        super.removeNotify();
    }

    private void drawPointer(int gridW) {
        this.pointerSize = gridW;
        int size = gridW;
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = new BufferedImage(size, size, 2);
        Graphics2D g2d = this.pointerImage.createGraphics();
        GeneralPath arrow = new GeneralPath();
        float lineW = 0.028571429f;
        arrow.moveTo(0.028571429f, 0.028571429f);
        arrow.lineTo(0.028571429f, 0.75f);
        arrow.lineTo(0.22384185f, 0.5f);
        arrow.lineTo(0.53870076f, 0.53870076f);
        arrow.closePath();
        GeneralPath handle = new GeneralPath();
        handle.moveTo(0.13567f, 0.27097f);
        handle.lineTo(0.4072777f, 0.9142857f);
        BasicStroke handleGrower = new BasicStroke(0.17142858f, 0, 0);
        Area total = new Area(arrow);
        total.add(new Area(handleGrower.createStrokedShape(handle)));
        BasicStroke outliner = new BasicStroke(0.057142857f, 2, 0);
        g2d.setColor(Color.black);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setTransform(AffineTransform.getScaleInstance(size, size));
        g2d.fill(total);
        g2d.setColor(Color.white);
        g2d.fill(outliner.createStrokedShape(total));
    }
}

