/*
 *  Copyright (C) 1999,2001,2004,2005,2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: to_html.c,v 1.6 2005/02/18 08:38:45 debug Exp $
 */

#include "global.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>


extern char body_textcolor[];
extern char body_bgcolor[];
extern char body_commentcolor[];
extern char body_stringcolor[];
extern char body_reservedcolor[];
extern char body_preproccolor[];
extern char *ip_webbug;
extern char *header_filename;
extern char *footer_filename;

/*  1 if there were several definitions of a word...  */
extern int found_several_definitions;


/*  Global:  */
int directory_depth = 0;


static int found_several_for_at_least_one_link = 0;

static int inside_box;
static int inside_parentheses;

static int is_this_the_first_char = 1;
static char curcolor[7];

static FILE *tmp_multisymbol_file;


/*
 *  include_relative_html():
 */
void include_relative_html(FILE *fout, char *fname)
{
	char buf[20000];
	long len, i, j;
	FILE *f2 = fopen(fname, "r");

	if (f2 == NULL) {
		fprintf(stderr, "YOYO\n");
		perror(fname);
		return;
	}

	while (!feof(f2)) {
		len = fread(buf, 1, sizeof(buf) - 100, f2);
		if (len > 0) {
			/*
			 *  Convert all relative href and src to include
			 *  the right number of "../":
			 *
			 *  (Yes, I know, this is semi-ugly.)
			 */
			for (i=0; i<len; i++)
				if (strncasecmp(buf+i, "href=", 5) == 0 ||
				    strncasecmp(buf+i, "src=", 4) == 0) {
					if (strncasecmp(buf+i, "href=", 5) == 0) {
						fwrite("href=", 1, 5, fout);
						i += 4;
					} else {
						fwrite("href=", 1, 4, fout);
						i += 3;
					}
					if (buf[i+1] == '"') {
						fwrite("\"", 1, 1, fout);
						i++;
					}

					if (strncasecmp(buf+i, "http:", 5)
					    == 0 ||
					    strncasecmp(buf+i, "ftp:", 4)
					    == 0 ||
					    strncasecmp(buf+i, "https:", 6)
					    == 0) {
					} else
						for (j=0; j<directory_depth;
						    j++)
							fwrite("../", 1, 3,
							    fout);
				} else
					fwrite(&buf[i], 1, 1, fout);
		}
	}
	fclose(f2);

	fprintf(fout, "<!-- directory_depth = %i -->\n", directory_depth);
}


/*
 *  html_header():
 */
void html_header(FILE *fout, char *fname)
{
	char *dirname = malloc(strlen(fname)+10);
	char *filename;

	filename = strrchr(fname, '/');
	if (filename == NULL) {
		dirname[0] = '\0';
		filename = fname;
	} else {
		filename++;
		strcpy(dirname, fname);
		dirname[filename-fname] = 0;
	}

	if (header_filename != NULL) {
		include_relative_html(fout, header_filename);
	} else
		fprintf(fout, "<html>\n<head><title>%s</title>"
		    "<META name=\"robots\" content=\"noindex,nofollow,noarchive\">\n"
		/*  "<style type=\"text/css\">"  */
		/*  "<!-- A:link, A:visited, A:active { text-decoration: none } --></style>\n"  */
		    "</head><body text=#%s bgcolor=#%s>\n",
		    fname, body_textcolor, body_bgcolor);

	fprintf(fout, "<h2><a href=\"index.html\">%s</a>%s</h2><hr>\n"
		    "<pre>", dirname, filename);

	free(dirname);
	tmp_multisymbol_file = tmpfile();
}


/*
 *  find_multisymbol_filenames():
 */
void find_multisymbol_filenames(FILE *fout, char *fname, char *symbol)
{
	char *p;
	size_t res;
	char *result_link;
	int reslinklen, i;

/*	fprintf(fout, "<pre>\n"); */
/*	fprintf(fout, "<i>%s:</i>\n<ul>\n", symbol);  */

	i = 0;

	while ((p = get_all_known_filenames(symbol, i))) {
		reslinklen = strlen(p) + SHORTSTR + 1;
		result_link = malloc(reslinklen);
		if (result_link == NULL) {
			fprintf(stderr, "out of memory in find_multisymbol_filenames()\n");
			exit(1);
		}
		res = relative(fname, p, result_link, &reslinklen);
		if (res) {
			fprintf (stderr, "some error in send_anchor\n");
			free(result_link);
			return;
		}

	        fprintf(fout, "<li><i>%s</i> in <a href=\"%s.html"
		    "#%s\">%s</a>\n",
		    symbol, result_link, symbol, p);

		free(result_link);
        	i++;
	}

/*	fprintf(fout, "</ul>"); */
/*	fprintf(fout, "</pre>\n"); */
}


/*
 *  html_ending():
 */
void html_ending(FILE *fout, char *fname)
{
	char buf[20000];
	size_t len;
	FILE *p;

	fprintf(fout, "</font>");
	fprintf(fout, "</pre>");

	if (found_several_for_at_least_one_link) {
		fprintf(fout, "<hr>"
		    "<b>NOTE:</b> There was at least one symbol which"
		    " was not unique, ie it was found in at least two"
		    " places in all of the source files. Those symbols"
		    " are displayed in <i>italic font</i>.<hr>");

	}

	fseek(tmp_multisymbol_file, 0, SEEK_SET);

	/*  TODO:  this is insecure  */
	p = popen("sort | uniq > /tmp/c2html.tmp", "w");
	if (p) {
		while (!feof(tmp_multisymbol_file)) {
			len = fread(buf, 1, sizeof buf, tmp_multisymbol_file);
			fwrite(buf, 1, len, p);
		}
		pclose(p);
	} else
		fprintf(stderr, "warning, could not popen()\n");


/*
	while (!feof(tmp_multisymbol_file)) {
		len = fread(buf, 1, sizeof buf, tmp_multisymbol_file);
		fwrite(buf, 1, len, fout);
	}
*/
	fclose(tmp_multisymbol_file);

	fprintf(fout, "<pre>\n");

	tmp_multisymbol_file = fopen("/tmp/c2html.tmp", "r");
	if (!tmp_multisymbol_file)
		perror("/tmp/c2html.tmp");
	else {
		while (!feof(tmp_multisymbol_file)) {
				len = fread(buf, 1, sizeof buf, tmp_multisymbol_file);
			fwrite(buf, 1, len, fout);
		}
		fclose(tmp_multisymbol_file);
	}

	fprintf(fout, "</pre>\n");

	if (ip_webbug != NULL)
		fprintf(fout, "<img src=\"http://%s/%s\" width=1 height=1>\n", ip_webbug, fname);

	if (footer_filename != NULL) {
		include_relative_html(fout, footer_filename);
	} else
		fprintf(fout, "</body></html>\n");

	found_several_for_at_least_one_link = 0;
}


void colorsend(FILE *fout, char ch, char *colorname)
{
	/*  Send a '\0' to only change the color...  */

	/*  newlines spaces and tabs don't care about color  */
	if ( (ch==' ') || (ch=='\t') || (ch=='\n') || (ch=='\r') ) {
		fprintf(fout, "%c", ch);
		return;
	}

	if (!is_this_the_first_char && strcmp(colorname, curcolor) != 0)
		fprintf(fout,"</font>");

	if (is_this_the_first_char || strcmp(colorname, curcolor) != 0)
		fprintf(fout, "<font color=#%s>", colorname);

	/*  Remember the color for the next time:  */
	strcpy(curcolor, colorname);
	is_this_the_first_char = 0;

	/*  Send the character:  */
	switch (ch) {
	case '<':
		fprintf(fout, "&lt;");
		break;
	case '>':
		fprintf(fout, "&gt;");
		break;
	case '&':
		fprintf(fout, "&amp;");
		break;
	case '\0':
		break;
	default:
		fprintf(fout, "%c", ch);
	}
}


void send_comment(FILE *fout, char *buf, int *p)
{
	int pos = (*p);
	char comment_type = buf[pos+1];		/*  '/' or '*'  */

	colorsend(fout, '/', body_commentcolor);
	pos++;

    if (comment_type=='/')	/*  Copy until EOL  */
      {
	while ( (buf[pos]!='\r') && (buf[pos]!='\n')
		&& (buf[pos]!='\0') )
	  colorsend (fout, buf[pos++], body_commentcolor);
	pos--;  /*  Because it is advanced later anyway.  */
      }
    else
      {
	colorsend (fout, buf[pos++], body_commentcolor);
	while ( !((buf[pos]=='*') && (buf[pos+1]=='/'))
		&& (buf[pos]!='\0') )
	  colorsend (fout, buf[pos++], body_commentcolor);
	/*  Send the last '/' and '*', if any.  */
	if (buf[pos])  colorsend (fout, buf[pos++], body_commentcolor);
	if (buf[pos])  colorsend (fout, buf[pos++], body_commentcolor);
	pos--;  /*  Because it is advanced later anyway.  */
      }

    (*p) = pos;
  }



static char identifier_word_BUF[SHORTSTR];

char *identifier_in_buf(char *buf, int pos)
{
	/*  return a pointer to the identifier at position pos in buf  */
	int p2;

	if (buf == NULL || buf[pos]=='\0' || pos < 0)
		return NULL;

	p2 = pos;
	while (buf[p2] == '_' || isalnum(buf[p2]))
		p2++;

	if (p2-pos >= SHORTSTR)
		return NULL;

	strncpy(identifier_word_BUF, buf+pos, p2-pos);
	identifier_word_BUF[p2-pos] = '\0';
	return identifier_word_BUF;
}


void send_anchor(FILE *fout, char *buf, int *p, char *linkname, char *fname)
{
	int pos = *p;
	char *identifier_word = identifier_in_buf (buf,pos);
	char *result_link;
	int reslinklen, i;

	/*  If we found several definitions, then make a link to
	    a list of all possible alternatives...  */

	reslinklen = strlen(linkname)+SHORTSTR;
	result_link = (char *) malloc (reslinklen);
	if (!result_link) {
		fprintf(stderr, "out of memory\n");
		return;
	}

	/*  printf("linkname=%s fname=%s\n", linkname, fname);  */

	i = relative(fname, linkname, result_link, &reslinklen);
	if (i != 0) {
		fprintf(stderr, "some error in send_anchor\n");
		free(result_link);
		return;
	}

	if (found_several_definitions) {
		/*  if ( strcmp(linkname, fname)==0 &&  */
		if (!inside_box)
			fprintf(fout, "<a name=\"%s\"><b><i>%s</i></b></a>",
			    identifier_word, identifier_word);
		else
			fprintf(fout, "<a href=\"%s.html#%s\"><i>%s</i></a>",
			    result_link, identifier_word, identifier_word);

		found_several_for_at_least_one_link = 1;
		find_multisymbol_filenames(tmp_multisymbol_file,
		    fname, identifier_word);
	} else {
		/*  if (strcmp(linkname, fname)==0 && !inside_box)  */
		if (strncmp(linkname+strlen(linkname)-strlen(fname),
		    fname, strlen(fname))==0 && !inside_box
		    && !inside_parentheses)
			fprintf(fout, "<a name=\"%s\"><b>%s</b></a>",
			    identifier_word, identifier_word);
		else
			fprintf(fout, "<a href=\"%s.html#%s\">%s</a>",
			    result_link, identifier_word, identifier_word);
	}

	pos += strlen(identifier_word);
	pos--;  /*  advanced later anyway...  */
	(*p) = pos;

	free(result_link);
}


void send_buf_in_color(FILE *fout, char *buf, int len, char *fname)
{
	int pos, p1;
	char *linkname;

	if (buf == NULL)
		return;

	is_this_the_first_char = 1;


	/*
	 *  Step through the buffer:
	 */
	inside_box = 0;  /*  set to >0 when inside {}-block  */
	inside_parentheses = 0;  /*  set to >0 when inside ()-block  */
	pos = 0;
	while (pos < len) {
		if (buf[pos] == '{')
			inside_box ++;
		if (buf[pos]=='}') {
			inside_box --;
			inside_parentheses = 0;
			/*  should not be neccessary, but to avoid bugs?  */
		}

		if (buf[pos]=='(')
			inside_parentheses ++;
		if (buf[pos]==')')
			inside_parentheses --;

		if (inside_box < 0)	/*  If this happens, then the  */
			inside_box = 0;	/*  code was bad anyway...  */

		if (inside_parentheses < 0)	/*  If this happens, then  */
			inside_parentheses = 0;	/*  code was bad anyway...  */

		/*  Is this the beginning of a string?  */
		if (buf[pos] == '"') {
			/*  Let's copy until the next ".  */
			colorsend(fout, buf[pos++], body_stringcolor);

			while (buf[pos] != '"' && buf[pos] != '\0') {
				colorsend(fout, buf[pos++], body_stringcolor);
				if (buf[pos-1] == '\\')
					colorsend(fout, buf[pos++],
					    body_stringcolor);
			}

			if (buf[pos] != '\0')
				colorsend(fout, buf[pos++], body_stringcolor);

			pos--;  /*  because it is advanced later anyway  */
		} else if (buf[pos]=='\'') {
			/*  Is this the beginning of a char constant?  */
			/*  Then let's copy until the next '.  */
			colorsend(fout, buf[pos++], body_stringcolor);
			while (buf[pos] != '\'' && buf[pos] != '\0') {
		colorsend (fout, buf[pos++], body_stringcolor);
		if (buf[pos-1]=='\\')
		  colorsend (fout, buf[pos++], body_stringcolor);
	      }
	    if (buf[pos])
		colorsend (fout, buf[pos++], body_stringcolor);
	    pos--;  // because it is advanced later anyway
	  }
	else
	/*  Is this the beginning of a comment?  */
	if ( (buf[pos]=='/') &&
	 ( (buf[pos+1]=='/') || (buf[pos+1]=='*') )  )
		send_comment (fout, buf, &pos);
	else
	/*  Is this a preprocessor directive?  */
	if (buf[pos]=='#')
	  {
	    /*  Preprocessor directives are colored 'body_preproccolor', they
		may occupy more than one line if ended with a backslash, and
		functions/words should be "a href" and "a name"'d just as
		non-preprocessor text is...  */
	    p1 = pos;
	    while ( (buf[pos]!=0) && (buf[pos]!='\r') && (buf[pos]!='\n') )
	      {
		/*  Is this the beginning of a comment?  */
		if ( (buf[pos]=='/') &&
		 ( (buf[pos+1]=='/') || (buf[pos+1]=='*') )  )
			send_comment (fout, buf, &pos);
		else
		//  Is this a known word?
		if ( ((isalpha(buf[pos])) || (buf[pos]=='_')) && (pos>p1+1)
			&& (linkname=is_bufword_known(buf,pos)) )
		  {
		    colorsend (fout, '\0', body_preproccolor);	//  does this do anything?
		    send_anchor (fout, buf, &pos, linkname, fname);
		  }
		else
		  colorsend (fout, buf[pos], body_preproccolor);

		pos++;

		//  Continue on the next line if we found a backslash
		if ( (buf[pos-1]=='\\') && ((buf[pos]=='\n')||(buf[pos]=='\r')) )
		  {
		    pos++;			//  this \r\n stuff is stupid, it shouldn't
		    if (buf[pos]=='\n')		//  have been invented in the first place.
			pos++;			//  Pure unix '\n' rules  :-)
		    colorsend (fout, '\n', body_preproccolor);
		  }
	      }
	    pos--;  // because it is advanced later anyway
	  }
	else
	/*  Is this a reserved word?  */
	if ( (buf[pos]>='a') && (buf[pos]<='z') &&
		(is_bufword_reserved(buf,pos)) )
	  {
	    while ( isalnum(buf[pos]) )
		colorsend (fout, buf[pos++], body_reservedcolor);
	    pos--;  // because it is advanced later anyway
	  }
	else
	/*  Is this a known function (in SRC_ROOT/.functions)?  */
	if ( ((isalpha(buf[pos])) || (buf[pos]=='_'))
		&& (linkname=is_bufword_known(buf,pos)) )
	  {
	    colorsend (fout, '\0', body_textcolor);		//  does this do anything?
	    send_anchor (fout, buf, &pos, linkname, fname);
	  }
	else
		/*  Default action: just print the character  */
		colorsend(fout, buf[pos], body_textcolor);

		/*  Advance to next character:  */
		pos ++;
	}
}

