/*  $Id: global.h,v 1.3 2005/02/13 12:37:45 debug Exp $  */

#ifndef _C2HTML_GLOBAL_H
#define _C2HTML_GLOBAL_H


#include <stdio.h>


/*  String length limits:  */
#define	SHORTSTR			1024
#define	MAXSTR				2048


#define	MAXNAMELEN			4096


#define	COMMENT_FILENAME		".index"


/*  Define this to simply ignore CVS dirs:  */
#define	IGNORE_CVS_DIRECTORIES

#define	IGNORE_ATTIC_DIRECTORIES


/*  Default colors:  */
#define	DEFAULT_FGCOLOR			"000000"
#define	DEFAULT_BGCOLOR			"ffffff"
#define	DEFAULT_COMMENTCOLOR		"f00000"
#define	DEFAULT_STRINGCOLOR		"00c000"
#define	DEFAULT_RESERVEDCOLOR		"c000c0"
#define	DEFAULT_PREPROCCOLOR		"a0a0a0"


/*  This value defines how fast (and how large) the database
    of functions should be... 4095 may be a good value (must be (2^n)-1)  */
#define	HASHMASK	65535


/*
 *  Functions:
 */

/*  scan_c.c:  */
int stringhash(char *s);
int scanfile(FILE *fout, char *fname);


/*  is_reserved.c:  */
int is_reserved(char *word);
int is_bufword_reserved(char *buf, int pos);


/*  relative.c:  */
int relative(char *orig_src, char *orig_dst, char *result, int *reslen);


/*  build_ht.c:  */
char **build_ht(char **strings, int nr_of_strings);


/*  hashfind.c:  */
char *is_bufword_known(char *buf, int pos);
char *get_all_known_filenames(char *word, int filename_nr);


/*  ignore.c:  */
int ignore_name(char *name);


/*  to_html.c:  */
void include_relative_html(FILE *fout, char *fname);
void html_header(FILE *fout, char *fname);
void html_ending(FILE *fout, char *fname);
void send_buf_in_color(FILE *fout, char *buf, int len, char *fname);


/*  directory.c:  */
void do_directory(char *name);


#endif
