;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/bdb/Tools/speek.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 27 07:22:58 1999                          */
;*    Last change :  Wed Aug  9 08:02:44 2000 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Speeking facility                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_speek
   (import  engine_param)
   (export  (verbose level . args)
	    (fprin   port . obj)
	    (bdb-log level . args)
	    (close-bdb-log)))

;*---------------------------------------------------------------------*/
;*    speek ...                                                        */
;*---------------------------------------------------------------------*/
(define (speek port flag args)
   (if flag
       (begin
	  (for-each (lambda (v) (display v port)) args)
	  (flush-output-port port))))

;*---------------------------------------------------------------------*/
;*    verbose ...                                                      */
;*---------------------------------------------------------------------*/
(define (verbose level . args)
   (speek (current-output-port) (<= level *verbose*) args))

;*---------------------------------------------------------------------*/
;*    fprin ...                                                        */
;*---------------------------------------------------------------------*/
(define (fprin port . obj)
   (for-each (lambda (o) (display o port)) obj))

;*---------------------------------------------------------------------*/
;*    *log-port* ...                                                   */
;*---------------------------------------------------------------------*/
(define *log-port* #unspecified)
 
;*---------------------------------------------------------------------*/
;*    open-input-log ...                                               */
;*---------------------------------------------------------------------*/
(define (open-input-log)
   (if (not (output-port? *log-port*))
       (set! *log-port* (open-output-file *log-name*))))

;*---------------------------------------------------------------------*/
;*    close-bdb-log ...                                                */
;*---------------------------------------------------------------------*/
(define (close-bdb-log)
   (if (output-port? *log-port*)
       (close-output-port *log-port*)))

;*---------------------------------------------------------------------*/
;*    bdb-log ...                                                      */
;*---------------------------------------------------------------------*/
(define (bdb-log level . args)
   (if (<= level *verbose*)
       (begin
	  (open-input-log)
	  (apply fprin *log-port* args)
	  (flush-output-port *log-port*))))

