(module __openpgp-human
   (import __openpgp-packets
	   __openpgp-composition
	   __openpgp-error
	   __openpgp-util)
   (export (content-tag->human-readable::bstring tag::symbol)
	   (literal-format->human-readable::bstring format::symbol)
	   (compression-algo->human-readable::bstring algo::symbol)
	   (signature-type->human-readable::bstring meaning::symbol)
	   (public-key-algo->human-readable::bstring algo::symbol)
	   (symmetric-key-algo->human-readable::bstring algo::symbol)
	   (subpacket-type->human-readable::bstring type::symbol)
	   (revocation-code->human-readable::bstring code::symbol)
	   (hash-algo->human-readable::bstring algo::symbol)
	   (s2k-algo->human-readable::bstring algo::symbol)))

(define (content-tag->human-readable::bstring tag)
   (case tag
      ((reserved) "Reserved")
      ((public-key-encrypted-session-key)
       "Public-Key Encrypted Session Key Packet")
      ((signature) "Signature Packet")
      ((symmetric-key-encrypted-session-key)
       "Symmetric-Key Encrypted Session Key Packet")
      ((one-pass-signature) "One-Pass Signature Packet")
      ((secret-key) "Secret Key Packet")
      ((public-key) "Public Key Packet")
      ((secret-subkey) "Secret Subkey Packet")
      ((compressed) "Compressed Data Packet")
      ((symmetrically-encrypted) "Symmetrically Encrypted Data Packet")
      ((marker) "Marker Packet")
      ((literal) "Literal Data Packet")
      ((trust) "Trust Packet")
      ((ID) "User ID Packet")
      ((public-subkey) "Public Subkey Packet")
      ((user-attribute) "User Attribute Packet")
      ((mdc-symmetrically-encrypted) "Sym. Encrypted and Integrity Protected Data Packet")
      ((mdc) "Modification Detection Code Packet")
      ((private-0 private-1 private-2 private-3) "Private or Experimental Values")
      (else "Unknown Packet")))

(define (literal-format->human-readable format)
   (case format
      ((binary) "Binary Data")
      ((text) "Text Data")
      ((utf8) "UTF8 Text Data")
      (else "Unknown format")))

(define (compression-algo->human-readable algo)
   (case algo
      ((uncompressed) "Uncompressed")
      ((ZIP) "ZIP (RFC 1951)")
      ((ZLIB) "ZLIB (RFC 1950)")
      ((BZip2) "BZip2 (bzip.org)")
      ((private-0 private-1 private-2 private-3 private-4 private-5 private-6
		  private-7 private-8 private-9 private-10)
       "Private/Experimental algorithm")
      (else "Unknown Compression Algorithm")))

(define (signature-type->human-readable::bstring meaning)
   (case meaning
      ((binary) "Signature of a binary document")
      ((canonical) "Signature of a canonical text document")
      ((standalone) "Standalone signature")
      ((generic-certif) "Generic certification of a User ID and Public Key packet")
      ((persona-certif) "Persona certification of a User ID and Public Key packet")
      ((casual-certif) "Casual certification of a User ID and Public Key packet")
      ((positive-certif) "Positive certification of a User ID and Public Key packet")
      ((subkey-binding) "Subkey Binding Signature")
      ((primary-key-binding) "Primary Key Binding Signature")
      ((key) "Signature directly on a key")
      ((key-revocation) "Key revocation signature")
      ((subkey-revocation) "Subkey revocation signature")
      ((certif-revocation) "Certification revocation signature")
      ((timestamp) "Timestamp signature")
      ((third-party-confirmation) "Third-Party Confirmation signature")
      (else "Unknown signature meaning")))

(define (public-key-algo->human-readable algo)
   (case algo
      ((rsa-encrypt/sign) "RSA (Encrypt or Sign)")
      ((rsa-encrypt) "RSA Encrypt-Only")
      ((rsa-sign) "RSA Sign-Only")
      ((elgamal-encrypt) "ElGamal (Encrypt-Only)")
      ((dsa) "DSA (Digital Signature Standard)")
      ((elliptic-curve) "Elliptic Curve")
      ((ecdsa) "ECDSA")
      ((elgamal-encrypt/sign) "ElGamal (Encrypt or Sign)")
      ((diffie-hellman) "Diffie-Hellman (X9.42, as defined for IETF-S/MIME)")
      ((private-0 private-1 private-2 private-3 private-4 private-5 private-6
		  private-7 private-8 private-9 private-10)
       "Private/Experimental algorithm")
      (else "Unknown public key algorithm")))

(define (symmetric-key-algo->human-readable algo)
   (case algo
      ((unencrypted) "Plaintext or unencrypted data")
      ((idea) "IDEA [IDEA]")
      ((des3) "Triple-DES (DES-EDE, as per spec - 168 bit key derived from 192)")
      ((cast5) "CAST5 (128 bit key, as per RFC 2144)")
      ((blowfish) "Blowfish (128 bit key, 16 rounds) [BLOWFISH]")
      ((safer-sk128) "SAFER-SK128 (13 rounds) [SAFER]")
      ((des/sk) "DES/SK")
      ((aes-128) "AES with 128-bit key")
      ((aes-192) "AES with 192-bit key")
      ((aes-256) "AES with 256-bit key")
      ((twofish) "Twofish with 256-bit key")
      ((private-0 private-1 private-2 private-3 private-4 private-5 private-6
		  private-7 private-8 private-9 private-10)
       "Private/Experimental algorithm")
      (else "Unknown symmetric key algorithm")))


(define (subpacket-type->human-readable type)
   (case type
      ((creation-time) "Signature Creation Time")
      ((expiration-time) "Signature Expiration Time")
      ((exportable?) "Exportable Certification")
      ((trust) "Trust Signature")
      ((regular-expression) "Regular Expression")
      ((revocable?) "Revocable")
      ((key-expiration-time) "Key Expiration Time")
      ((placeholder) "Placeholder for backward compatibility")
      ((preferred-symmetric) "Preferred Symmetric Algorithms")
      ((revocation-key) "Revocation Key")
      ((issuer-ID) "Issuer Key ID")
      ((notation) "Notation Data")
      ((preferred-hash) "Preferred Hash Algorithms")
      ((preferred-compression) "Preferred Compression Algorithms")
      ((key-server-prefs) "Key Server Preferences")
      ((preferred-key-server) "Preferred Key Server")
      ((primary-id?) "Primary User ID")
      ((policy) "Policy URL")
      ((key-flags) "Key Flags")
      ((signer-ID) "Signer's User Id")
      ((revocation-reason) "Reason for Revocation")
      ((features) "Features")
      ((signature-target) "Signature Target")
      ((embedded-signature) "Embedded Signature")
      ((issuer-fpr) "Issuer Fingerprint")
      ((private-0 private-1 private-2 private-3 private-4 private-5 private-6
		  private-7 private-8 private-9 private-10)
       "internal or user-defined")
      (else "Unknown Subpacket")))

(define (revocation-code->human-readable code)
   (case code
      ((no-reason) "No reason specified (key revocations or cert revocations")
      ((superseded-key) "Key is superseded (key revocations)")
      ((compromised-key) "Key material has been compromised (key revocations)")
      ((no-longer-used) "Key is retired and no longer used (key revocations)")
      ((invalid-user-ID) "User ID information is no longer valid (cert revocations)")
      ((private-0 private-1 private-2 private-3 private-4 private-5 private-6
		  private-7 private-8 private-9 private-10)
       "internal or user-defined")
      (else "Unknown revocation code")))

(define (hash-algo->human-readable algo)
   (case algo
      ((md5) "MD5")
      ((sha-1) "SHA-1")
      ((ripe-md/160) "RIPE-MD/160")
      ;((double-width-sha) "Double-width SHA")
      ;((md2) "MD2")
      ;((tiger/192) "TIGER/192")
      ;((HAVAL) "HAVAL")
      ((sha256) "SHA256")
      ((sha384) "SHA384")
      ((sha512) "SHA512")
      ((sha224) "SHA224")
      ((private-0 private-1 private-2 private-3 private-4 private-5 private-6
		  private-7 private-8 private-9 private-10)
       "Private/Experimental algorithm")
      (else "Unknown hash algorithm")))

(define (s2k-algo->human-readable algo)
   (case algo
      ((simple) "Simple S2K (hash)")
      ((salted) "Salted S2K")
      ((iterated) "Iterated and Salted S2K")
      (else "Unknown S2K algorithm")))
