#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

int db_open_pg(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
int paren=0;
char UID[TOKENSIZE];
char passwd[TOKENSIZE];
char database[TOKENSIZE];
char address[TOKENSIZE];
char dsn[TOKENSIZE];
char temp[LINELENGTH];

  tokentype=gettoken(token);
  if (strcmp(token,"(")==0)
  {
    paren=1;
    tokentype=gettoken(token);
  }

  if (global_uid[0]==0) { getvar(UID,token,"uid"); }
    else { strcpy(UID,global_uid); }
  if (global_passwd[0]==0) { getvar(passwd,token,"pwd"); }
    else { strcpy(passwd,global_passwd); }
  if (global_dsn[0]==0) { getvar(dsn,token,"dsn"); }
    else { strcpy(dsn,global_dsn); }
  if (global_database[0]==0) { getvar(database,token,"database"); }
    else { strcpy(database,global_database); }
  if (global_address[0]==0) { strcpy(address,"localhost"); }
    else { strcpy(address,global_address); }

  if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT)
  {
    sprintf(newtoken,
               "$%s=pg_connect(\"dbname=%s host=%s user=%s password=%s\");\n",
               variable,database,address,UID,passwd);
    strcat(newtoken,temp);
  }
    else
  {
    push(token,tokentype);
    eval_molecule(temp);
    sprintf(newtoken,"$a2p_connstr=%s\n",temp);
    add_indent(newtoken);
    strcpy(temp,newtoken);

    strcat(temp,"$a2p_uid=strstr($a2p_connstr,'uid');\n");
    add_indent(temp);
    strcat(temp,"$a2p_uid=substr($d,strpos($d,'=')+1,strpos($d,';')-strpos($d,'=')-1);\n");
    add_indent(temp);

    strcat(temp,"$a2p_pwd=strstr($a2p_connstr,'pwd');\n");
    add_indent(temp);
    strcat(temp,"$a2p_pwd=substr($d,strpos($d,'=')+1,strpos($d,';')-strpos($d,'=')-1);\n");
    add_indent(temp);

    sprintf(newtoken,"%s$%s=pg_connect(\"dbname=%s user=\".$a2p_uid.\" password=\".$a2p_pwd.\" host=%s\");\n",
                                     temp,variable,database,address);
/*
    add_indent(temp);
    strcat(newtoken,temp);
*/
  }
 
  if (paren==1)
  { tokentype=gettoken(token); } 

  return 0;
}

int db_execute_pg(char *newtoken,char *variable)
{
char molecule1[LINELENGTH];
char spaces[100];
int r;

  spaces[0]=0;
  eval_molecule(molecule1);

  if (setvar==0)
  {
    sprintf(newtoken,"@pg_query(%s,$%s);",variable,molecule1);
  }
    else
  {
    sprintf(newtoken,"$%s_query=@pg_query(%s,$%s); $%s_countt=0;",objects[setvar],variable,molecule1,objects[setvar]);

    if (BOF==1)
    {
      strcat(newtoken,"\n");
      for (r=0; r<indent; r++)
      { strcat(newtoken,"  "); }
      strcat(newtoken,"$");
      strcat(newtoken,objects[setvar]);
      strcat(newtoken,"_BOF=1;");
    }

    for (r=0; r<indent; r++)
    { strcat(newtoken,"  "); }

    strcpy(objectstype[setvar],"ADODB.Execute");

    sprintf(molecule1,"\n$%s=pg_fetch_array($%s_query,$%s_countt++);\n",objects[setvar],objects[setvar],objects[setvar]);

    strcat(newtoken,molecule1);
  }

  return 0;
}

int parse_adodb_rs_pg(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
char molecule1[LINELENGTH];
char temp[512];
int r;

  /*  autoindent(); */
  tokentype=gettoken(token);

  if (strcasecmp(token,"open")==0)
  {
    tokentype=gettoken(token);
  
    sprintf(newtoken,"pg_query($%s_ActiveConnection,$%s_CommandText);",variable,variable); 
  }
    else
  if (strcasecmp(token,"bof")==0)
  { sprintf(newtoken,"($%s_BOF==1)",variable); }
    else
  if (strcasecmp(token,"eof")==0)
  { sprintf(newtoken,"($%s==0)",variable); }
    else
  if (strcasecmp(token,"move")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,"(")!=0)
    { error(token,"(","move"); }

    tokentype=gettoken(token);

    /* sprintf(newtoken,"pg_data_seek($%s_query,%s);\n",variable,token); */
    sprintf(newtoken,"$%s_countt=%s;\n",objects[setvar],token);

    tokentype=gettoken(token);
    if (strcmp(token,")")!=0)
    { error(token,")","move"); }
  }
    else
  if (strcasecmp(token,"count")==0 || strcasecmp(token,"recordcount")==0)
  {
    sprintf(newtoken,"pg_numrows($%s_query)",variable);
  }
    else
  if (strcasecmp(token,"movelast")==0)
  {
    /* sprintf(newtoken,"pg_data_seek($%s_query,pg_numrows($%s_query)-1);\n",variable,variable); */
    sprintf(newtoken,"$%s_countt=pg_numrows($%s_query)-1;\n",objects[setvar],variable);
    sprintf(temp,"\n$%s=pg_fetch_array($%s_query,$%s_countt);\n",variable,variable,objects[setvar]);
    strcat(newtoken,temp);

    if (BOF==1)
    {
      for (r=0; r<indent; r++)
      { strcat(newtoken,"  "); }
      strcat(newtoken,"$");
      strcat(newtoken,variable);
      strcat(newtoken,"_BOF=0;\n");
    }
  }
    else
  if (strcasecmp(token,"movenext")==0)
  { 
    sprintf(newtoken,"$%s=pg_fetch_array($%s_query,$%s_countt++);\n",variable,variable,objects[setvar]);

    if (BOF==1)
    {
      for (r=0; r<indent; r++)
      { strcat(newtoken,"  "); }
      strcat(newtoken,"$");
      strcat(newtoken,variable);
      strcat(newtoken,"_BOF=0;\n");
    }
  }
    else
  if (strcmp(token,"(")==0)
  {
    push("(",TOK_PAREN);
    molecule1[0]=0;
    eval_funct(molecule1);
    
    sprintf(newtoken,"$%s[%s]",variable,molecule1);

    tokentype=gettoken(token);
    if (strcmp(token,"=")==0)
    {
      fprintf(out,"%s=",newtoken);
      strcpy(newtoken,"");
      eval_expression(" ");
    }
      else
    { push(token,tokentype); }
  }

  return 0;
}

int parse_adodb_connection_pg(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);

  if (strcasecmp(token,"open")==0)
  { db_open_pg(newtoken,variable); } 
    else 
  if (strcasecmp(token,"execute")==0)
  { db_execute_pg(newtoken,variable); }
    else
  if (strcasecmp(token,"close")==0)
  {
    add_indent(newtoken);
    sprintf(newtoken,"pg_close($%s);",variable);
  }

  return 0;
}

