/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: plfunctions.c,v 1.2 1999/07/24 22:01:16 daeron Exp $

*/

#include "wsound.h"

extern proplist_t WMSoundDB;


proplist_t
SGetObjectForKey(char *defaultName)
{
    proplist_t object = NULL;
    proplist_t key = PLMakeString(defaultName);

    object = PLGetDictionaryEntry(WMSoundDB, key);

    PLRelease(key);

    return object;
}


void
SSetObjectForKey(proplist_t object, char *defaultName)
{
    proplist_t key = PLMakeString(defaultName);

    PLInsertDictionaryEntry(WMSoundDB, key, object);
    PLRelease(key);
}


void
SRemoveObjectForKey(char *defaultName)
{
    proplist_t key = PLMakeString(defaultName);
    
    PLRemoveDictionaryEntry(WMSoundDB, key);
    
    PLRelease(key);
}


char*
SGetStringForKey(char *defaultName)
{
    proplist_t val;
    
    val = SGetObjectForKey(defaultName);

    if (!val)
	return NULL;

    if (!PLIsString(val))
	return NULL;

    return PLGetString(val);
}



proplist_t
SGetArrayForKey(char *defaultName)
{
    proplist_t val;
    
    val = SGetObjectForKey(defaultName);
    
    if (!val)
	return NULL;

    if (!PLIsArray(val))
	return NULL;

    return val;
}


proplist_t
SGetDictionaryForKey(char *defaultName)
{
    proplist_t val;

    val = SGetObjectForKey(defaultName);
    
    if (!val)
	return NULL;

    if (!PLIsDictionary(val))
	return NULL;

    return val;
}


int
SGetIntegerForKey(char *defaultName)
{
    proplist_t val;
    char *str;
    int value;

    val = SGetObjectForKey(defaultName);
    
    if (!val)
	return 0;

    if (!PLIsString(val))
	return 0;
    
    str = PLGetString(val);
    if (!str)
	return 0;
    
    if (sscanf(str, "%i", &value)!=1)
	return 0;

    return value;
}


Bool
SGetBoolForKey(char *defaultName)
{
    int value;
    char *str;

    str = SGetStringForKey(defaultName);
    
    if (!str)
	return False;
    
    if (sscanf(str, "%i", &value)==1 && value!=0)
	return True;

    if (strcasecmp(str, "YES")==0)
	return True;
    
    if (strcasecmp(str, "Y")==0)
	return True;

    return False;
}


void
SSetIntegerForKey(int value, char *defaultName)
{
    proplist_t object;
    char buffer[128];

    sprintf(buffer, "%i", value);
    object = PLMakeString(buffer);
 
    SSetObjectForKey(object, defaultName);
    PLRelease(object);
}



void
SSetStringForKey(char *value, char *defaultName)
{
    proplist_t object;

    object = PLMakeString(value);
 
    SSetObjectForKey(object, defaultName);
    PLRelease(object);
}


void
SSetBoolForKey(Bool value, char *defaultName)
{
    static proplist_t yes = NULL, no = NULL;

    if (!yes) {
	yes = PLMakeString("YES");
	no = PLMakeString("NO");
    }

    SSetObjectForKey(value ? yes : no, defaultName);
}

