///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	norsk.c
  Purpose:	Converts Rune Kleveland's Norwegian ispell dictionary to 
  		the single-word-per-line wordlist format required by 
		GutenMark.  Refer to folk.uio.no/runekl/dictionary.html.  
		The original wordlist is GPL'd, and is Copyright 2000 by
		Rune Kleveland.  Contact runekl@math.uio.no.
  Mods:		11/09/01 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

/*
  This wordlist has the novel feature that it includes not only diacritical
  marks, but also soft-hyphens for automatic hyphenation.
*/

#include <stdio.h>
#include <string.h>

char s[1000], ss[1000], *sss;
int i;

int
main (int argc, char *argv[])
{
  while (NULL != fgets (s, sizeof (s) - 1, stdin))
    {
      if (s[0] == '#')
	continue;
      if (1 == sscanf (s, "%s", ss))
	{
	  for (;;)
	    {
	      // Replace all hyphens by soft hyphens.
	      sss = strstr (ss, "-");
	      if (sss == NULL)
		break;
	      //strcpy (sss, sss + 1);
	      *sss = 173;
	    }
	  for (;;)
	    {
	      sss = strstr (ss, "\"");
	      if (sss == NULL)
		break;
	      strcpy (sss, sss + 1);
	    }
	  i = strlen (ss);
	  if (i > 4
	      && (!strcmp (&ss[i - 4], "xxxx")
		  || !strcmp (&ss[i - 4], "yyyy")))
	    ss[i - 4] = '\0';
	  if (i > 6 && !strcmp (&ss[i - 6], "zyzyzy"))
	    ss[i - 6] = '\0';
	  puts (ss);
	}
    }
  return (0);
}
