/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: memtrack.h,v 1.4 2003/09/13 11:01:55 jdolecek Exp $
 * **********************************************************/

/************************************************************
 *
 * memtrack.h  - Utility module for tracking memory allocated 
 *               and/or locked by the driver. 
 *
 ************************************************************/


#ifndef MEMTRACK_H
#define MEMTRACK_H

#define INCLUDE_ALLOW_MODULE
#include "include/includeCheck.h"

#include "include/vm_types.h"

typedef struct MemTrackEntry {
  VPN vpn;
  MPN mpn;
  struct MemTrackEntry *hashChain;
#ifdef _WIN32
  PMDL mdl;
#endif
} MemTrackEntry;

extern void *MemTrack_Init(void);
extern MemTrackEntry *MemTrack_Add(void *s, VPN vpn, MPN mpn);
extern MemTrackEntry *MemTrack_LookupVPN(void *s, VPN vpn);
extern int MemTrack_Cleanup(void *s,
                            void (*cleanProc)(void *, MemTrackEntry *),
                            void *clientData);
extern void *MemTrack_Scan(void *s, void *arg,
            void *(*searchFunc)(void *arg, MemTrackEntry *entryPtr)); 

#endif 
