#!/bin/sh
#
# Simple-and-quick install script to install the Linux binaries for VMware
# under NetBSD.
#
# Written for Wasabi Systems, Inc. by Frank van der Linden
# (fvdl@wasabisystems.com)
#

#
# Set some defaults
#
prefix=/usr/local
tmpdir=/tmp

#
# Sanity check, we need it.
#
if [ ! -d /emul/linux/. ]; then
	echo "/emul/linux does exist. Aborting install."
	exit 1
fi

#
# Determine/create main install dir.
#
echo This script will install the VMware binaries and support scripts.
echo
echo -n "Where should VMware should be installed? [$prefix] "
read input
if [ "$input" != "" ]; then
	prefix=$input
fi
if [ ! -d $prefix ]; then
	echo -n "$prefix does not exist. Create it (y/n)? "
	read input
	if [ "$input" != "y" ]; then
		echo "Aborting install."
		exit 2
	fi
	mkdir -p $prefix
	if [ $? -ne 0 ]; then
		echo "Could not create directory $prefix. Exiting."
		exit 3
	fi
fi

#
# Determine source of unpacked VMware tarball.
#
echo -n "Which directory contains the unpacked VMware distribution? [$tmpdir] "
read input
if [ "$input" != "" ]; then
	tmpdir=$input
fi
tmpdir=$tmpdir/vmware-distrib
if [ ! -d $tmpdir ]; then
	echo "$tmpdir does not exist. Exiting"
	exit 4
fi

#
# Create install subdirectories.
#
(while read dir mode; do
	if [ ! -d $dir ]; then
		first=`echo $dir | cut -c 1`
		if [ "$first" = "/" ]; then
			mkdir $dir
			chmod $mode $dir
		else
			mkdir -p $prefix/$dir
			chmod $mode $prefix/$dir
		fi
	fi
 done) < DIRS.list

#
# Copy files that were in the VMware tarball.
#
(while read file dest mode; do
	first=`echo $dest | cut -c 1`
	if [ "$first" = "/" ]; then
		install -c -m $mode $tmpdir/$file $dest
	else
		install -c -m $mode $tmpdir/$file $prefix/$dest
	fi
 done) < FILES.list

#
# Copy startup files and LKMs that we provide.
#
(while read file dest mode; do
	first=`echo $dest | cut -c 1`
	if [ "$first" = "/" ]; then
		install -c -m $mode $file $dest
	else
		install -c -m $mode $file $prefix/$dest
	fi
 done) < STARTUP.list

#
# Files that need special handling.
#
zcat $tmpdir/man/man1/vmware.1.gz > $prefix/man/man1/vmware.1
sed "s,@VMWARE_PREFIX@,$prefix," < rc.conf.d/vmware > /etc/rc.conf.d/vmware

#
# Create the extra device links.
#
(while read src dest; do
	ln -s $src $dest
done) < LINKS.list

#
# Create the /etc/vmware/config file
#
(
	echo "vmware.fullpath = \"$prefix/bin/vmware\""
	echo "wizard.fullpath = \"$prefix/bin/vmware-wizard\""
	echo "dhcpd.fullpath = \"$prefix/bin/vmware-dhcpd\""
	echo "loop.fullpath = \"$prefix/bin/vmware-loop\""
	echo "smbpasswd.fullpath = \"$prefix/bin/vmware-smbpasswd\""
	echo "libdir = \"$prefix/share/vmware\""
	echo "vmnet1.HostOnlyAddress = \"172.16.212.1\""
	echo "vmnet1.HostOnlyNetMask = \"255.255.255.0\""
	echo "host.FSSupportLocking1 = 0x1"
) > /etc/vmware/config
chmod 444 /etc/vmware/config

echo "Install finished."

exit 0
