/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vm_time.h,v 1.2 2003/02/16 01:29:51 bad Exp $
 * **********************************************************/


/*
 * vm_time.h  --
 *
 *    Time management functions.
 *    Part of driver-only distribution
 *
 *    see comment in poll.c
 */


#ifndef VM_TIME_H
#define VM_TIME_H


#include "vm_types.h"

typedef int64 VmTimeType;          /* Time in microseconds */
typedef int64 VmTimeRealClock;     /* Real clock kept in microseconds */
typedef int64 VmTimeVirtualClock;  /* Virtual Clock kept in CPU cycles */



typedef struct VmTimeStart {
   VmTimeVirtualClock   count;          
   VmTimeRealClock      time; 
   uint32		mhzEstimate;    /* Estimate of MHZ cycle time */
   uint32		pad;		/* pad to 64-bit boundary */
} VmTimeStart;


typedef struct VmTimeVirtualRealClock {
   VmTimeType		lastVirtualTime;
   VmTimeType		lastRealTime;
   VmTimeType		lastVirtualRealTime;
   VmTimeType		error;			/* accumulated error */
   double		maxCorrectionRate;	/* ratio of times */
   struct VM		*vm;			/* backpointer to vm */
} VmTimeVirtualRealClock;

#define VMTIME_VIRTUAL_INFINITE  ((((VmTimeVirtualClock)1)<<62)-1)

#define CYCLES_TO_USECS(vm, _c)  ((_c) / (vm)->miscShared->startTime.mhzEstimate)
#define USECS_TO_CYCLES(vm, _us) ((_us) * (vm)->miscShared->startTime.mhzEstimate)

#ifdef MONITOR
#define GET_REALCYCLES()         (GetTSC())
#define GET_REALTIME(vm)         (CYCLES_TO_USECS(vm, GET_REALCYCLES()))
#else
#define GET_REALCYCLES()         GetTSC()
#define GET_REALTIME(vm)         (Host_FastRealTime() / \
				  Host_FastRealTimeFrequency())
#endif

#ifdef MONITOR
#define GET_VIRTUALCYCLES(vm)    ((vm)->vcpu[0]->currentVirtualTime)
#else
#define GET_VIRTUALCYCLES(vm)    ((vm)->vcpu[0].currentVirtualTime)
#endif
#define GET_VIRTUALCYCLES32(vm)  (*(uint32 *)&GET_VIRTUALCYCLES(vm))

#endif /* VM_TIME_H */

