#include "args.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/argsort.c,v 1.2 2005/05/28 22:27:14 beebe Exp $";
#endif

#include "args.h"
#include <stdio.h>

#if HAVE_STDC
#include <stdlib.h>
#include <string.h>
#else
extern void qsort ARGS((void *, size_t, size_t,
	int (*)(const void *, const void *)));
#endif
#define QSORT_FUN_TYPE int (*) ARGS((const void *, const void *))

int main ARGS((int argc, char **argv));
static int xstrcmp ARGS((char **a, char **b));

int
#if HAVE_STDC
main(int argc, char **argv)
#else /* K&R style */
main(argc,argv)
int argc;
char **argv;
#endif /* HAVE_STDC */
{
    int i;

    argc--, argv++;
    qsort(argv,argc,sizeof(char *), (QSORT_FUN_TYPE)xstrcmp);
    for(i = 0; i < argc; i++)
	printf("%s ", argv[i]);
    printf("\n");
    return(0);
}

static int
#if HAVE_STDC
xstrcmp(char **a, char **b)
#else /* K&R style */
xstrcmp(a,b)
char **a,**b;
#endif /* HAVE_STDC */
{
    return(strcmp(*a,*b));
}
