/* ==== syscall.S ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by Chris Provenzano.
 * 4. The name of Chris Provenzano may not be used to endorse or promote 
 *	  products derived from this software without specific prior written
 *	  permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CHRIS PROVENZANO ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL CHRIS PROVENZANO BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * Description : Machine dependent syscalls for decstation with r2000/r3000
 *
 *  1.00 93/08/14 proven
 *      -Started coding this file.
 */

#include <sys/syscall.h>
#include <mips/asm.h>

	ASMSTR("$Id: syscall-template-r2000-ultrix-4.2.S,v 1.1 1994/10/25 22:47:09 proven Exp $");

#ifdef ABICALLS
	.abicalls
#endif

#include <sys/syscall.h>
#include <machine/regdef.h>

#ifdef SYS___sigsuspend14
#define SYS_sigsuspend SYS___sigsuspend14
#endif
#ifdef SYS___sigprocmask14
#define SYS_sigprocmask SYS___sigprocmask14
#endif


/*
 * If compiling for shared libs, Emit sysV ABI PIC segment pseudo-ops.
 *
 * i)  Emit .abicalls before .LEAF entrypoint, and .cpload/.cprestore after.
 * ii) Do interprocedure jumps indirectly via t9, with the side-effect of
 *     preserving the callee's entry address in t9.
 */
#ifdef ABICALLS
# define PIC_LEAF(x,sr) \
	.abicalls; LEAF(x); .set noreorder; .cpload sr; .set reorder
# define PIC_CALL(l,sr) la sr, _C_LABEL(l); jr sr
#else
# define PIC_LEAF(x,sr)	LEAF(x)
# define PIC_CALL(l,sr)	j  _C_LABEL(l)
#endif

#define SYSTRAP(x)	li v0,SYS_ ## x; syscall;

/*
 * Do a normal syscall.
 */
#define RSYSCALL(x)							\
	PSEUDO(machdep_sys_##x,x)

/*
 * Helper macro: produce a possibly-PIC entry point 'x' that syscalls 'y'.
 */
#define PIC_SYSTRAP(x,y)						\
	PIC_LEAF(x,t9);							\
	SYSTRAP(y)

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value. Eventually I want to load the errno value directly
 * into pthread_run->error but until then ...
 */

#define PSEUDO(x,y)							\
	PIC_SYSTRAP(x,y);						\
	bne a3,zero,err; j ra;						\
err:	negu v0,v0; j ra;						\
	END(x)

#define XSYSCALL(NAME) RSYSCALL(NAME)
XSYSCALL(SYSCALL_NAME)
