#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <err.h>
#include <stdio.h>
#include <stdlib.h>

#define	PORT	12345

main()
{
	char buf[1024];
	struct msghdr msg;
	struct sockaddr_in addr;
	struct iovec iov;
	struct fd_set master, working;
	struct timeval timeout, tv, otv;
	int i, len, num, oi, on, s;

	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		err(1, "socket");

	on = 1;
	if (ioctl(s, FIONBIO, &on) < 0)
		err(1, "ioctl(FIONBIO)");

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_ANY);
	addr.sin_port = htons(PORT);

	if (bind(s, (struct sockaddr *)&addr, sizeof(addr)) < 0)
		err(1, "bind");

	FD_ZERO(&master);
	FD_SET(s, &master);

	timeout.tv_sec = 60;
	timeout.tv_usec = 0;

	i = 0;
	for (;;) {
		working = master;
		gettimeofday(&tv, NULL);
		if (select(s + 1, &working, NULL, NULL, &timeout) < 0)
			err(1, "select");
		gettimeofday(&tv, NULL);

		for (;;) {
			memset(&msg, 0, sizeof(msg));
			iov.iov_base = buf;
			iov.iov_len = sizeof(buf);
			msg.msg_iov = &iov;
			msg.msg_iovlen = 1;
			msg.msg_name = &addr;
			msg.msg_namelen = sizeof(addr);

			len = recvmsg(s, &msg, 0);
			if (len < 0)
				break;
			i++;
			num = buf[0];

			if (otv.tv_sec != tv.tv_sec) {
				fprintf(stderr, "%9d (%5d last sec)\n",
				    i, i - oi);
				otv = tv;
				oi = i;
			}

			memset(&msg, 0, sizeof(msg));
			iov.iov_base = buf;
			iov.iov_len = (arc4random() % 100) + 25;
			msg.msg_iov = &iov;
			msg.msg_iovlen = 1;
			msg.msg_name = &addr;
			msg.msg_namelen = sizeof(addr);

			len = sendmsg(s, &msg, 0);
			if (len < 0)
				err(1, "sendmsg");
		}
	}
}
