/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.project.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.artifact.deploy.ArtifactDeployer;
import org.apache.maven.shared.artifact.deploy.ArtifactDeployerException;
import org.apache.maven.shared.project.NoFileAssignedException;
import org.apache.maven.shared.project.deploy.ProjectDeployer;
import org.apache.maven.shared.project.deploy.ProjectDeployerRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ProjectDeployer.class)
public class DefaultProjectDeployer
implements ProjectDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectDeployer.class);
    @Requirement
    private ArtifactDeployer deployer;

    @Override
    public void deploy(ProjectBuildingRequest buildingRequest, ProjectDeployerRequest request, ArtifactRepository artifactRepository) throws IOException, NoFileAssignedException {
        Artifact artifact = request.getProject().getArtifact();
        String packaging = request.getProject().getPackaging();
        File pomFile = request.getProject().getFile();
        List attachedArtifacts = request.getProject().getAttachedArtifacts();
        boolean isPomArtifact = "pom".equals(packaging);
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        } else {
            artifact.setFile(pomFile);
        }
        if (request.isUpdateReleaseInfo()) {
            artifact.setRelease(true);
        }
        artifact.setRepository(artifactRepository);
        int retryFailedDeploymentCount = request.getRetryFailedDeploymentCount();
        try {
            ArrayList<Artifact> deployableArtifacts = new ArrayList<Artifact>();
            if (isPomArtifact) {
                deployableArtifacts.add(artifact);
            } else {
                File file = artifact.getFile();
                if (file != null && file.isFile()) {
                    deployableArtifacts.add(artifact);
                } else {
                    if (!attachedArtifacts.isEmpty()) {
                        throw new NoFileAssignedException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                    }
                    throw new NoFileAssignedException("The packaging for this project did not assign a file to the build artifact");
                }
            }
            for (Artifact attached : attachedArtifacts) {
                try {
                    attached.setRepository(artifactRepository);
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.warn(attached.getId() + " has been attached with deprecated code, " + "try to upgrade the responsible plugin");
                }
                deployableArtifacts.add(attached);
            }
            this.deploy(buildingRequest, deployableArtifacts, artifactRepository, retryFailedDeploymentCount);
        }
        catch (ArtifactDeployerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void deploy(ProjectBuildingRequest request, Collection<Artifact> artifacts, ArtifactRepository deploymentRepository, int retryFailedDeploymentCount) throws ArtifactDeployerException {
        int retryFailedDeploymentCounter = Math.max(1, Math.min(10, retryFailedDeploymentCount));
        ArtifactDeployerException exception = null;
        for (int count = 0; count < retryFailedDeploymentCounter; ++count) {
            try {
                if (count > 0) {
                    LOGGER.info("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCounter);
                }
                this.deployer.deploy(request, deploymentRepository, artifacts);
                exception = null;
                break;
            }
            catch (ArtifactDeployerException e) {
                if (count + 1 < retryFailedDeploymentCounter) {
                    LOGGER.warn("Encountered issue during deployment: " + e.getLocalizedMessage());
                    LOGGER.debug(e.getMessage());
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

