/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.manager;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.manager.EnvFactoryManager;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=EnvFactoryManager.class, hint="default", instantiationStrategy="singleton")
public class DefaultEnvFactoryManager
implements EnvFactoryManager {
    private Map<String, EnvFactory> envFactoryCache = new HashMap<String, EnvFactory>();

    @Override
    public EnvFactory getEnvFactory(String className) throws NativeBuildException {
        EnvFactory envFactory = this.envFactoryCache.get(className);
        if (envFactory == null) {
            try {
                envFactory = (EnvFactory)Class.forName(className).newInstance();
                this.envFactoryCache.put(className, envFactory);
            }
            catch (Exception e) {
                throw new NativeBuildException("Unable to find EnvFactory: " + className);
            }
        }
        return envFactory;
    }
}

