

#
# add_to_table:
# 	theline: should be the entire _uncommented_ line.
#	type:    type of line.
#	enabled: is it enabled.
#	arg1..3: First three active arguments for the type.
#
function add_to_table(theline, type, is_enabled, arg1, arg2, arg3) {
	a_type[g_entries] = type;
	a_enable[g_entries] = is_enabled;
	a_wline[g_entries] = theline;
	a_arg1[g_entries] = arg1;
	a_arg2[g_entries] = arg2;
	a_arg3[g_entries] = arg3;

	g_entries = g_entries + 1;
}

BEGIN {
	T_SOURCE = "source";
	T_BUILD = "build";
	T_INCLUDE = "include";
	T_IDENT = "ident";
	T_MAXUSERS = "maxusers";
	T_OPTIONS = "options";
	T_MAKEOPT = "makeoptions";
	T_FS = "file-system";
	T_CONFIG = "config";
	T_PDEV = "pseudo-device";
	T_DEV = "device";

	g_entries = 0;
	a_type[0] = "";
	a_enable[0] = 0;
	a_wline[0] = "";
	a_arg1[0] = "";
	a_arg2[0] = "";
	a_arg3[0] = "";

	g_debug = 0;
}

#
# XXX problems: doesn't handle arguments with spaces, or quotes.
# XXX	i.e.: makeoptions, build, source, include, ident
#
function process_line(theline, thetype, index1, index2, index3, split_regexp,
			t1, t2, t3, is_enabled, pline, part_array, nparts, j) {
	if (g_debug >= 1) {
	    print "Processing ", thetype, " line.";
	}

	# See if this line is on.
	if (theline ~ /^#/) {
	    is_enabled = 0;
	} else {
	    is_enabled = 1;
	}

	# Delete leading spaces and #s.
	pline = gensub(/^[[:space:]]*(#+[[:space:]]*)+/, "", "g", theline);

	# Split the line into parts.
	if (split_regexp != "") {
	    # Allow a splitting pattern to be passed in.
	    # This is to aproximate quotation of arguments. XXX

	    # First split it, then trim spaces.
	    nparts = split(pline, part_array, split_regexp);
	    for (j = 1 ; j <= nparts ; j++) {
		gsub(/^[[:space:]]+/, "", part_array[j]);
		gsub(/[[:space:]]+$/, "", part_array[j]);
	    }
	} else
	    nparts = split(pline, part_array);

	# Figure out which part(s) of the line to save.
	if (index1 > 0) {
	    t1 = part_array[index1];
	} else {
	    t1 = "";
	}
	if (index2 > 0) {
	    t2 = part_array[index2];
	} else {
	    t2 = "";
	}
	if (index3 > 0) {
	    t3 = part_array[index3];
	} else {
	    t3 = "";
	}

	# Add it to the table.
	if (g_debug >= 2)
	    printf("> %s\nType:%s  On:%d  Arg1:%s  Arg2:%s  Arg3:%s\n", 
			pline, thetype, is_enabled, t1, t2, t3);

	add_to_table(pline, thetype, is_enabled, t1, t2, t3);

}

#   "  "     "#"  "  "       "foo"        "  "      "at"  "  " 
#  "bar"
/^[[:space:]]*#*[[:space:]]*[^[:space:]]+[[:space:]]+at[[:space:]]+\
[^[:space:]]+/ {
	process_line($0, T_DEV, 1, 3, -1);
}

/^[[:space:]]*#*[[:space:]]*pseudo-device[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_PDEV, 2, 3, -1);
}

# XXX: This needs some work to handle options set to a value.
# XXX: This needs some work to handle multiple options to a line.
#   "  "     "#"  "   "    "options"   "   "     "FOO"
/^[[:space:]]*#*[[:space:]]*options[[:space:]]+[^[:space:]]+/ { 
	process_line($0, T_OPTIONS, 2, -1, -1);
}

#   "  "     "#"  "   "    "file-system"   "  "     "FOO"
/^[[:space:]]*#*[[:space:]]*file-system[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_FS, 2, -1, -1);
}

#   "  "     "#"  "   "    "makeoptions"   "  "     "FOO"
/^[[:space:]]*#*[[:space:]]*makeoptions[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_MAKEOPT, 2, -1, -1);
}

#  "   "     "#"  "   "    "config"  "  "     "netbsd"      "   "
# "root" "  "  "on"   "  "    "sd0a"        "  "      "type"  "   "
# "ffs"
/^[[:space:]]*#*[[:space:]]*config[[:space:]]+[^[:space:]]+[[:space:]]+\
root[[:space:]]+on[[:space:]]+[^[:space:]]+[[:space:]]+type[[:space:]]+\
[^[:space:]]+/ {
	process_line($0, T_CONFIG, 2, 5, 7);
}

#   "  "     "#"  "  "     "source"  "  "      "/foo/bar"
/^[[:space:]]*#*[[:space:]]*source[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_SOURCE, 2, -1, -1);
}

#   "  "     "#"  "  "     "build"   "  "      "/foo/bar"
/^[[:space:]]*#*[[:space:]]*build[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_BUILD, 2, -1, -1);
}

#   "  "     "#"  "  "     "maxusers"   "  "      "123"
/^[[:space:]]*#*[[:space:]]*maxusers[[:space:]]+[[:digit:]]+/ {
	process_line($0, T_MAXUSERS, 2, -1, -1);
}

#   "  "     "#"   "  "    "ident"   "  "   \"foo\"
/^[[:space:]]*#*[[:space:]]*ident[[:space:]]+"[^"]*"/ {
	# XXX not quite right action wrt quoted info.
	process_line($0, T_IDENT, 2, -1, -1, "\[\"\]\+");
}

# ---- snip ----

END {
# Write the array out.
    printf("%d\n", g_entries) >"setconf.db";
    for (j = 0 ; j < g_entries ; j = j + 1) {
	# Line, type, enabled, arg1, arg2, arg3
	printf("%s\n%s\n%s\n%s\n%s\n%d\n", a_type[j], a_arg1[j], a_arg2[j],
		a_arg3[j], a_wline[j], a_enable[j]) >>"setconf.db";
    }
}
