#define GRFIOCRESET            _IOWR('G', (32+0), struct VDPgInfo)
#define GRFIOCKILLIO           _IO('G', (32+1))
#define GRFIOCSETMODE1         _IOWR('G', (32+2), struct VDPgInfo)
#define GRFIOCSETENTRIES       _IOWR('G', (32+3), struct VDEntryRecord)
#define GRFIOCSETGAMMA         _IOWR('G', (32+4), struct VDGammaRecord)
#define GRFIOCGRAYPAGE         _IOWR('G', (32+5), struct VDPgInfo)
#define GRFIOCGRAYSCREEN        GRFIOCGRAYPAGE
#define GRFIOCSETGRAY          _IOWR('G', (32+6), struct VDPgInfo)
#define GRFIOCSETINTERRUPT     _IOWR('G', (32+7), struct VDPgInfo)
#define GRFIOCDIRECTSETENTRIES _IOWR('G', (32+8), struct VDEntryRecord)
#define GRFIOCSETDEFAULTMODE   _IOWR('G', (32+9), struct VDPgInfo)

#define GRFIOCGETMODE1         _IOWR('G', (64+2), struct VDPgInfo)
#define GRFIOCGETENTRIES       _IOWR('G', (64+3), struct VDEntryRecord)
#define GRFIOCGETPAGECNT       _IOWR('G', (64+4), struct VDPgInfo)
#define GRFIOCGETPAGES          GRFIOCGETPAGECNT
#define GRFIOCGETBASEADDR      _IOWR('G', (64+5), struct VDPgInfo)
#define GRFIOCGETPAGEBASE       GRFIOCBASEADDR
#define GRFIOCGETGRAY          _IOWR('G', (64+6), struct VDPgInfo)
#define GRFIOCGETINTERRUPT     _IOWR('G', (64+7), struct VDPgInfo)
#define GRFIOCGETGAMMA         _IOWR('G', (64+8), struct VDGammaRecord)
#define GRFIOCGETDEFAULTMODE   _IOWR('G', (64+9), struct VDPgInfo)

struct VDPgInfo {
  u_int16_t csMode;
  u_int32_t csData;
  u_int16_t csPage;
  u_int8_t *csBaseAddr;
};

typedef struct VDPgInfo VDPgInfo;

struct RGBColor {
  unsigned short red;
  unsigned short green;
  unsigned short blue;
};

typedef struct RGBColor RGBColor;

struct ColorSpec {
  short value;
  RGBColor color;
};

typedef struct ColorSpec ColorSpec;

struct VDEntryRecord {
  struct ColorSpec *csTable;
  short csStart, csCount;
  int length;
};

typedef struct VDEntryRecord VDEntry;

struct VDGammaRecord {
  struct GammaTable *csGTable;
  int length;
};

typedef struct VDGammaRecord VDGamma;

struct GammaTable {
  short gVersion;     /* {gtab version, currently 0} */
  short gType;        /* {drHwId value} */
  short gFormulaSize; /* {size of formula data, below} */
  short gChanCnt;     /* {# of component channels} */
  short gDataCnt;     /* {# of values per channel} = 2gDataWidth ?*/
  short gDataWidth;   /* {size of data in tables} */
  u_int8_t data[4];
  /*
     {gamma correction look-up tables}
     gFormulaData: array [0.. gFormulaSize] of byte;

     {data for gamma calculation formula}
     gData: array [0.. gDataCnt] of byte;

     Repeat for R, G, B in order, up to gChanCnt.  

     The standard tables included in Apple's driver have only one table,
     which is applied to all three output channels.  
     */
};

typedef struct GammaTable GammaTable;
