[![Build Status](https://travis-ci.org/puppetlabs/trapperkeeper.png?branch=master)](https://travis-ci.org/puppetlabs/trapperkeeper)

Trapperkeeper is a Clojure framework for hosting long-running applications and services.  You can think of it as a sort of "binder" for Ring applications and other modular bits of Clojure code.

* [Overview](Overview.md)
 * [Credits and Origins](Overview.md#credits-and-origins)
 * [Hopes and Dreams](Overview.md#hopes-and-dreams)
* [Trapperkeeper Quick Start](Trapperkeeper-Quick-Start.md)
 * [Leiningen Template](Trapperkeeper-Quick-Start.md#lein-template)
 * [Hello World](Trapperkeeper-Quick-Start.md#hello-world)
* [Defining Services](Defining-Services.md)
 * [`defservice`](Defining-Services.md#defservice)
 * [Service Lifecycle](Defining-Services.md#service-lifecycle)
 * [Example Service](Defining-Services.md#example-service)
 * [Multi-arity Protocol Functions](Defining-Services.md#multi-arity-protocol-functions)
 * [`service`](Defining-Services.md#service)
 * [Optional Services](Defining-Services.md#optional-services)
* [Referencing Services](Referencing-Services.md)
 * [Individual Functions](Referencing-Services.md#individual-functions)
 * [A Map of Functions](Referencing-Services.md#a-map-of-functions)
 * [Plumatic Graph Binding Form](Referencing-Services.md#plumatic-graph-binding-form)
 * [Via Service Protocol](Referencing-Services.md#via-service-protocol)
* [Bootstrapping](Bootstrapping.md)
* [Built-in Services](Built-in-Services.md)
 * [Configuration Service](Built-in-Configuration-Service.md)
 * [Shutdown Service](Built-in-Shutdown-Service.md)
 * [nREPL Service](Built-in-nREPL-Service.md)
* [Error Handling](Error-Handling.md)
* [Service Interfaces](Service-Interfaces.md)
* [Command Line Arguments](Command-Line-Arguments.md)
 * [Other Ways to Boot](Command-Line-Arguments.md#other-ways-to-boot)
* [Restart File Feature for Determining When Services Have Been Started](Restart-File.md)
* [Test Utils](Test-Utils.md)
* [Trapperkeeper Best Practices](Trapperkeeper-Best-Practices.md)
 * [To Trapperkeeper Or Not To Trapperkeeper](Trapperkeeper-Best-Practices.md#to-trapperkeeper-or-not-to-trapperkeeper)
 * [Separating Logic From Service Definitions](Trapperkeeper-Best-Practices.md#separating-logic-from-service-definitions)
 * [On Lifecycles](Trapperkeeper-Best-Practices.md#on-lifecycles)
 * [Testing Services](Trapperkeeper-Best-Practices.md#testing-services)
* [Using the "Reloaded" Pattern](Reloaded-Pattern.md)
* [Experimental Plugin System](Plugin-System.md)
* [Polyglot Support](Polyglot-Support.md)
* [Helpful Leiningen Features](Helpful-Leiningen-Features.md)
