# Privacy Policy

This project tracks data about users of the project website, the project repository, and any other officially affiliated services.

This document tells you what data is tracked and how the data is used.

## Definitions

-   "Project" means the source repository and all officially affiliated services, including websites, applications, content, and products ("Services").
-   "Website" is defined to comprise the main project website, officially affiliated websites, and the hosted (GitHub) source repository.
-   "We/Us" refers to the principal body (project owners) governing the project.

## Website

The website collects non-personally-identifying information of the sort that web browsers and servers typically make available, such as the browser type, language preference, referring site, and the date and time of each visitor request. The purpose in collecting non-personally-identifying information is to better understand how visitors use our Services. From time to time, we may release non-personally-identifying information in the aggregate, e.g., by publishing a report on usage trends.

The website also collects potentially personally-identifying information, such as Internet Protocol (IP) addresses. We may use this information to fight spam and other abuse. The website does not, however, use such information to identify its visitors and does not disclose such information, other than under the same circumstances that it uses and discloses personally-identifying information, as described below.

The website uses Google Analytics to monitor and analyze user behavior. This service provides information on users' demographics, age, location, and interest categories, when such information is available. This information is not used to identify individual users, but can, in some cases, be very specific. You can learn more about the information gathered and retained by this service at the [Google Analytics privacy policy][google-analytics-privacy-policy]. You can opt out of Google Analytics entirely with the [Google Analytics opt-out browser add-on][google-analytics-opt-out-browser-add-on].

## Use of Personally-Identifying Information

The project will not rent or sell potentially personally-identifying and personally-identifying information to anyone. We may use personally-identifying information collected about you to provide you with tailored news, notes, and recommendations.

If you have supplied us with your email address, we may occasionally send you an email to tell you about new features, solicit feedback, or provide project updates. If you send us a request (e.g., via a support email or via one of our feedback mechanisms), we reserve the right to publish the request in order to help us clarify or respond to the request or to help us support other users.

We may be required to disclose personally-identifying information if legally compelled to by authorities. If we are going to share your information in response to legal process, we will give you advance notice so you can challenge the information's transfer (e.g., by seeking court intervention), unless we are prohibited from doing so by law or court order. We will object to requests for information about users of our Services that we believe to be improper.

We do not disclose your personal information to unaffiliated third parties who may want to offer you their own products and services unless you have requested or authorized us to do so.

## Cookies

A cookie is a string of information that a website stores on a visitor's computer and that the visitor's browser provides to the website each time the visitor returns.

The website may use cookies and other technologies, such as pixels and local storage, to help identify and track visitors and their usage of the website. Website visitors who do not wish to have cookies placed on their computers should set their browsers to refuse cookies before using the website.

We respect browser Do Not Track ("DNT") settings. If you have DNT enabled, we will not set cookies. Some third-party services, such as Google Analytics, may place their own cookies in your browser. This Privacy Policy covers the use of cookies by the project only and not the use of cookies by third parties.

## Disclosure of Log Information

All user information is retained in raw form for such time as deemed appropriate by the project. Raw log data is not shared with third parties, but may be shared in aggregate. For example, we may publish blog posts or reports on website usage.

We also analyze log data for a variety of reasons, including counting unique visitors and debugging production problems. This helps us to better understand usage patterns and make project decisions.

## Links to Other Websites

The project may contain links to other websites. Any personal information you provide on the linked pages is provided directly to that third party and is subject to that third party's privacy policy. Except as described above, we are not responsible for the content or privacy and security practices and policies of websites to which we link. Links from the project to third parties or to other sites are provided for your convenience. We encourage you to learn about their privacy and security practices and policies before providing them with personal information.

## Data Storage

The project uses third-party vendors and hosting partners, such as Linode and Amazon, for hardware, software, networking, storage, and related technology needed to support the project.

## Data Security

The website uses encryption (HTTPS/TLS) to protect transmitted data. However, no Internet data transmission is completely secure, and, thus, security is not guaranteed. You use the project and its Services at your own risk, and you are responsible for taking reasonable security measures.

## Jurisdiction

The website is hosted in the United States. This Privacy Policy is intended to comply with privacy laws in the United States and may not comply with all privacy laws in other countries.

If you are a non-US user of the project, by using the project and providing us with data, you acknowledge, agree, and provide your consent that your personal information may be processed in the United States for the purposes identified in this Privacy Policy. In addition, such data may be stored on servers located outside your resident jurisdiction, which may have less stringent privacy practices than your own. By using the project and providing us with your data, you consent to the transfer of such data and any less stringent privacy practices.

## Changes

This document is a living document which may be periodically updated at the project's sole discretion. Please refer to the [git history for this document][stdlib-git-commit-log-privacy-policy] to view the changes.

We encourage visitors to frequently check this document for any changes to our Privacy Policy. Your continued use of the website and the project after any change in this Privacy Policy will constitute your acceptance of such change.

## Contact

If you have any questions or concerns about how we track user information, or how that information is used, please do not hesitate to contact us.

## Attribution

Parts of this policy document were originally included in

-   [WordPress.org Privacy Policy][wordpress-privacy-policy]
-   [npm, Inc Privacy Policy][npm-privacy-policy]
-   [Medium Privacy Policy][medium-privacy-policy]

all of which were licensed under Creative Commons Attribution-ShareAlike licenses.

## License

This document may be reused under a [Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0) license][cc-by-sa-4.0].

## Copyright

Copyright © The Stdlib [Authors][stdlib-authors].

<section class="links">

[google-analytics-privacy-policy]: https://support.google.com/analytics/answer/2700409?hl=en&utm_id=ad

[google-analytics-opt-out-browser-add-on]: https://support.google.com/analytics/answer/181881?hl=en&ref_topic=2919631

[stdlib-git-commit-log-privacy-policy]: https://github.com/stdlib-js/stdlib/commits/develop/PRIVACY

[wordpress-privacy-policy]: https://wordpress.org/about/privacy/

[npm-privacy-policy]: https://docs.npmjs.com/policies/privacy

[medium-privacy-policy]: https://github.com/Medium/medium-policy/blob/3c76f50e5e6a529c8352c85c9ed596ef95f863b7/privacy-policy.md

[stdlib-authors]: https://github.com/stdlib-js/stdlib/graphs/contributors

[cc-by-sa-4.0]: https://creativecommons.org/licenses/by-sa/4.0/

</section>

<!-- /.links -->
