/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.coordinates;

import org.boehn.kmlframework.coordinates.Coordinate;
import org.boehn.kmlframework.coordinates.EarthCoordinate;
import org.boehn.kmlframework.utils.Ellipsoid;

public class CartesianCoordinate
implements Coordinate {
    private double x;
    private double y;
    private double z;

    public CartesianCoordinate() {
    }

    public CartesianCoordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double distanceTo(CartesianCoordinate cartesianCoordinate) {
        return Math.sqrt(Math.pow(Math.abs(cartesianCoordinate.getX() - this.x), 2.0) + Math.pow(Math.abs(cartesianCoordinate.getY() - this.y), 2.0) + Math.pow(Math.abs(cartesianCoordinate.getZ() - this.z), 2.0));
    }

    public void rotateAroundZAxis(double rotation) {
        double xTemp = Math.cos(rotation) * this.x - Math.sin(rotation) * this.y;
        this.y = Math.sin(rotation) * this.x + Math.cos(rotation) * this.y;
        this.x = xTemp;
    }

    public void rotateAroundYAxis(double rotation) {
        double xTemp = Math.cos(rotation) * this.x + Math.sin(rotation) * this.z;
        this.z = -Math.sin(rotation) * this.x + Math.cos(rotation) * this.z;
        this.x = xTemp;
    }

    public void rotateAroundXAxis(double rotation) {
        double yTemp = Math.cos(rotation) * this.y - Math.sin(rotation) * this.z;
        this.z = Math.sin(rotation) * this.y + Math.cos(rotation) * this.z;
        this.y = yTemp;
    }

    public void add(CartesianCoordinate cartesianCoordinate) {
        this.x += cartesianCoordinate.getX();
        this.y += cartesianCoordinate.getY();
        this.z += cartesianCoordinate.getZ();
    }

    public void subtract(CartesianCoordinate cartesianCoordinate) {
        this.x -= cartesianCoordinate.getX();
        this.y -= cartesianCoordinate.getY();
        this.z -= cartesianCoordinate.getZ();
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void normalize() {
        double length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public void scale(double scalingFactor) {
        this.x *= scalingFactor;
        this.y *= scalingFactor;
        this.z *= scalingFactor;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public EarthCoordinate toEarthCoordinate(EarthCoordinate location, Double rotation, CartesianCoordinate localReferenceCoordinate, CartesianCoordinate scale) {
        double xTransformed = this.x;
        double yTransformed = this.y;
        double zTransformed = this.z;
        if (scale != null) {
            xTransformed = this.x * scale.getX();
            yTransformed = this.y * scale.getY();
            zTransformed = this.z * scale.getZ();
        }
        if (localReferenceCoordinate != null) {
            xTransformed -= localReferenceCoordinate.getX();
            yTransformed -= localReferenceCoordinate.getY();
            zTransformed -= localReferenceCoordinate.getZ();
        }
        if (rotation != null) {
            double xTmp = xTransformed;
            xTransformed = Math.cos(rotation) * xTmp + Math.sin(rotation) * yTransformed;
            yTransformed = -Math.sin(rotation) * xTmp + Math.cos(rotation) * yTransformed;
        }
        if (location != null) {
            xTransformed = location.getLongitude() + xTransformed * Ellipsoid.meterToLongitude(location.getLatitude());
            yTransformed = location.getLatitude() + yTransformed * Ellipsoid.meterToLatitude(location.getLatitude());
            zTransformed += location.getAltitude().doubleValue();
        }
        return new EarthCoordinate(zTransformed, yTransformed, xTransformed);
    }
}

