/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__FOOBARCLASSADAPTER_HPP)                                 
#include <FooBarClassAdapter.hpp>
#endif

using namespace corelinux;
//
// Default constructor
//

FooBarClassAdapter::FooBarClassAdapter( void )
   :
   Adapter( ),
   Foo( ),
   Bar( )
{
   ;  // do nothing
}

//
// Constructor with coordinates
// We adhere to the Foo constraints by checking
// the arguments with the boundries.
//

FooBarClassAdapter::FooBarClassAdapter( Int aX, Int aY ) throw(Exception)
   :
   Adapter( ),
   Foo( ),
   Bar( aX, aY )
{
   if( (aX < Foo::getMinimumHorizontalPosition() ||
        aX > Foo::getMaximumHorizontalPosition() ) ||
       (aY < Foo::getMinimumVerticalPosition() ||
        aY > Foo::getMaximumVerticalPosition() ) )
   {
      throw Exception("Invalid Foo Boundry",LOCATION);
   }
   else
   {
      ;  // do nothing
   }
}

//
// Copy constructor
//

FooBarClassAdapter::FooBarClassAdapter( FooBarClassAdapterCref aRef )
   :
   Adapter( aRef ),
   Foo( aRef ),
   Bar( aRef )
{
   ;  // do nothing
}

//
// Destructor
//

FooBarClassAdapter::~FooBarClassAdapter( void )
{
   ;  // do nothing
}

//
// Assignment operator
//

FooBarClassAdapterRef FooBarClassAdapter::operator=
   ( 
      FooBarClassAdapterCref aRef 
   )
{
   if( *this == aRef )
   {
      ; //  do nothing
   }
   else
   {
      Bar::operator =( aRef );
   }
   return (*this);
}

//
// Equality test
//

bool FooBarClassAdapter::operator==( FooBarClassAdapterCref aRef )
{
   return (Bar::operator ==(aRef));
}

//
// Gets Y coordinate 
//

IntCref FooBarClassAdapter::getVerticalPosition(void) const
{
   return getVertical();
}

//
// Gets X coordinate 
//
   
IntCref FooBarClassAdapter::getHorizontalPosition(void) const
{
   return getHorizontal();
}

//
// Set the Y coordinate after validating with Foo
//
   
void FooBarClassAdapter::setVerticalPosition(Int aY) throw(Exception)
{
   if(aY >= Foo::getMinimumVerticalPosition() &&
    aY <= Foo::getMaximumVerticalPosition() )
   {
      setVertical(aY);
   }
   else
   {
      throw Exception("Invalid Vertical Coordinate",LOCATION);
   }
}

//
// Set the X coordinate after validating with Foo
//
   
void FooBarClassAdapter::setHorizontalPosition(Int aX) throw(Exception)
{
   if(aX >= Foo::getMinimumVerticalPosition() &&
    aX <= Foo::getMaximumVerticalPosition() )
   {
      setHorizontal(aX);
   }
   else
   {
      throw Exception("Invalid Horizontal Coordinate",LOCATION);
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/01/19 14:30:07 $
   $Locker:  $
*/

