/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define KERNEL26_TYPE_LED (kernel26_led_get_type ())
#define KERNEL26_LED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL26_TYPE_LED, Kernel26Led))
#define KERNEL26_LED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL26_TYPE_LED, Kernel26LedClass))
#define KERNEL26_IS_LED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL26_TYPE_LED))
#define KERNEL26_IS_LED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL26_TYPE_LED))
#define KERNEL26_LED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL26_TYPE_LED, Kernel26LedClass))

typedef struct _Kernel26Led Kernel26Led;
typedef struct _Kernel26LedClass Kernel26LedClass;
typedef struct _Kernel26LedPrivate Kernel26LedPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Kernel26LedGetNameData Kernel26LedGetNameData;
typedef struct _Kernel26LedSetBrightnessData Kernel26LedSetBrightnessData;
typedef struct _Kernel26LedSetBlinkingData Kernel26LedSetBlinkingData;
typedef struct _Kernel26LedBlinkSecondsData Kernel26LedBlinkSecondsData;
typedef struct _Kernel26LedSetNetworkingData Kernel26LedSetNetworkingData;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Kernel26Led {
	FsoFrameworkAbstractObject parent_instance;
	Kernel26LedPrivate * priv;
};

struct _Kernel26LedClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _Kernel26LedPrivate {
	FsoFrameworkSubsystem* subsystem;
	gint max_brightness;
	gchar* sysfsnode;
	gchar* brightness;
	gchar* trigger;
	gchar* triggers;
	guint blinktimeoutwatch;
};

struct _Kernel26LedGetNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Led* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _Kernel26LedSetBrightnessData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Led* self;
	gint brightness;
	gint _tmp0_;
	gint _tmp1_;
	gint percent;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
};

struct _Kernel26LedSetBlinkingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Led* self;
	gint delay_on;
	gint delay_off;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_;
};

struct _Kernel26LedBlinkSecondsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Led* self;
	gint seconds;
	gint delay_on;
	gint delay_off;
	gint _tmp0_;
	GError* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GError * _inner_error_;
};

struct _Kernel26LedSetNetworkingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Led* self;
	gchar* iface;
	gchar* mode;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	gchar* _tmp14_;
	gchar* cleanmode;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gchar** element_collection;
	gint element_collection_length1;
	gint _element_collection_size_;
	gint element_it;
	gchar* _tmp18_;
	gchar* element;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError * _inner_error_;
};


static gpointer kernel26_led_parent_class = NULL;
static guint kernel26_led_counter;
static guint kernel26_led_counter = 0U;
extern gchar* sys_class_net;
static FreeSmartphoneDeviceLEDIface* kernel26_led_free_smartphone_device_led_parent_iface = NULL;
static GType kernel26_led_type_id = 0;
extern gchar* sysfs_root;
gchar* sysfs_root = NULL;
gchar* sys_class_net = NULL;
extern gchar* sys_class_leds;
gchar* sys_class_leds = NULL;
extern GList* instances;
GList* instances = NULL;

GType kernel26_led_get_type (void) G_GNUC_CONST;
GType kernel26_led_register_type (GTypeModule * module);
#define KERNEL26_LED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL26_TYPE_LED, Kernel26LedPrivate))
enum  {
	KERNEL26_LED_DUMMY_PROPERTY
};
#define KERNEL26_LED_MODULE_NAME "fsodevice.kernel26_leds"
Kernel26Led* kernel26_led_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
Kernel26Led* kernel26_led_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
void kernel26_led_initTriggers (Kernel26Led* self);
static gchar* kernel26_led_real_repr (FsoFrameworkAbstractObject* base);
void kernel26_led_cleanTimeout (Kernel26Led* self);
void kernel26_led_setTimeout (Kernel26Led* self, gint seconds);
gboolean kernel26_led_onTimeout (Kernel26Led* self);
static gboolean _kernel26_led_onTimeout_gsource_func (gpointer self);
static gint _kernel26_led_valueToPercent (Kernel26Led* self, gint value);
static gint _kernel26_led_percentToValue (Kernel26Led* self, gint percent);
static void kernel26_led_get_name_data_free (gpointer _data);
void kernel26_led_get_name (Kernel26Led* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* kernel26_led_get_name_finish (Kernel26Led* self, GAsyncResult* _res_, GError** error);
static gboolean kernel26_led_get_name_co (Kernel26LedGetNameData* _data_);
static void kernel26_led_real_set_brightness_data_free (gpointer _data);
static void kernel26_led_real_set_brightness (FreeSmartphoneDeviceLED* base, gint brightness, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_led_real_set_brightness_co (Kernel26LedSetBrightnessData* _data_);
static void kernel26_led_real_set_blinking_data_free (gpointer _data);
static void kernel26_led_real_set_blinking (FreeSmartphoneDeviceLED* base, gint delay_on, gint delay_off, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_led_real_set_blinking_co (Kernel26LedSetBlinkingData* _data_);
static void kernel26_led_real_blink_seconds_data_free (gpointer _data);
static void kernel26_led_real_blink_seconds (FreeSmartphoneDeviceLED* base, gint seconds, gint delay_on, gint delay_off, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_led_real_blink_seconds_co (Kernel26LedBlinkSecondsData* _data_);
static void kernel26_led_blink_seconds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void kernel26_led_real_set_networking_data_free (gpointer _data);
static void kernel26_led_real_set_networking (FreeSmartphoneDeviceLED* base, const gchar* iface, const gchar* mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_led_real_set_networking_co (Kernel26LedSetNetworkingData* _data_);
static void kernel26_led_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Kernel26Led* kernel26_led_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	Kernel26Led * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp22_;
	FsoFrameworkSubsystem* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	FsoFrameworkLogger* _tmp30_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (Kernel26Led*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = self->priv->sysfsnode;
	_tmp5_ = g_strconcat (_tmp4_, "/max_brightness", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = fso_framework_file_handling_read (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = atoi (_tmp8_);
	self->priv->max_brightness = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp10_ = self->priv->max_brightness;
	if (_tmp10_ == 0) {
		FsoFrameworkSmartKeyFile* _tmp11_;
		gint _tmp12_ = 0;
		_tmp11_ = fso_framework_theConfig;
		_tmp12_ = fso_framework_smart_key_file_intValue (_tmp11_, KERNEL26_LED_MODULE_NAME, "max_brightness", 255);
		self->priv->max_brightness = _tmp12_;
	}
	_tmp13_ = sysfsnode;
	_tmp14_ = g_strconcat (_tmp13_, "/brightness", NULL);
	_g_free0 (self->priv->brightness);
	self->priv->brightness = _tmp14_;
	_tmp15_ = sysfsnode;
	_tmp16_ = g_strconcat (_tmp15_, "/trigger", NULL);
	_g_free0 (self->priv->trigger);
	self->priv->trigger = _tmp16_;
	_tmp18_ = self->priv->brightness;
	_tmp19_ = fso_framework_file_handling_isPresent (_tmp18_);
	if (!_tmp19_) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
		_tmp20_ = self->priv->trigger;
		_tmp21_ = fso_framework_file_handling_isPresent (_tmp20_);
		_tmp17_ = !_tmp21_;
	}
	_tmp22_ = _tmp17_;
	if (_tmp22_) {
		FsoFrameworkLogger* _tmp23_;
		_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_error (_tmp23_, "^^^ sysfs class is damaged; skipping.");
		return self;
	}
	_tmp24_ = subsystem;
	_tmp25_ = sysfsnode;
	_tmp26_ = g_path_get_basename (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s/%s", FSO_FRAMEWORK_DEVICE_LedServicePath, _tmp27_);
	_tmp29_ = _tmp28_;
	fso_framework_subsystem_registerObjectForService (_tmp24_, FREE_SMARTPHONE_DEVICE_TYPE_LED, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, _tmp29_, (FreeSmartphoneDeviceLED*) self);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	kernel26_led_initTriggers (self);
	_tmp30_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp30_, "Created");
	return self;
}


Kernel26Led* kernel26_led_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return kernel26_led_construct (KERNEL26_TYPE_LED, subsystem, sysfsnode);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* kernel26_led_real_repr (FsoFrameworkAbstractObject* base) {
	Kernel26Led * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (Kernel26Led*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


void kernel26_led_initTriggers (Kernel26Led* self) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->triggers;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		FsoFrameworkLogger* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp1_ = self->priv->trigger;
		_tmp2_ = fso_framework_file_handling_read (_tmp1_);
		_g_free0 (self->priv->triggers);
		self->priv->triggers = _tmp2_;
		_tmp3_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp4_ = self->priv->triggers;
		_tmp5_ = g_strdup_printf ("^^^ supports the following triggers: '%s'", _tmp4_);
		_tmp6_ = _tmp5_;
		fso_framework_logger_info (_tmp3_, _tmp6_);
		_g_free0 (_tmp6_);
	}
}


void kernel26_led_cleanTimeout (Kernel26Led* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blinktimeoutwatch;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->blinktimeoutwatch;
		g_source_remove (_tmp1_);
	}
}


static gboolean _kernel26_led_onTimeout_gsource_func (gpointer self) {
	gboolean result;
	result = kernel26_led_onTimeout (self);
	return result;
}


void kernel26_led_setTimeout (Kernel26Led* self, gint seconds) {
	gint _tmp0_;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	kernel26_led_cleanTimeout (self);
	_tmp0_ = seconds;
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp0_, _kernel26_led_onTimeout_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->blinktimeoutwatch = _tmp1_;
}


gboolean kernel26_led_onTimeout (Kernel26Led* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	free_smartphone_device_led_set_brightness ((FreeSmartphoneDeviceLED*) self, 0, NULL, NULL);
	result = FALSE;
	return result;
}


static gint _kernel26_led_valueToPercent (Kernel26Led* self, gint value) {
	gint result = 0;
	gint _tmp0_;
	gdouble max;
	gint _tmp1_;
	gdouble v;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->max_brightness;
	max = (gdouble) _tmp0_;
	_tmp1_ = value;
	v = (gdouble) _tmp1_;
	result = (gint) ((100.0 / max) * v);
	return result;
}


static gint _kernel26_led_percentToValue (Kernel26Led* self, gint percent) {
	gint result = 0;
	gint _tmp0_;
	gdouble p;
	gint _tmp1_;
	gdouble max;
	gdouble value = 0.0;
	gint _tmp2_;
	gdouble _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = percent;
	p = (gdouble) _tmp0_;
	_tmp1_ = self->priv->max_brightness;
	max = (gdouble) _tmp1_;
	_tmp2_ = percent;
	if (_tmp2_ >= 100) {
		gint _tmp3_;
		_tmp3_ = self->priv->max_brightness;
		value = (gdouble) _tmp3_;
	} else {
		gint _tmp4_;
		_tmp4_ = percent;
		if (_tmp4_ <= 0) {
			value = (gdouble) 0;
		} else {
			gdouble _tmp5_;
			gdouble _tmp6_;
			_tmp5_ = p;
			_tmp6_ = max;
			value = (_tmp5_ / 100.0) * _tmp6_;
		}
	}
	_tmp7_ = value;
	result = (gint) _tmp7_;
	return result;
}


static void kernel26_led_get_name_data_free (gpointer _data) {
	Kernel26LedGetNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26LedGetNameData, _data_);
}


void kernel26_led_get_name (Kernel26Led* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26LedGetNameData* _data_;
	Kernel26Led* _tmp0_;
	_data_ = g_slice_new0 (Kernel26LedGetNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_led_get_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_led_get_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_led_get_name_co (_data_);
}


gchar* kernel26_led_get_name_finish (Kernel26Led* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	Kernel26LedGetNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel26_led_get_name_co (Kernel26LedGetNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sysfsnode;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_path_get_basename (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_led_real_set_brightness_data_free (gpointer _data) {
	Kernel26LedSetBrightnessData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26LedSetBrightnessData, _data_);
}


static void kernel26_led_real_set_brightness (FreeSmartphoneDeviceLED* base, gint brightness, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Led * self;
	Kernel26LedSetBrightnessData* _data_;
	Kernel26Led* _tmp0_;
	gint _tmp1_;
	self = (Kernel26Led*) base;
	_data_ = g_slice_new0 (Kernel26LedSetBrightnessData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_led_real_set_brightness);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_led_real_set_brightness_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = brightness;
	_data_->brightness = _tmp1_;
	kernel26_led_real_set_brightness_co (_data_);
}


static void kernel26_led_real_set_brightness_finish (FreeSmartphoneDeviceLED* base, GAsyncResult* _res_, GError** error) {
	Kernel26LedSetBrightnessData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel26_led_real_set_brightness_co (Kernel26LedSetBrightnessData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->brightness;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _kernel26_led_percentToValue (_data_->self, _data_->_tmp0_);
	_data_->percent = _data_->_tmp1_;
	kernel26_led_cleanTimeout (_data_->self);
	_data_->_tmp2_ = _data_->self->priv->trigger;
	fso_framework_file_handling_write ("none", _data_->_tmp2_, FALSE);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_strdup_printf ("%i", _data_->percent);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->self->priv->brightness;
	fso_framework_file_handling_write (_data_->_tmp4_, _data_->_tmp5_, FALSE);
	_g_free0 (_data_->_tmp4_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_led_real_set_blinking_data_free (gpointer _data) {
	Kernel26LedSetBlinkingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26LedSetBlinkingData, _data_);
}


static void kernel26_led_real_set_blinking (FreeSmartphoneDeviceLED* base, gint delay_on, gint delay_off, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Led * self;
	Kernel26LedSetBlinkingData* _data_;
	Kernel26Led* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (Kernel26Led*) base;
	_data_ = g_slice_new0 (Kernel26LedSetBlinkingData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_led_real_set_blinking);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_led_real_set_blinking_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = delay_on;
	_data_->delay_on = _tmp1_;
	_tmp2_ = delay_off;
	_data_->delay_off = _tmp2_;
	kernel26_led_real_set_blinking_co (_data_);
}


static void kernel26_led_real_set_blinking_finish (FreeSmartphoneDeviceLED* base, GAsyncResult* _res_, GError** error) {
	Kernel26LedSetBlinkingData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean kernel26_led_real_set_blinking_co (Kernel26LedSetBlinkingData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	kernel26_led_initTriggers (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->triggers;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = string_contains (_data_->_tmp0_, "timer");
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_UNSUPPORTED, "Kernel support for timer led class trigger missing.");
		_data_->_inner_error_ = _data_->_tmp2_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	kernel26_led_cleanTimeout (_data_->self);
	_data_->_tmp3_ = _data_->self->priv->trigger;
	fso_framework_file_handling_write ("timer", _data_->_tmp3_, FALSE);
	_data_->_tmp4_ = _data_->delay_on;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strdup_printf ("%i", _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->self->priv->sysfsnode;
	_data_->_tmp8_ = g_strconcat (_data_->_tmp7_, "/delay_on", NULL);
	_data_->_tmp9_ = _data_->_tmp8_;
	fso_framework_file_handling_write (_data_->_tmp6_, _data_->_tmp9_, FALSE);
	_g_free0 (_data_->_tmp9_);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp10_ = _data_->delay_off;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", _data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->self->priv->sysfsnode;
	_data_->_tmp14_ = g_strconcat (_data_->_tmp13_, "/delay_off", NULL);
	_data_->_tmp15_ = _data_->_tmp14_;
	fso_framework_file_handling_write (_data_->_tmp12_, _data_->_tmp15_, FALSE);
	_g_free0 (_data_->_tmp15_);
	_g_free0 (_data_->_tmp12_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_led_real_blink_seconds_data_free (gpointer _data) {
	Kernel26LedBlinkSecondsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26LedBlinkSecondsData, _data_);
}


static void kernel26_led_real_blink_seconds (FreeSmartphoneDeviceLED* base, gint seconds, gint delay_on, gint delay_off, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Led * self;
	Kernel26LedBlinkSecondsData* _data_;
	Kernel26Led* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (Kernel26Led*) base;
	_data_ = g_slice_new0 (Kernel26LedBlinkSecondsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_led_real_blink_seconds);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_led_real_blink_seconds_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = seconds;
	_data_->seconds = _tmp1_;
	_tmp2_ = delay_on;
	_data_->delay_on = _tmp2_;
	_tmp3_ = delay_off;
	_data_->delay_off = _tmp3_;
	kernel26_led_real_blink_seconds_co (_data_);
}


static void kernel26_led_real_blink_seconds_finish (FreeSmartphoneDeviceLED* base, GAsyncResult* _res_, GError** error) {
	Kernel26LedBlinkSecondsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void kernel26_led_blink_seconds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	Kernel26LedBlinkSecondsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	kernel26_led_real_blink_seconds_co (_data_);
}


static gboolean kernel26_led_real_blink_seconds_co (Kernel26LedBlinkSecondsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->seconds;
	if (_data_->_tmp0_ < 1) {
		_data_->_tmp1_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "Blinking timeout needs to be at least 1 second.");
		_data_->_inner_error_ = _data_->_tmp1_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->delay_on;
	_data_->_tmp3_ = _data_->delay_off;
	_data_->_state_ = 1;
	free_smartphone_device_led_set_blinking ((FreeSmartphoneDeviceLED*) _data_->self, _data_->_tmp2_, _data_->_tmp3_, kernel26_led_blink_seconds_ready, _data_);
	return FALSE;
	_state_1:
	free_smartphone_device_led_set_blinking_finish ((FreeSmartphoneDeviceLED*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp4_ = _data_->seconds;
	kernel26_led_setTimeout (_data_->self, _data_->_tmp4_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_led_real_set_networking_data_free (gpointer _data) {
	Kernel26LedSetNetworkingData* _data_;
	_data_ = _data;
	_g_free0 (_data_->iface);
	_g_free0 (_data_->mode);
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26LedSetNetworkingData, _data_);
}


static void kernel26_led_real_set_networking (FreeSmartphoneDeviceLED* base, const gchar* iface, const gchar* mode, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Led * self;
	Kernel26LedSetNetworkingData* _data_;
	Kernel26Led* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (Kernel26Led*) base;
	_data_ = g_slice_new0 (Kernel26LedSetNetworkingData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_led_real_set_networking);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_led_real_set_networking_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = iface;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->iface = _tmp2_;
	_tmp3_ = mode;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->mode = _tmp4_;
	kernel26_led_real_set_networking_co (_data_);
}


static void kernel26_led_real_set_networking_finish (FreeSmartphoneDeviceLED* base, GAsyncResult* _res_, GError** error) {
	Kernel26LedSetNetworkingData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel26_led_real_set_networking_co (Kernel26LedSetNetworkingData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	kernel26_led_initTriggers (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->triggers;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = string_contains (_data_->_tmp0_, "netdev");
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_UNSUPPORTED, "Kernel support for netdev led class trigger missing.");
		_data_->_inner_error_ = _data_->_tmp2_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = sys_class_net;
	_data_->_tmp4_ = _data_->iface;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strdup_printf ("%s/%s", _data_->_tmp3_, _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = fso_framework_file_handling_isPresent (_data_->_tmp6_);
	_data_->_tmp8_ = !_data_->_tmp7_;
	_g_free0 (_data_->_tmp6_);
	if (_data_->_tmp8_) {
		_data_->_tmp9_ = _data_->iface;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strdup_printf ("Interface '%s' not present.", _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, _data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_g_free0 (_data_->_tmp11_);
		_data_->_inner_error_ = _data_->_tmp13_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp14_ = g_strdup ("");
	_data_->cleanmode = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->mode;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_ = g_strsplit (_data_->_tmp15_, " ", 0);
	{
		_data_->element_collection_length1 = 0;
		_data_->_element_collection_size_ = 0;
		_data_->element_collection = _data_->_tmp17_;
		_data_->element_collection_length1 = _vala_array_length (_data_->_tmp16_);
		for (_data_->element_it = 0; _data_->element_it < _vala_array_length (_data_->_tmp16_); _data_->element_it = _data_->element_it + 1) {
			_data_->_tmp18_ = g_strdup (_data_->element_collection[_data_->element_it]);
			_data_->element = _data_->_tmp18_;
			{
				_data_->_tmp21_ = _data_->element;
				if (g_strcmp0 (_data_->_tmp21_, "link") != 0) {
					_data_->_tmp22_ = _data_->element;
					_data_->_tmp20_ = g_strcmp0 (_data_->_tmp22_, "rx") != 0;
				} else {
					_data_->_tmp20_ = FALSE;
				}
				_data_->_tmp23_ = _data_->_tmp20_;
				if (_data_->_tmp23_) {
					_data_->_tmp24_ = _data_->element;
					_data_->_tmp19_ = g_strcmp0 (_data_->_tmp24_, "tx") != 0;
				} else {
					_data_->_tmp19_ = FALSE;
				}
				_data_->_tmp25_ = _data_->_tmp19_;
				if (_data_->_tmp25_) {
					_data_->_tmp26_ = _data_->element;
					_data_->_tmp27_ = NULL;
					_data_->_tmp27_ = g_strdup_printf ("Element '%s' not allowed. Valid elements are 'link', 'rx', 'tx'.", _data_->_tmp26_);
					_data_->_tmp28_ = _data_->_tmp27_;
					_data_->_tmp29_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, _data_->_tmp28_);
					_data_->_tmp30_ = _data_->_tmp29_;
					_g_free0 (_data_->_tmp28_);
					_data_->_inner_error_ = _data_->_tmp30_;
					if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_g_free0 (_data_->element);
						_data_->element_collection = (_vala_array_free (_data_->element_collection, _data_->element_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_data_->cleanmode);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_free0 (_data_->element);
						_data_->element_collection = (_vala_array_free (_data_->element_collection, _data_->element_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_data_->cleanmode);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				} else {
					_data_->_tmp31_ = _data_->cleanmode;
					_data_->_tmp32_ = _data_->element;
					_data_->_tmp33_ = g_strconcat (_data_->_tmp31_, _data_->_tmp32_, NULL);
					_g_free0 (_data_->cleanmode);
					_data_->cleanmode = _data_->_tmp33_;
				}
				_g_free0 (_data_->element);
			}
		}
		_data_->element_collection = (_vala_array_free (_data_->element_collection, _data_->element_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->_tmp34_ = _data_->cleanmode;
	if (g_strcmp0 (_data_->_tmp34_, "") == 0) {
		free_smartphone_device_led_set_brightness ((FreeSmartphoneDeviceLED*) _data_->self, 0, NULL, NULL);
	} else {
		kernel26_led_cleanTimeout (_data_->self);
		_data_->_tmp35_ = _data_->self->priv->trigger;
		fso_framework_file_handling_write ("netdev", _data_->_tmp35_, FALSE);
		_data_->_tmp36_ = _data_->iface;
		_data_->_tmp37_ = _data_->self->priv->sysfsnode;
		_data_->_tmp38_ = g_strconcat (_data_->_tmp37_, "/device_name", NULL);
		_data_->_tmp39_ = _data_->_tmp38_;
		fso_framework_file_handling_write (_data_->_tmp36_, _data_->_tmp39_, FALSE);
		_g_free0 (_data_->_tmp39_);
		_data_->_tmp40_ = _data_->cleanmode;
		_data_->_tmp41_ = _data_->self->priv->sysfsnode;
		_data_->_tmp42_ = g_strconcat (_data_->_tmp41_, "/mode", NULL);
		_data_->_tmp43_ = _data_->_tmp42_;
		fso_framework_file_handling_write (_data_->_tmp40_, _data_->_tmp43_, FALSE);
		_g_free0 (_data_->_tmp43_);
	}
	_g_free0 (_data_->cleanmode);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_led_class_init (Kernel26LedClass * klass) {
	kernel26_led_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Kernel26LedPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel26_led_real_repr;
	G_OBJECT_CLASS (klass)->finalize = kernel26_led_finalize;
}


static void kernel26_led_free_smartphone_device_led_interface_init (FreeSmartphoneDeviceLEDIface * iface) {
	kernel26_led_free_smartphone_device_led_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_brightness = (void (*)(FreeSmartphoneDeviceLED*, gint, GError**)) kernel26_led_real_set_brightness;
	iface->set_brightness_finish = kernel26_led_real_set_brightness_finish;
	iface->set_blinking = (void (*)(FreeSmartphoneDeviceLED*, gint, gint, GError**)) kernel26_led_real_set_blinking;
	iface->set_blinking_finish = kernel26_led_real_set_blinking_finish;
	iface->blink_seconds = (void (*)(FreeSmartphoneDeviceLED*, gint, gint, gint, GError**)) kernel26_led_real_blink_seconds;
	iface->blink_seconds_finish = kernel26_led_real_blink_seconds_finish;
	iface->set_networking = (void (*)(FreeSmartphoneDeviceLED*, const gchar*, const gchar*, GError**)) kernel26_led_real_set_networking;
	iface->set_networking_finish = kernel26_led_real_set_networking_finish;
}


static void kernel26_led_instance_init (Kernel26Led * self) {
	self->priv = KERNEL26_LED_GET_PRIVATE (self);
}


static void kernel26_led_finalize (GObject* obj) {
	Kernel26Led * self;
	self = KERNEL26_LED (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	_g_free0 (self->priv->brightness);
	_g_free0 (self->priv->trigger);
	_g_free0 (self->priv->triggers);
	G_OBJECT_CLASS (kernel26_led_parent_class)->finalize (obj);
}


GType kernel26_led_get_type (void) {
	return kernel26_led_type_id;
}


GType kernel26_led_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (Kernel26LedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel26_led_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Kernel26Led), 0, (GInstanceInitFunc) kernel26_led_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_led_info = { (GInterfaceInitFunc) kernel26_led_free_smartphone_device_led_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel26_led_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "Kernel26Led", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel26_led_type_id, FREE_SMARTPHONE_DEVICE_TYPE_LED, &free_smartphone_device_led_info);
	return kernel26_led_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	FsoFrameworkSmartKeyFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* to_skip;
	const gchar* _tmp10_;
	GDir* _tmp11_ = NULL;
	GDir* dir;
	GDir* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* entry;
	gchar* _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = config;
	_tmp3_ = fso_framework_smart_key_file_stringValue (_tmp2_, "cornucopia", "sysfs_root", "/sys");
	_g_free0 (sysfs_root);
	sysfs_root = _tmp3_;
	_tmp4_ = sysfs_root;
	_tmp5_ = g_strdup_printf ("%s/class/leds", _tmp4_);
	_g_free0 (sys_class_leds);
	sys_class_leds = _tmp5_;
	_tmp6_ = sysfs_root;
	_tmp7_ = g_strdup_printf ("%s/class/net", _tmp6_);
	_g_free0 (sys_class_net);
	sys_class_net = _tmp7_;
	_tmp8_ = config;
	_tmp9_ = fso_framework_smart_key_file_stringValue (_tmp8_, KERNEL26_LED_MODULE_NAME, "ignore_by_name", "");
	to_skip = _tmp9_;
	_tmp10_ = sys_class_leds;
	_tmp11_ = g_dir_open (_tmp10_, (guint) 0, &_inner_error_);
	dir = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (to_skip);
		_g_object_unref0 (config);
		return NULL;
	}
	_tmp12_ = dir;
	_tmp13_ = g_dir_read_name (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	entry = _tmp14_;
	while (TRUE) {
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_;
		gboolean _tmp21_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* filename;
		FsoFrameworkSubsystem* _tmp28_;
		const gchar* _tmp29_;
		Kernel26Led* _tmp30_;
		GDir* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		_tmp15_ = entry;
		if (!(_tmp15_ != NULL)) {
			break;
		}
		_tmp17_ = to_skip;
		if (g_strcmp0 (_tmp17_, "") != 0) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp18_ = entry;
			_tmp19_ = to_skip;
			_tmp20_ = string_contains (_tmp18_, _tmp19_);
			_tmp16_ = _tmp20_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp21_ = _tmp16_;
		if (_tmp21_) {
			GDir* _tmp22_;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp22_ = dir;
			_tmp23_ = g_dir_read_name (_tmp22_);
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (entry);
			entry = _tmp24_;
			continue;
		}
		_tmp25_ = sys_class_leds;
		_tmp26_ = entry;
		_tmp27_ = g_build_filename (_tmp25_, _tmp26_, NULL);
		filename = _tmp27_;
		_tmp28_ = subsystem;
		_tmp29_ = filename;
		_tmp30_ = kernel26_led_new (_tmp28_, _tmp29_);
		instances = g_list_append (instances, _tmp30_);
		_tmp31_ = dir;
		_tmp32_ = g_dir_read_name (_tmp31_);
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (entry);
		entry = _tmp33_;
		_g_free0 (filename);
	}
	_tmp34_ = g_strdup (KERNEL26_LED_MODULE_NAME);
	result = _tmp34_;
	_g_free0 (entry);
	_g_dir_close0 (dir);
	_g_free0 (to_skip);
	_g_object_unref0 (config);
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	kernel26_led_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.kernel26_leds fso_register_function()");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



