/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpnGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.VpnGatewayDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVpnGateways
extends BaseCmd {
    public DescribeVpnGateways(String[] args) {
        super("ec2dvgw", "ec2-describe-vpn-gateways");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[ VPN_GATEWAY ... ] [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about one or more VPN gateways. The VPN_GATEWAY ");
        System.out.println("     parameters, if specified, are the IDs of the VPN gateways to be described.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeVpnGateways(this.getFilterMap(true), this.getNonOptions());
        for (VpnGatewayDescription vgw : (List)rsp.getResponse()) {
            out.output(System.out, vgw);
            if (vgw.getAttachments() == null) continue;
            for (VpnGatewayAttachmentDescription attachment : vgw.getAttachments()) {
                out.output(System.out, attachment);
            }
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeVpnGateways(args).invoke();
    }
}

