#!/bin/bash

# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.

# Bugs to: Jun Kobayashi <kobayashi@ubuntulinux.jp>

TITLE="AdobeReader8.1.4日本語版インストーラ"
ZENITY_CMD="zenity --title=$TITLE"

tmp_dir="${TMPDIR:-/var/tmp}/${package_name}.$$"
archive_url=http://ardownload.adobe.com/pub/adobe/reader/unix/8.x/8.1.4/jpn/AdobeReader_jpn-8.1.4-1.i386.deb
archive=`basename $archive_url`
http_proxy=`apt-config dump | grep -i '^Acquire::http::Proxy' | cut -d ' ' -f 2 | cut -d '"' -f 2 | grep "^http://" | cut -d '/' -f 3`
if [ -n "$http_proxy" ]; then
  export http_proxy
  export https_proxy=$http_proxy
fi

function abort() {
  rm -fr ${tmp_dir} || true
  $ZENITY_CMD --error --text="$1"
  exit -1
}

function install() {
  rm -rf "${TMPDIR:-/var/tmp}/${package_name}.*" || true

  if ! mkdir ${tmp_dir} ; then
    abort "作業ディレクトリの作成に失敗しました。"
  fi

  wget -O ${tmp_dir}/${archive} ${archive_url} 2>&1 | sed -u 's/.* \+\([0-9]\+%\).*$/\1/' | tee >($ZENITY_CMD --progress --auto-close --text "${archive}のダウンロード中です...")
  if [ ! -f ${tmp_dir}/${archive} ]; then
    abort "${archive}のダウンロードに失敗しました。"
  fi

  /usr/bin/dpkg -i ${tmp_dir}/${archive} | $ZENITY_CMD --progress --pulsate --auto-close --text "${archive}のインストール中です..."
  if [ $? -ne 0  ] ; then
    abort "パッケージのインストールに失敗しました。"
  fi

  /usr/bin/dpkg-query -s adobereader-jpn | grep -q '^Version: 8.1.4$'
  if [ $? -ne 0  ] ; then
    abort "パッケージのインストールに失敗しました。"
  fi
}


function start {
	$ZENITY_CMD --question --text="Acrobat Reader 8.1.4はまだインストールされていません。
$TITLEを開始します。
パッケージをダウンロードするために、インターネット接続が必要です。
接続していない場合は、先にネットワーク設定を行ってください。"
	return $?
}

function finish {
	rm -r ${tmp_dir} || true
        $ZENITY_CMD --question --text="$TITLEを終了します。
[アプリケーション]-[オフィス]-[Adobe Reader]を起動して下さい。"
        return $?
}

#
# Main Routine
#

if [[ `whoami` != "root" ]]; then
  start
  if [[ $? -ne 0 ]]; then
    exit 0
  fi
  gksudo --message "$TITLEを実行します。パスワード入力してください。" $0
  exit 1
fi
install
finish

exit 0
