/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */


/**
 * @file
 * @author Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 * @brief This header describes abut fucntions used for sending and receving messages.
 */
#ifndef SCIMBRIDGEMESSAGENGER_H_
#define SCIMBRIDGEMESSAGENGER_H_

#include "scim-bridge.h"
#include "scim-bridge-message.h"

/**
 * The struct type of Messenger.
 */
typedef struct _ScimBridgeMessenger ScimBridgeMessenger;

/**
 * The message header for "set_preedit_enabled".
 */
static const char SCIM_BRIDGE_MESSAGE_SET_PREEDIT_ENABLED[] = "set_preedit_enabled";

/**
 * The message header for "update_preedit".
 */
static const char SCIM_BRIDGE_MESSAGE_UPDATE_PREEDIT[] = "update_preedit";

/**
 * The message header for "set_preedit_string".
 */
static const char SCIM_BRIDGE_MESSAGE_SET_PREEDIT_STRING[] = "set_preedit_string";

/**
 * The message header for "set_preedit_attributes".
 */
static const char SCIM_BRIDGE_MESSAGE_SET_PREEDIT_ATTRIBUTES[] = "set_preedit_attributes";

/**
 * The message header for "set_preedit_cursor_position".
 */
static const char SCIM_BRIDGE_MESSAGE_SET_PREEDIT_CURSOR_POSITION[] = "set_preedit_cursor_position";

/**
 * The message header for "set_preedit_shown".
 */
static const char SCIM_BRIDGE_MESSAGE_SET_PREEDIT_SHOWN[] = "set_preedit_shown";

/**
 * The message header for "focus_changed".
 */
static const char SCIM_BRIDGE_MESSAGE_FOCUS_CHANGED[] = "focus_changed";

/**
 * The message header for "key_event_occured".
 */
static const char SCIM_BRIDGE_MESSAGE_KEY_EVENT_OCCURED[] = "key_event_occured";

/**
 * The message header for "cursor_location_changed".
 */
static const char SCIM_BRIDGE_MESSAGE_CURSOR_LOCATION_CHANGED[] = "cursor_location_changed";

/**
 * The message header for "alloc_imcontext".
 */
static const char SCIM_BRIDGE_MESSAGE_ALLOC_IMCONTEXT[] = "alloc_imcontext";

/**
 * The message header for "free_imcontext".
 */
static const char SCIM_BRIDGE_MESSAGE_FREE_IMCONTEXT[] = "free_imcontext";

/**
 * The message header for "reset_imcontext".
 */
static const char SCIM_BRIDGE_MESSAGE_RESET_IMCONTEXT[] = "reset_imcontext";

/**
 * The message header for "imcontext_allocated".
 */
static const char SCIM_BRIDGE_MESSAGE_IMCONTEXT_ALLOCATED[] = "imcontext_allocated";

/**
 * The message header for "imcontext_freed".
 */
static const char SCIM_BRIDGE_MESSAGE_IMCONTEXT_FREED[] = "imcontext_freed";

/**
 * The message header for "forward_key_event".
 */
static const char SCIM_BRIDGE_MESSAGE_FORWARD_KEY_EVENT[] = "forward_key_event";

/**
 * The message header for "commit".
 */
static const char SCIM_BRIDGE_MESSAGE_COMMIT[] = "commit";

/**
 * The message header for "beep".
 */
static const char SCIM_BRIDGE_MESSAGE_BEEP[] = "beep";

/**
 * The message header for "get_surrounding_text".
 */
static const char SCIM_BRIDGE_MESSAGE_GET_SURROUNDING_TEXT[] = "get_surrounding_text";

/**
 * The message header for "delete_surrounding_text".
 */
static const char SCIM_BRIDGE_MESSAGE_DELETE_SURROUNDING_TEXT[] = "delete_surrounding_text";

/**
 * The message header for "key_event_handled".
 */
static const char SCIM_BRIDGE_MESSAGE_KEY_EVENT_HANDLED[] = "key_event_handled";

/**
 * The message header for "surrounding_text_gotten".
 */
static const char SCIM_BRIDGE_MESSAGE_SURROUNDING_TEXT_GOTTEN[] = "surrounding_text_gotten";

/**
 * The message header for "surrounding_text_deleted".
 */
static const char SCIM_BRIDGE_MESSAGE_SURROUNDING_TEXT_DELETED[] = "surrounding_text_deleted";

/**
 * The message argument for "shift".
 */
static const char SCIM_BRIDGE_MESSAGE_SHIFT[] = "shift";

/**
 * The message argument for "control".
 */
static const char SCIM_BRIDGE_MESSAGE_CONTROL[] = "control";

/**
 * The message argument for "alt".
 */
static const char SCIM_BRIDGE_MESSAGE_ALT[] = "alt";

/**
 * The message argument for "meta".
 */
static const char SCIM_BRIDGE_MESSAGE_META[] = "meta";

/**
 * The message argument for "super".
 */
static const char SCIM_BRIDGE_MESSAGE_SUPER[] = "super";

/**
 * The message argument for "hyper".
 */
static const char SCIM_BRIDGE_MESSAGE_HYPER[] = "hyper";

/**
 * The message argument for "caps_lock".
 */
static const char SCIM_BRIDGE_MESSAGE_CAPS_LOCK[] = "caps_lock";

/**
 * The message argument for "num_lock".
 */
static const char SCIM_BRIDGE_MESSAGE_NUM_LOCK[] = "num_lock";

/**
 * The message argument for "true".
 */
static const char SCIM_BRIDGE_MESSAGE_TRUE[] = "true";

/**
 * The message argument for "false".
 */
static const char SCIM_BRIDGE_MESSAGE_FALSE[] = "false";

/**
 * The message argument for "none".
 */
static const char SCIM_BRIDGE_MESSAGE_NONE[] = "none";

/**
 * The message argument for "decorate".
 */
static const char SCIM_BRIDGE_MESSAGE_DECORATE[] = "decoreate";

/**
 * The message argument for "foreground".
 */
static const char SCIM_BRIDGE_MESSAGE_FOREGROUND[] = "foreground";

/**
 * The message argument for "background".
 */
static const char SCIM_BRIDGE_MESSAGE_BACKGROUND[] = "background";

/**
 * The message argument for "color".
 */
static const char SCIM_BRIDGE_MESSAGE_COLOR[] = "#";

/**
 * The message argument for "underline".
 */
static const char SCIM_BRIDGE_MESSAGE_UNDERLINE[] = "underline";

/**
 * The message argument for "hilight".
 */
static const char SCIM_BRIDGE_MESSAGE_HIGHLIGHT[] = "highlight";

/**
 * The message argument for "reverse".
 */
static const char SCIM_BRIDGE_MESSAGE_REVERSE[] = "reverse";

#ifdef __cplusplus
extern "C"
{
#endif

    /**
     * Allocate a new messenger.
     *
     * @param socket_fd The file discriptor for the socket.
     * @return The new messenger.
     */
    ScimBridgeMessenger *scim_bridge_alloc_messenger (int socket_fd);

    /**
     * Free a messenger, and close the socket if it's still open.\n
     * Do not use "free ()" for variables for this type.
     *
     * @param messenger The messenger.
     */
    void scim_bridge_free_messenger (ScimBridgeMessenger *messenger);

    /**
     * Close the socket of the messenger.
     *
     * @param messenger The messenger.
     */
    void scim_bridge_messenger_close (ScimBridgeMessenger *messenger);
    
    /**
     * Check if the messenger is closed.
     *
     * @param messenger The messeger
     * @return TRUE if closed, otherwise it returns FALSE.
     */
    boolean scim_bridge_messenger_is_closed (const ScimBridgeMessenger *messenger);

    /**
     * Send a messenge, and wait until it finish.\n
     * You can cancel this by closing the messenger, \n
     * but you will get an error in that case.
     * Note that you cannot use the messenger again after any error has been happend.
     *
     * @param messenger The messenger.
     * @param message The message to send. 
     * @return RETVAL_SUCCEEDED if succeeded, otherwise it returns RETVAL_FAILED.
     */
    retval_t scim_bridge_messenger_send (ScimBridgeMessenger *messenger, const ScimBridgeMessage *message);

    /**
     * Receive a messenge, and wait until it finish.\n
     * You can cancel this by closing the messenger, \n
     * but you will get an error in that case.
     * Note that you cannot use the messenger again after any error has been happend.
     *
     * @param messenger The messenger.
     * @param message The pointer for the received message. 
     * @return RETVAL_SUCCEEDED if succeeded, otherwise it returns RETVAL_FAILED.
     */
    retval_t scim_bridge_messenger_receive (ScimBridgeMessenger *messenger, ScimBridgeMessage **message);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEMESSAGENGER_H_*/
