/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGECLIENT_H_
#define SCIMBRIDGECLIENT_H_

#include "scim-bridge.h"
#include "scim-bridge-key-event.h"
#include "scim-bridge-client-imcontext.h"

#ifdef __cplusplus
extern "C"
{
#endif

    retval_t scim_bridge_client_initialize ();
    void scim_bridge_client_finalize ();
    boolean scim_bridge_client_is_active ();

    int scim_bridge_client_get_socket_fd ();

    retval_t scim_bridge_client_read_and_dispatch ();

    retval_t scim_bridge_client_alloc_imcontext (ScimBridgeClientIMContext *imcontext);
    retval_t scim_bridge_client_free_imcontext (ScimBridgeClientIMContext *imcontext);
    retval_t scim_bridge_client_reset_imcontext (const ScimBridgeClientIMContext *imcontext);
    retval_t scim_bridge_client_focus_changed (const ScimBridgeClientIMContext *imcontext, boolean focus_in);
    retval_t scim_bridge_client_key_event_occured (const ScimBridgeClientIMContext *imcontext, const ScimBridgeKeyEvent *key_event, boolean *consumed);
    retval_t scim_bridge_client_cursor_location_changed (const ScimBridgeClientIMContext *imcontext, int x, int y);
    retval_t scim_bridge_client_set_preedit_enabled (const ScimBridgeClientIMContext *imcontext, boolean enabled);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGECLIENT_H_*/
