/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTIMCONTEXT_H_
#define SCIMBRIDGEAGENTIMCONTEXT_H_

#define Uses_SCIM_ATTRIBUTE
#define Uses_SCIM_BACKEND
#define Uses_SCIM_IMENGINE
#define Uses_SCIM_IMENGINE_MODULE
#define Uses_SCIM_LOOKUP_TABLE

#include <scim.h>

#include "scim-bridge.h"
#include "scim-bridge-agent-panel-listener-protected.h"
#include "scim-bridge-imcontext.h"

class ScimBridgeAgentClientListener;

class ScimBridgeAgentIMContext
{

    public:

        static ScimBridgeAgentIMContext *alloc (ScimBridgeAgentClientListener *client_listener);
        static ScimBridgeAgentIMContext *find (scim_bridge_imcontext_id_t imcontext_id);

        static void static_initialize (ScimBridgeAgentPanelListenerProtected *new_panel_listener, scim::BackEndPointer backend);
        static void static_finalize ();

        static const scim::String &get_scim_language ();
        static void set_scim_language (const scim::String &language);

        static bool is_imengine_shared ();
        static void set_imengine_shared (bool shared);

        static bool is_on_the_spot_enabled_globally ();
        static void set_on_the_spot_enabled_globally (bool enabled);

        static bool is_enabled_by_default ();
        static void set_enabled_by_default (bool enabled);

        virtual bool filter_key_event (const scim::KeyEvent &key_event) = 0;
        virtual void forward_key_event (const scim::KeyEvent &key_event) = 0;
        
        virtual ~ScimBridgeAgentIMContext () {}

        virtual void free () = 0;
        virtual void free_partially () = 0;

        virtual bool is_preedit_enabled () = 0;
        virtual void set_preedit_enabled (bool new_state) = 0;

        virtual bool is_enabled () = 0;
        virtual void set_enabled (bool new_state) = 0;

        virtual scim_bridge_imcontext_id_t get_id () = 0;

        virtual ScimBridgeAgentClientListener *get_client_listener () = 0;

        virtual void focus_in () = 0;
        virtual void focus_out () = 0;

        virtual void reset () = 0;

        virtual void cursor_location_changed (int x, int y) = 0;

        virtual void open_next_imengine () = 0;
        virtual void open_previous_imengine () = 0;
        virtual void open_imengine_by_uuid (const scim::String &uuid) = 0;
        virtual void open_imengine (scim::IMEngineFactoryPointer factory) = 0;

        virtual void update_lookup_table_page_size (int page_size) = 0;
        virtual void lookup_table_page_up () = 0;
        virtual void lookup_table_page_down () = 0;
        virtual void lookup_table_select_candidate (int candidate_index) = 0;
        virtual void trigger_property (const scim::String &property) = 0;
        virtual void process_helper_event (const scim::String &target_uuid, const scim::String &helper_uuid, const scim::Transaction &trans) = 0;
        virtual void panel_move_preedit_caret (int caret_pos) = 0;
        virtual void panel_commit (const scim::WideString &wstr) = 0;
        virtual void panel_request_help () = 0;
        virtual void panel_change_factory (const scim::String &uuid) = 0;

    protected:

        ScimBridgeAgentIMContext () {}

};
#endif                                            /*SCIMBRIDGEAGENTIMCONTEXT_H_*/
