/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include "scim-bridge-agent-set-preedit-enabled-event.h"

ScimBridgeAgentSetPreeditEnabledEvent::ScimBridgeAgentSetPreeditEnabledEvent (scim_bridge_imcontext_id_t new_id, bool new_enabled, ScimBridgeAgentClientListener *new_client_listener):
ScimBridgeAgentEvent (SET_PREEDIT_ENABLED_EVENT), imcontext_id (new_id), enabled (new_enabled), client_listener (new_client_listener)
{
}


ScimBridgeAgentSetPreeditEnabledEvent::~ScimBridgeAgentSetPreeditEnabledEvent ()
{
}


ScimBridgeAgentClientListener *ScimBridgeAgentSetPreeditEnabledEvent::get_client_listener () const
{
    return client_listener;
}


scim_bridge_imcontext_id_t ScimBridgeAgentSetPreeditEnabledEvent::get_imcontext_id () const
{
    return imcontext_id;
}


bool ScimBridgeAgentSetPreeditEnabledEvent::is_enabled () const
{
    return enabled;
}
