/* File:        ops.c
 * Program:     unhtml
 * Written by:	Kevin Swan, 013639s@dragon.acadiau.ca
 * Completed: 	February 3, 1998
 * Version: 	2.3
 */


#include <malloc.h>
#include <stdlib.h>
#include <string.h>

#include "ops.h"



/*
 * Checks if a given tag is an HTML script opening tag, <SCRIPT>.
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that is an HTML tag.
 *   Return:  1 if that tag is a script opening tag, 0 otherwise.
 */
int isScriptOpeningTag (char *tag) {
  int i = 0;

  while (tag[i] != '\0') {
    switch (i) {
      case 0:  if (tag[i] != '<')
                 return 0;
               break;
      case 1:  if ((tag[i] != 's') && (tag[i] != 'S'))
                 return 0;
               break;
      case 2:  if ((tag[i] != 'c') && (tag[i] != 'C'))
                 return 0;
               break;
      case 3:  if ((tag[i] != 'r') && (tag[i] != 'R'))
                 return 0;
               break;
      case 4:  if ((tag[i] != 'i') && (tag[i] != 'I'))
                 return 0;
               break;
      case 5:  if ((tag[i] != 'p') && (tag[i] != 'P'))
                 return 0;
               break;
      case 6:  if ((tag[i] != 't') && (tag[i] != 'T'))
                 return 0;
               break;
      default: return 1;
    } /* switch */
    i++;
  } /* while */
  return 0;
}



/*
 * Checks if a given tag is an HTML script closing tag, </SCRIPT>.
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that is an HTML tag.
 *   Return:  1 if that tag is a script closing tag, 0 otherwise.
 */
int isScriptClosingTag (char *tag) {
  int i = 0;

  while (tag[i] != '\0') {
    switch (i) {
      case 0:  if (tag[i] != '<')
                 return 0;
               break;
      case 1:  if (tag[i] != '/')
                 return 0;
               break;
      case 2:  if ((tag[i] != 's') && (tag[i] != 'S'))
                 return 0;
               break;
      case 3:  if ((tag[i] != 'c') && (tag[i] != 'C'))
                 return 0;
               break;
      case 4:  if ((tag[i] != 'r') && (tag[i] != 'R'))
                 return 0;
               break;
      case 5:  if ((tag[i] != 'i') && (tag[i] != 'I'))
                 return 0;
               break;
      case 6:  if ((tag[i] != 'p') && (tag[i] != 'P'))
                 return 0;
               break;
      case 7:  if ((tag[i] != 't') && (tag[i] != 'T'))
                 return 0;
               break;
      default: return 1;
    } /* switch */
    i++;
  } /* while */
  return 0;
}


/*
 * Checks if a given tag is an actual HTML tag
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that could be an HTML tag.
 *   Return:  1 if that tag is an HTML tag, 0 otherwise
 */
int isRealHtmlTag (char *tag) {

   static char *html[] = { 
      "a", "abbrev", "acronym", "address", "applet", "area", 
      "b", "base", "basefont", "bdo", "big", "blockquote", "body",
      "br", "button",
      "caption", "center", "cite", "code", "col", "colgroup",
      "dd", "del", "dfn", "dir", "div", "dl", "dt",
      "em",
      "fieldset", "font", "form", "frame", "frameset",
      "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html",
      "i", "iframe", "img", "input", "ins", "isindex",
      "kbd",
      "label", "legend", "li", "link", "map", "menu", "meta",
      "noframes", "noscript",
      "object", "ol", "optgroup", "option",
      "p", "param", "pre",
      "q",
      "s", "samp", "script", "select", "small", "span", "strike",
      "strong", "style", "sub",
      "table", "tbody", "td", "textarea", "tfoot", "th", "thead",
      "title", "tr", "tt",
      "u", "ul",
      "var",
      0    };

   int ii, jj, len;
   int result;
   static char *ptr = 0;
   static int taglen = 256;

   result = 0;
   /*
    * keep around a static buffer for the tag -- initialize it the
    * first time thru
    */
   len = strlen(tag) + 1;
   len = (len > taglen) ? len : taglen;
   if (!ptr) {
      ptr = (char *)malloc(len);
      if (!ptr) {
         fprintf (stderr, "Cannot malloc in tag test (%d bytes)\n", len);
         exit(1);
      }
      memset(ptr, 0, len);
      taglen = len;
   }

   /*
    * if the tag's longer than the space we've already set aside,
    * make a bigger space
    */
   if (len > taglen) {
      free(ptr);
      while (taglen < len)
         taglen *= 2;
      ptr = (char *)malloc(taglen);
      if (!ptr) {
         fprintf (stderr, "Cannot malloc in tag test (%d bytes)\n", len);
         exit(1);
      }
   }
   memset(ptr, 0, taglen);

   /*
    * copy the useful parts of the tag into our buffer
    */
   jj = 0;
   for (ii = 0; ii < len; ii++) {
      if (tag[ii] == '<')
         continue;
      if (tag[ii] == '/' && ii == 1)
         continue;
      if (tag[ii] == ' ' || tag[ii] == '>' || tag[ii] ==  '\n')
         break;
      ptr[jj++] = tag[ii];
   }

   /*
    * see if the tag is an actual html tag
    */
   for (ii = 0; html[ii] != 0; ii++)
      if (strcasecmp(ptr, html[ii]) == 0) {
         result = 1;
         break;
      }

   return result;
}

