#!/bin/sh
#
# Copyright (c) 2012-2014, 2017 Todd C. Miller <Todd.Miller@sudo.ws>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

OUTFILE="$1"
rm -f "$OUTFILE"
> "$OUTFILE"

# HP-UX friendly header/footer for all man pages
if [ X"`uname 2>&1`" = X"HP-UX" ]; then
    cat >>"$OUTFILE" <<-'EOF'
	s/^\.TH \("[^"]*"\) \("[^"]*"\) "\([^"]*\)" "\([^"]*\)" \("[^"]*"\)/.TH \1 \2\
	.ds )H \4\
	.ds ]W \3/
EOF
fi

# Replace "0 minutes" with "unlimited"
cat >>"$OUTFILE" <<-'EOF'
	/^\\fR0\\fR$/ {
		N
		s/^\\fR0\\fR\nminutes\.$/unlimited./
	}
EOF
