/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.MetadataGeneratorLogger;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MetadataGeneratorUtil {
    private MetadataGeneratorUtil() {
    }

    public static void generate(String path, OutputStream out, String ... moduleFolders) throws IOException, CheckstyleException {
        JavadocMetadataScraper.resetModuleDetailsStore();
        Checker checker = new Checker();
        checker.setModuleClassLoader(Checker.class.getClassLoader());
        DefaultConfiguration scraperCheckConfig = new DefaultConfiguration(JavadocMetadataScraper.class.getName());
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("configuration");
        DefaultConfiguration treeWalkerConfig = new DefaultConfiguration(TreeWalker.class.getName());
        defaultConfiguration.addProperty("charset", StandardCharsets.UTF_8.name());
        defaultConfiguration.addChild(treeWalkerConfig);
        treeWalkerConfig.addChild(scraperCheckConfig);
        checker.configure(defaultConfiguration);
        checker.addListener(new MetadataGeneratorLogger(out, AutomaticBean.OutputStreamOptions.NONE));
        MetadataGeneratorUtil.dumpMetadata(checker, path, moduleFolders);
    }

    private static void dumpMetadata(RootModule root, String path, String ... moduleFolders) throws CheckstyleException, IOException {
        ArrayList<File> validFiles = new ArrayList<File>();
        for (String folder : moduleFolders) {
            try (Stream<Path> files = Files.walk(Paths.get(path + "/" + folder, new String[0]), new FileVisitOption[0]);){
                validFiles.addAll(files.map(Path::toFile).filter(file -> {
                    String fileName = file.getName();
                    return fileName.endsWith("SuppressWarningsHolder.java") || fileName.endsWith("Check.java") || fileName.endsWith("Filter.java");
                }).collect(Collectors.toList()));
            }
        }
        root.process(validFiles);
    }
}

