/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CheckUtil {
    private static final int BASE_2 = 2;
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private static final int SETTER_GETTER_MAX_CHILDREN = 7;
    private static final int SETTER_BODY_SIZE = 3;
    private static final int GETTER_BODY_SIZE = 2;
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[A-Z].*");
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(is|get)[A-Z].*");
    private static final Pattern ALL_NEW_LINES = Pattern.compile("\\R");
    private static final char PACKAGE_SEPARATOR = '.';

    private CheckUtil() {
    }

    public static boolean isEqualsMethod(DetailAST ast) {
        boolean equalsMethod = false;
        if (ast.getType() == 9) {
            DetailAST nameNode;
            String name;
            boolean staticOrAbstract;
            DetailAST modifiers = ast.findFirstToken(5);
            boolean bl = staticOrAbstract = modifiers.findFirstToken(64) != null || modifiers.findFirstToken(40) != null;
            if (!staticOrAbstract && "equals".equals(name = (nameNode = ast.findFirstToken(58)).getText())) {
                DetailAST paramsNode = ast.findFirstToken(20);
                equalsMethod = paramsNode.getChildCount() == 1;
            }
        }
        return equalsMethod;
    }

    public static boolean isElseIf(DetailAST ast) {
        DetailAST parentAST = ast.getParent();
        return ast.getType() == 83 && (CheckUtil.isElse(parentAST) || CheckUtil.isElseWithCurlyBraces(parentAST));
    }

    private static boolean isElse(DetailAST ast) {
        return ast.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST ast) {
        return ast.getType() == 7 && ast.getChildCount() == 2 && CheckUtil.isElse(ast.getParent());
    }

    public static double parseDouble(String text, int type) {
        double result;
        String txt = UNDERSCORE_PATTERN.matcher(text).replaceAll("");
        switch (type) {
            case 140: 
            case 142: {
                result = Double.parseDouble(txt);
                break;
            }
            case 137: 
            case 141: {
                int radix = 10;
                if (txt.startsWith("0x") || txt.startsWith("0X")) {
                    radix = 16;
                    txt = txt.substring(2);
                } else if (txt.startsWith("0b") || txt.startsWith("0B")) {
                    radix = 2;
                    txt = txt.substring(2);
                } else if (CommonUtil.startsWithChar(txt, '0')) {
                    radix = 8;
                    txt = txt.substring(1);
                }
                result = CheckUtil.parseNumber(txt, radix, type);
                break;
            }
            default: {
                result = Double.NaN;
            }
        }
        return result;
    }

    private static double parseNumber(String text, int radix, int type) {
        double result;
        String txt = text;
        if (CommonUtil.endsWithChar(txt, 'L') || CommonUtil.endsWithChar(txt, 'l')) {
            txt = txt.substring(0, txt.length() - 1);
        }
        if (txt.isEmpty()) {
            result = 0.0;
        } else {
            boolean negative;
            boolean bl = negative = txt.charAt(0) == '-';
            result = type == 137 ? (negative ? (double)Integer.parseInt(txt, radix) : (double)Integer.parseUnsignedInt(txt, radix)) : (negative ? (double)Long.parseLong(txt, radix) : (double)Long.parseUnsignedLong(txt, radix));
        }
        return result;
    }

    public static DetailAST getFirstNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = CheckUtil.getFirstNode(child);
            if (!CheckUtil.isBeforeInSource(newNode, currentNode)) continue;
            currentNode = newNode;
        }
        return currentNode;
    }

    public static boolean isBeforeInSource(DetailAST ast1, DetailAST ast2) {
        return ast1.getLineNo() < ast2.getLineNo() || TokenUtil.areOnSameLine(ast1, ast2) && ast1.getColumnNo() < ast2.getColumnNo();
    }

    public static List<String> getTypeParameterNames(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList<String> typeParameterNames = new ArrayList<String>();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParameterNames.add(typeParam.findFirstToken(58).getText());
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParameterNames.add(sibling.findFirstToken(58).getText());
            }
        }
        return typeParameterNames;
    }

    public static List<DetailAST> getTypeParameters(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList<DetailAST> typeParams = new ArrayList<DetailAST>();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParams.add(typeParam);
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParams.add(sibling);
            }
        }
        return typeParams;
    }

    public static boolean isSetterMethod(DetailAST ast) {
        boolean setterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean singleParam;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesSetterFormat = SETTER_PATTERN.matcher(name).matches();
            boolean voidReturnType = type.findFirstToken(49) != null;
            DetailAST params = ast.findFirstToken(20);
            boolean bl = singleParam = params.getChildCount(21) == 1;
            if (matchesSetterFormat && voidReturnType && singleParam && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 3) {
                DetailAST expr = slist.getFirstChild();
                setterMethod = expr.getFirstChild().getType() == 80;
            }
        }
        return setterMethod;
    }

    public static boolean isGetterMethod(DetailAST ast) {
        boolean getterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean noParams;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesGetterFormat = GETTER_PATTERN.matcher(name).matches();
            boolean noVoidReturnType = type.findFirstToken(49) == null;
            DetailAST params = ast.findFirstToken(20);
            boolean bl = noParams = params.getChildCount(21) == 0;
            if (matchesGetterFormat && noVoidReturnType && noParams && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 2) {
                DetailAST expr = slist.getFirstChild();
                getterMethod = expr.getType() == 88;
            }
        }
        return getterMethod;
    }

    public static boolean isNonVoidMethod(DetailAST methodDefAst) {
        DetailAST typeAST;
        boolean returnValue = false;
        if (methodDefAst.getType() == 9 && (typeAST = methodDefAst.findFirstToken(13)).findFirstToken(49) == null) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isReceiverParameter(DetailAST parameterDefAst) {
        return parameterDefAst.getType() == 21 && parameterDefAst.findFirstToken(58) == null;
    }

    public static AccessModifierOption getAccessModifierFromModifiersToken(DetailAST ast) {
        DetailAST modsToken = ast.findFirstToken(5);
        AccessModifierOption accessModifier = CheckUtil.getAccessModifierFromModifiersTokenDirectly(modsToken);
        if (accessModifier == AccessModifierOption.PACKAGE) {
            if (ScopeUtil.isInEnumBlock(ast) && ast.getType() == 8) {
                accessModifier = AccessModifierOption.PRIVATE;
            } else if (ScopeUtil.isInInterfaceOrAnnotationBlock(ast)) {
                accessModifier = AccessModifierOption.PUBLIC;
            }
        }
        return accessModifier;
    }

    private static AccessModifierOption getAccessModifierFromModifiersTokenDirectly(DetailAST modifiersToken) {
        if (modifiersToken == null) {
            throw new IllegalArgumentException("expected non-null AST-token with type 'MODIFIERS'");
        }
        AccessModifierOption accessModifier = AccessModifierOption.PACKAGE;
        for (DetailAST token = modifiersToken.getFirstChild(); token != null; token = token.getNextSibling()) {
            int tokenType = token.getType();
            if (tokenType == 62) {
                accessModifier = AccessModifierOption.PUBLIC;
                continue;
            }
            if (tokenType == 63) {
                accessModifier = AccessModifierOption.PROTECTED;
                continue;
            }
            if (tokenType != 61) continue;
            accessModifier = AccessModifierOption.PRIVATE;
        }
        return accessModifier;
    }

    public static AccessModifierOption getSurroundingAccessModifier(DetailAST node) {
        AccessModifierOption returnValue = null;
        DetailAST token = node.getParent();
        while (returnValue == null && !TokenUtil.isRootNode(token)) {
            int type = token.getType();
            if (type == 14 || type == 15 || type == 157 || type == 154) {
                returnValue = CheckUtil.getAccessModifierFromModifiersToken(token);
            } else if (type == 136) break;
            token = token.getParent();
        }
        return returnValue;
    }

    public static Set<String> parseClassNames(String ... classNames) {
        return Arrays.stream(classNames).flatMap(className -> Stream.of(className, CommonUtil.baseClassName(className))).filter(Predicate.not(String::isEmpty)).collect(Collectors.toUnmodifiableSet());
    }

    public static String stripIndentAndInitialNewLineFromTextBlock(String textBlockContent) {
        String contentWithInitialNewLineRemoved = ALL_NEW_LINES.matcher(textBlockContent).replaceFirst("");
        List<String> lines = Arrays.asList(ALL_NEW_LINES.split(contentWithInitialNewLineRemoved));
        int indent = CheckUtil.getSmallestIndent(lines);
        String suffix = "";
        return lines.stream().map(line -> CheckUtil.stripIndentAndTrailingWhitespaceFromLine(line, indent)).collect(Collectors.joining(System.lineSeparator(), "", ""));
    }

    private static String stripIndentAndTrailingWhitespaceFromLine(String line, int indent) {
        int lastNonWhitespace = CheckUtil.lastIndexOfNonWhitespace(line);
        String returnString = "";
        if (lastNonWhitespace > 0) {
            returnString = line.substring(indent, lastNonWhitespace);
        }
        return returnString;
    }

    private static int getSmallestIndent(Collection<String> lines) {
        return lines.stream().mapToInt(CommonUtil::indexOfNonWhitespace).min().orElse(0);
    }

    private static int lastIndexOfNonWhitespace(String line) {
        int length;
        for (length = line.length(); length > 0 && Character.isWhitespace(line.charAt(length - 1)); --length) {
        }
        return length;
    }

    public static int typeDeclarationNameMatchingCount(String patternClass, String classToBeMatched) {
        int length = Math.min(classToBeMatched.length(), patternClass.length());
        int result = 0;
        for (int i = 0; i < length && patternClass.charAt(i) == classToBeMatched.charAt(i); ++i) {
            if (patternClass.charAt(i) != '.') continue;
            result = i;
        }
        return result;
    }

    public static String getQualifiedTypeDeclarationName(String packageName, String outerClassQualifiedName, String className) {
        Object qualifiedClassName = outerClassQualifiedName == null ? (packageName == null ? className : packageName + "." + className) : outerClassQualifiedName + "." + className;
        return qualifiedClassName;
    }

    public static String extractQualifiedName(DetailAST ast) {
        return FullIdent.createFullIdent(ast).getText();
    }

    public static String getShortNameOfAnonInnerClass(DetailAST literalNewAst) {
        DetailAST parentAst = literalNewAst.getParent();
        while (TokenUtil.isOfType(parentAst, 136, 59)) {
            parentAst = parentAst.getParent();
        }
        DetailAST firstChild = parentAst.getFirstChild();
        return CheckUtil.extractQualifiedName(firstChild);
    }

    public static boolean isPackageInfo(String filePath) {
        return "package-info.java".equals(new File(filePath).getName());
    }
}

