// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

package main

const nmConstsHeader = `
// Generated by nm-generator

package nm
`

const nmSettingBeansHeader = `
// Generated by nm-generator

package network

import (
)
`

const tplNMVirtualConsts = `
// Virtual section names
const ({{range .}}
	{{.VirtaulSectionName}} = "{{.Value}}"{{end}}
)

// Virtual key names
const ({{range .}}{{range .Keys}}{{if ne .VKeyInfo.VirtualKeyName ""}}
	{{.VKeyInfo.VirtualKeyName}} = "{{.KeyValue}}"{{end}}{{end}}{{end}}
)
`

const tplNMConsts = `
{{range .NMEnums}}
// Enum {{.EnumClass}}
const ({{range .Members}}
	{{.Name}} = {{UnwrapInterface .Value}}{{end}}
)
{{end}}

{{range .NMSettings}}
// Setting {{.SettingClass}}
const {{.Name}} = "{{.Value}}"
const ({{range .Keys}}
	{{.KeyName}} = "{{.Value}}"{{end}}
)
{{end}}
`

const tplNMBeans = `
// General get setting key default value
func generalGetSettingDefaultValue(setting, key string) (defvalue interface{}) {
	switch setting {
	default:
		logger.Error("invalid key:", setting, key){{range $i, $setting := .NMSettings}}
	case "{{$setting.Value}}":
		switch key {
		default:
			logger.Error("invalid key:", setting, key){{range .Keys}}
		case "{{.Value}}":
			defvalue = {{GetKeyDefaultValue .KeyName}}{{end}}
		}{{end}}
	}
	return
}

// Check is key exists{{range $i, $setting := .NMSettings}}{{range .Keys}}
func is{{.CapcaseName}}Exists(data connectionData) bool {
	return isSettingKeyExists(data, "{{$setting.Value}}", "{{.Value}}")
}{{end}}{{end}}

// Getter{{range $i, $setting := .NMSettings}}{{range .Keys}}
func get{{.CapcaseName}}(data connectionData) (value {{GetKeyTypeGoSyntax .Type}}) {
	ivalue := getSettingKey(data, "{{$setting.Value}}", "{{.Value}}")
	value = {{GetKeyTypeGoIfcConverterFunc .Type}}(ivalue)
	return
}{{end}}{{end}}

// Setter{{range $i, $setting := .NMSettings}}{{range .Keys}}
func set{{.CapcaseName}}(data connectionData, value {{GetKeyTypeGoSyntax .Type}}) {
	setSettingKey(data, "{{$setting.Value}}", "{{.Value}}", value)
}{{end}}{{end}}

// Remover{{range $i, $setting := .NMSettings}}{{range .Keys}}
func remove{{.CapcaseName}}(data connectionData) {
	removeSettingKey(data, "{{$setting.Value}}", "{{.Value}}")
}{{end}}{{end}}
`
