/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockResponse;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.OutboundRule;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedResponse;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class OutboundRuleTest
extends TestCase {
    MockResponse response;
    MockRequest request;

    public void setUp() {
        Log.setLevel("DEBUG");
        this.response = new MockResponse();
        this.request = new MockRequest();
    }

    public void testOutboundQueryStr() {
        Conf conf = new Conf();
        OutboundRule rule1 = new OutboundRule();
        rule1.setFrom("^/jsp-examples/cal/links.jsp\\?id=([0-9]+)");
        rule1.setTo("/jsp-examples/cal/links/$1");
        conf.addOutboundRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/jsp-examples/cal/links.jsp?id=46");
        UrlRewriteWrappedResponse urlRewriteWrappedResponse = new UrlRewriteWrappedResponse(this.response, request, urlRewriter);
        OutboundRuleTest.assertEquals((String)"/jsp-examples/cal/links/46;mockencoded=test", (String)urlRewriteWrappedResponse.encodeURL("/jsp-examples/cal/links.jsp?id=46"));
    }

    public void testOutbound2() {
        UrlRewriteWrappedResponse urlRewriteWrappedResponse2 = new UrlRewriteWrappedResponse(this.response, this.request, null);
        OutboundRuleTest.assertEquals((String)"a.jsp;mockencoded=test?aaa=bbb", (String)urlRewriteWrappedResponse2.encodeURL("a.jsp?aaa=bbb"));
        Conf conf = new Conf();
        OutboundRule rule1 = new OutboundRule();
        rule1.setFrom("^(.*);mockencoded=.*?(\\?.*)?$");
        rule1.setTo("$1$2");
        rule1.setEncodeFirst(true);
        conf.addOutboundRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        UrlRewriteWrappedResponse urlRewriteWrappedResponse = new UrlRewriteWrappedResponse(this.response, this.request, urlRewriter);
        OutboundRuleTest.assertEquals((String)"a.jsp?aaa=bbb", (String)urlRewriteWrappedResponse.encodeURL("a.jsp?aaa=bbb"));
        OutboundRuleTest.assertEquals((String)"a.jsp", (String)urlRewriteWrappedResponse.encodeURL("a.jsp"));
    }

    public void testOutboundJsess() {
        UrlRewriteWrappedResponse urlRewriteWrappedResponse2 = new UrlRewriteWrappedResponse(this.response, this.request, null);
        OutboundRuleTest.assertEquals((String)"/boo.jsp;mockencoded=test?somethingloi=1", (String)urlRewriteWrappedResponse2.encodeURL("/boo.jsp?somethingloi=1"));
        OutboundRuleTest.assertEquals((String)"/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0;mockencoded=test?somethingloi=1", (String)urlRewriteWrappedResponse2.encodeURL("/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0?somethingloi=1"));
        OutboundRuleTest.assertEquals((String)"http://localhost:8080/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0?somethingloi=1", (String)urlRewriteWrappedResponse2.encodeURL("http://localhost:8080/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0?somethingloi=1"));
        Conf conf = new Conf();
        OutboundRule rule1 = new OutboundRule();
        rule1.setFrom("^(?![a-z]+:)(.*);jsessionid=.*?([\\?|\\#].*)?$");
        rule1.setTo("$1$2");
        rule1.setEncodeFirst(true);
        conf.addOutboundRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        UrlRewriteWrappedResponse urlRewriteWrappedResponse = new UrlRewriteWrappedResponse(this.response, this.request, urlRewriter);
        OutboundRuleTest.assertEquals((String)"/boo.jsp;mockencoded=test", (String)urlRewriteWrappedResponse.encodeURL("/boo.jsp"));
        OutboundRuleTest.assertEquals((String)"/boo.jsp;mockencoded=test?somethingloi=1", (String)urlRewriteWrappedResponse.encodeURL("/boo.jsp?somethingloi=1"));
        OutboundRuleTest.assertEquals((String)"/boo.jsp?somethingloi=1", (String)urlRewriteWrappedResponse.encodeURL("/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0?somethingloi=1"));
        OutboundRuleTest.assertEquals((String)"http://localhost:8080/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0?somethingloi=1", (String)urlRewriteWrappedResponse.encodeURL("http://localhost:8080/boo.jsp;jsessionid=91C4977F91B3CF69D2085B1B42BD5EB0?somethingloi=1"));
    }
}

