
{{v0X.crowdsec.name}} configuration lives under `{{v0X.config.crowdsec_dir}}` and should be as :

## default.yaml

This is the 'main' configuration file, it allows to specify parameters such as :

 - logging (level and media)
 - directories (config, data, runtime)
 - API flag (on/off)
 - prometheus (on/off)
 - etc.

 <details>
  <summary>Default configuration</summary>
```yaml 
working_dir: /tmp/
data_dir: /var/lib/crowdsec/data
config_dir: /etc/crowdsec/config
pid_dir: /var/run
log_dir: /var/log/
log_mode: file
log_level: info
profiling: false
apimode: true
daemon: true
prometheus: true
#for prometheus agent / golang debugging
http_listen: 127.0.0.1:6060
plugin:
  backend: "/etc/crowdsec/plugins/backend"
```
</details>

#### `working_dir:`
The working directory where Prometheus will write metrics in text file.

#### `data_dir:`
Directory where {{v0X.crowdsec.Name}} will install its data ({{v0X.crowdsec.Name}} database for example).

#### `pid_dir:`
To specify where {{v0X.crowdsec.Name}} PID file will be stored.

#### `config_dir:`
To specify where {{v0X.crowdsec.Name}} configuration will be stored.

#### `log_dir:`
To specify where the logs should be stored.

#### `log_mode:`
To specify your selected logging mode, available modes are :

* `file` : to write logs in a file
* `stdout` : to write logs in STDOUT

#### `log_level:`
To specify the logging level, available levels:

* `debug`
* `info`
* `warning`
* `error`

#### `profiling:`
To enable or disable the profiling in {{v0X.crowdsec.Name}}.

#### `apimode:`
To enable or disable signals sending to the {{v0X.api.htmlname}}.

#### `daemon:`
To enable or disable {{v0X.crowdsec.Name}} daemon mode.

#### `prometheus:`
To enable or disable Prometheus metrics.

### `prometheus_mode:`
If `prometheus` is enabled, and is set to `aggregated`, will restrict prometheus metrics to global ones. All metrics containing a source as a label will be unregistered. Meant to keep cardinality low when relevant.

#### `http_listen:`
To configure the Prometheus service listening `address:port` or {{v0X.crowdsec.Name}} profiling

#### `plugin:`
To specify the directories where {{v0X.ref.output}} plugins will be stored :
* `backend:` : the path where all {{v0X.crowdsec.Name}} backend plugins (database output, ...) will be located.

## acquis.yaml

This is the file that tells which streams (or files) {{v0X.crowdsec.name}} is reading, and their types (so that it knows how to parse them). If you're lucky, this file should be auto-generated by the wizard.

You can find details on the configuration file format [here](/Crowdsec/v0/guide/crowdsec/acquisition/).


## api.yaml

Name is self-explanatory : it holds API configuration.

This file should never be edited by a human : the wizard will deploy safe default for it, and {{v0X.cli.name}} will alter it on your behalf when you register or enroll your machine.

You can look into it, and you should see :

 - url endpoints
 - login and password (auto-generated by your machine upon registration)

To get new credentials :
```bash
{{v0X.cli.name}} api register
```
Or if you loose your credentials:
```bash
{{v0X.cli.name}} api reset
```


## profiles.yaml

The profiles is what allows you to decide how do you react when a scenario is triggered :

 - do you notify yourself on mattermost/slack ?
 - do you push the signal to a database so that your bouncers can stop the IP from continuing its attack ?
 - do you want to avoid pushing this signal to the API ?

Behind the scenes, the "profiles" system actually allows you to dispatch an event/overflow to various output plugins.

You can find details on the configuration file format of {{v0X.ref.output}}.

## parsers/

This directory holds all the {{v0X.parsers.htmlname}} that are enabled on your system.

The parsers are organized in {{v0X.stage.htmlname}} (which are just folders) and the {{v0X.parsers.htmlname}} themselves are yaml files.


## scenarios/

This directory holds all the {{v0X.scenarios.htmlname}} that are enabled on your system.

The {{v0X.scenarios.htmlname}} are yaml files.





