/*
 * Copyright (c) [2019] SUSE LLC
 *
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail, you may
 * find current contact information at www.novell.com.
 */

#include <vector>

#include "client/Command/ListConfigs/SnappersData/Csv.h"
#include "client/Command/ListConfigs/Options.h"
#include "client/utils/CsvFormatter.h"

using namespace std;

namespace snapper
{
    namespace cli
    {

	Command::ListConfigs::SnappersData::Csv::Csv(
	    const Command::ListConfigs& command, const string separator) :
	   SnappersData(command), _separator(separator)
	{}


	std::string Command::ListConfigs::SnappersData::Csv::output() const
	{
	    vector<string> columns;

	    vector<vector<string>> rows;

	    for (const string& column : _command.options().columns())
		columns.push_back(column);

	    for (ProxySnapper* snapper : snappers())
	    {
		vector<string> row;

		for (const string& column : _command.options().columns())
		    row.push_back(value_for(column, snapper));

		rows.push_back(row);
	    }

	    CsvFormatter formatter(columns, rows, _separator);

	    return formatter.str();
	}

    }
}
