/*
 * Copyright (c) 2004 Michael Schroeder (mls@suse.de)
 *
 * This program is licensed under the BSD license, read LICENSE.BSD
 * for further information
 */

#include "util.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/****************************************************************
 *
 * utility functions
 *
 */

void *
xmalloc(int len)
{
  void *r = malloc(len ? len : 1);
  if (r)
    return r;
  fprintf(stderr, "Out of memory allocating %d bytes!\n", len);
  exit(1);
}

void *
xrealloc(void *old, int len)
{
  if (old == 0)
    old = malloc(len ? len : 1);
  else
    old = realloc(old, len ? len : 1);
  if (old)
    return old;
  fprintf(stderr, "Out of memory reallocating %d bytes!\n", len);
  exit(1);
}


void *
xcalloc(int num, int len)
{
  void *r = calloc(num, len);
  if (r)
    return r;
  fprintf(stderr, "Out of memory allocating %d bytes!\n", num * len);
  exit(1);
}

void *
xfree(void *mem)
{
  if (mem)
    free(mem);
  return 0;
}

int
parsehex(char *s, unsigned char *hex, int len)
{
  int i, r = 0;

  len *= 2;
  for (i = 0; ; i++, s++)
    {
      if (*s == 0 && !(i & 1))
	return i / 2;
      if (i == len)
	{
	  fprintf(stderr, "parsehex: string too long\n");
	  exit(1);
	}
      if (*s >= '0' && *s <= '9')
	r = (r << 4) | (*s - '0');
      else if (*s >= 'a' && *s <= 'f')
	r = (r << 4) | (*s - ('a' - 10));
      else if (*s >= 'A' && *s <= 'F')
	r = (r << 4) | (*s - ('a' - 10));
      else
	{
	  fprintf(stderr, "parsehex: bad string\n");
	  exit(1);
	}
      if ((i & 1) != 0)
	{
	  hex[i / 2] = r;
	  r = 0;
	}
    }
}

void
parsemd5(char *s, unsigned char *md5)
{
  if (!*s)
    {
      memset(md5, 0, 16);
      return;
    }
  if (parsehex(s, md5, 16) != 16)
    {
      fprintf(stderr, "parsemd5: bad md5\n");
      exit(1);
    }
}
