/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#ifndef _typedefs_h
#define _typedefs_h
#define MAXNAMELEN 20
#define MAXPATHLEN 100
#define MAXSCRIPTS 200
#define NAMELEN 7

typedef struct
{
  int brl, kbd;
} brlkbd;

/* entries of $SBLDIR/keymap/ */
typedef struct
{
  brlkbd resetbrl, line01, topleft, botleft;
  brlkbd winup, windn, lnlft, lnrgt;
  brlkbd lnup, lndn, csrtrk, syscsr, softcsr;
  brlkbd chrlft, chrrgt, hwinlft, hwinrgt, fwinlft;
  brlkbd fwinrgt, csrjump, csrjmpvert, keyup;
  brlkbd keydn, keyrgt, keylft, keyenter, keyesc, csrvisoff;
  brlkbd jmpmark1, jmpmark2, jmpmark3, jmpmark4;
  brlkbd attr1, attr2, attr3, attr4;
  brlkbd csrtrkoff, prof1, prof2, prof3, prof4;
  brlkbd attroff, attrmodonoff, sixdotsonoff, csrblinkonoff;
  brlkbd csrblockonoff, cutbegin, cutend, paste;
  brlkbd spktocsr, spkfromcsr;
  brlkbd spkmod, spkoff;
  brlkbd spkcurln, spkscrtocsr, spkscrfromcsr;
  brlkbd nextlang, prevlang;
  brlkbd nextfrq, prevfrq;
  brlkbd nextspd, prevspd;
  brlkbd nextvol, prevvol;
  brlkbd nextvoice, prevvoice;
  brlkbd nextspec, prevspec;
  brlkbd spkcharmod;
  brlkbd kbdsniffon1, kbdsniffon2, kbdsniffoff;
  brlkbd soundonoff, loadkeymap, autoprofonoff;
  brlkbd setmark, jmptomark;
  int lineroutend, lineroutbeg, csrroutend, csrroutbeg;
  brlkbd scripts[MAXSCRIPTS];
  char scriptnames[MAXSCRIPTS][MAXNAMELEN];
}
keymap_file;

/* entries of /etc/suse-blinux.conf */
typedef struct
{
  char brlname[MAXNAMELEN];
  char brlport[MAXNAMELEN];
  char spkname[MAXNAMELEN];
  char spkport[MAXNAMELEN];
  char brld_auth_key[MAXNAMELEN];
  char brld_host[MAXNAMELEN];
  int brld_port;
  int repeatdelay, profdelay, sleep;
  int debug;
  char profile1[MAXNAMELEN];
  char profile2[MAXNAMELEN];
  char profile3[MAXNAMELEN];
  char profile4[MAXNAMELEN];
  char progpath[MAXPATHLEN];
} sbl_config;

typedef struct
{
  unsigned char mask;
  unsigned char val;
} mask;
typedef struct
{
  short x1, x2, y1, y2;
} range;

typedef struct
{
  short csrtrk, dispmode;
  short winx, winy;
  short cox, coy;
} brltty_param;

/* $sbldir/profile/ */
typedef struct
{
  short magicnum;
  char profname[40];
  short csrvis;
  short csrmode;
  short csrblink;
  short csrsize;
  short csroncnt;
  short csroffcnt;
  mask softcsr1, softcsr2, softcsr3, softcsr4;
  short attrvis;
  short attrnr;
  mask attr1, attr2, attr3, attr4;
  short sixdots;
  short slidewin;
  short sound;
  short vertdispmode;
  short stcellstyle;
  short mark1, mark2, mark3, mark4;
  range limitcsr1, limitcsr2, syscsrlimit;
  short spkvolume, spkfrq, spkspd, spkvoice, spklang, spkspec;
  short spkmod;
  short spkcharmod;
}
param_file;

/* entries of $SBLDIR/spk/ */
typedef struct
{
  int baud;
  char start[50], stop[50];
  char init[50], indexstart[50], indexsend[50], indexaltsend[50];
  char indexreceive[50];
  char language[9][50];
  char voice[9][50];
  char special[9][50];
  char frequency[9][50];
  char volume[9][50];
  char speed[9][50];
  char filter[9][50];
}
spk_file;

#endif
