/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#ifndef _profstruct_h
#define _profstruct_h
char home[120] = "";

struct mask
{
  unsigned char mask;
  unsigned char val;
};
struct range
{
  short x1, x2, y1, y2;
};
struct brltty_param
{
  short csrtrk, dispmode;
  short winx, winy;
  short cox, coy;
};

struct brltty_env
{
  short magicnum;
  char profname[40];
  short csrvis;
  short csrmode;
  short csrblink;
  short csrsize;
  short csroncnt;
  short csroffcnt;
  struct mask softcsr1, softcsr2, softcsr3, softcsr4;
  short attrvis;
  short attrnr;
  struct mask attr1, attr2, attr3, attr4;
  short sixdots;
  short slidewin;
  short sound;
  short vertdispmode;
  short stcellstyle;
  short mark1, mark2, mark3, mark4;
  struct range limitcsr1, limitcsr2, syscsrlimit;
  short spkvolume, spkfrq, spkspd, spkvoice, spklang, spkspec;
  short spkmod;
  short spkcharmod;
}
__brlstruct__;
#endif
