#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>

#include "mbrola.h"
#include "sbllog.h"
extern spk_file spkctrl;
static lang_t *tmp[9];
static int lang_n = -1;
static char *lookup_string (void *context, const char *name);

void mbrola_param (char *param)
{
/* dummy */
  if (param)
    return;
}

void mbrola_start ()
{
  return;
}

void mbrola_stop ()
{
  if (current_lang == NULL)
    return;
  current_lang->speak_string (current_lang, (unsigned char *) "\1\n");
  current_lang->synth->flush (current_lang->synth);
  current_lang->synth->clear (current_lang->synth);
}

void mbrola_lang (int lang)
{
  lang_t *tmp;

/* mbrola_close(); */
/* current_lang=tmp[lang]; */
  if (lang_n != lang)
   {
     tmp = language_open (spkctrl.language[lang], lookup_string);
     if (current_lang != NULL)
       current_lang->close (current_lang);
     if (current_lang == NULL)
       sbl_log ("mbrola: change language to %i - closing old language\n",
		lang);

     current_lang = tmp;
     lang_n = lang;
     current_lang->set_param (current_lang, L_SPEAK_PUNCTUATION, 0);
   }

  return;
/* current_lang=tmp[0]; */
/*    current_lang = language_open (lang, lookup_string);*/
}

void mbrola_voice (char *voice)
{
/* dummy */
  if (voice)
    return;
}

void mbrola_spec (char *spec)
{

/* dummy */
  if (spec)
    return;
}

void mbrola_frq (char *frq)
{
  if (current_lang == NULL)
    return;
  current_lang->synth->set_param (current_lang->synth, S_PITCH, atoi (frq));
}
void mbrola_vol (char *vol)
{
  if (current_lang == NULL)
    return;
  current_lang->synth->set_param (current_lang->synth, S_VOLUME, atoi (vol));
}
void mbrola_spd (char *spd)
{

  if (current_lang == NULL)
    return;
  current_lang->synth->set_param (current_lang->synth, S_SPEED, atoi (spd));
}

void mbrola_init ()
{
  int i;

  return;
  for (i = 0; i < 9; i++)
   {
     printf ("langstr %s \n", spkctrl.language[i]);
     if (spkctrl.language[i][0] == 0)
       break;
     tmp[i] = language_open (spkctrl.language[i], lookup_string);
     if (tmp[i] == NULL)
       break;
   }
  return;

}

void mbrola_say (char *spkstr)
{
  char tempstr[400];
  int i;

  if (current_lang == NULL)
    return;
  if (strlen (spkstr) > 200)
   {
     int j = 0, last = 0;

     for (i = 0; spkstr[i] != '\0'; i++)
      {
	int emptyi = 0;

	j++;

	if ((spkstr[i] == ' ' && j > 100) || spkstr[i] == 13)
	 {

	   strncpy (tempstr, spkstr + last, j);
	   tempstr[j] = 0;
/*   for (; tempstr[emptyi] != '\0'; emptyi++)
	    {
	      if (tempstr[emptyi] == 13)
	       {
		 tempstr[emptyi] = ' ';
	       }

	      if (tempstr[emptyi] != ' ')
		break;
	    }			for */

	   if (tempstr[emptyi] == '\0')
	    {
	      j = 0;
	      last = i;
	      tempstr[0] = 0;
	      continue;
	    }
	   current_lang->speak_string (current_lang,
				       (unsigned char *) tempstr);
	   current_lang->synth->flush (current_lang->synth);
	   usleep (100);
	   j = 0;
	   last = i;
	   tempstr[0] = 0;

	 }			/* if */

      }				/* for */
     if (last < i)
      {
	current_lang->speak_string (current_lang,
				    (unsigned char *) spkstr + last);
	current_lang->synth->flush (current_lang->synth);
      }				/* if */

   }				/* if */
  else
   {
     current_lang->speak_string (current_lang, (unsigned char *) spkstr);
     current_lang->synth->flush (current_lang->synth);

   }				/* else */

}

void mbrola_close ()
{
/* lang_eng->close(lang_eng); */
  if (current_lang != NULL)
    current_lang->close (current_lang);
}
static char *lookup_string (void *context, const char *name)
{
  char *c = context;
  char *result = NULL;

  if (!strcmp (c, "de1"))
   {
     if (!strcmp (name, "language"))
      {
	result = "german";
      }
     else if (!strcmp (name, "library"))
      {

	static char libpath[100];

	sbl_log ("speech lib ");
	sprintf (libpath, "%s/lib/softspeech.so", PROGPATH);
	result = libpath;
      }
     else if (!strcmp (name, "phoneme_generator_directory"))
      {
	sbl_log ("phoneme dir ");
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "phoneme_generator_command"))
      {
	result = "./txt2pho -p ./data/ -f";
      }
     else if (!strcmp (name, "synthesizer_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "synthesizer_command"))
      {
	result = "./mbrola -e ./voices/de1 - -";
      }
     else if (!strcmp (name, "samples_per_second"))
      {
	result = "16000";
      }
     else
      {
	result = NULL;
      }
   }				/* if german1 */
  else if (!strcmp (c, "de2"))
   {
     if (!strcmp (name, "language"))
      {
	result = "german";
      }
     else if (!strcmp (name, "library"))
      {
	static char libpath[100];

	sprintf (libpath, "%s/lib/softspeech.so", PROGPATH);
	result = libpath;
      }
     else if (!strcmp (name, "phoneme_generator_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "phoneme_generator_command"))
      {
	result = "./txt2pho -p ./data/ -m";
      }
     else if (!strcmp (name, "synthesizer_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "synthesizer_command"))
      {
	result = "./mbrola -e ./voices/de2 - -";
      }
     else if (!strcmp (name, "samples_per_second"))
      {
	result = "16000";
      }
     else
      {
	result = NULL;
      }
   }				/* if german2 */
  else if (!strcmp (c, "de3"))
   {
     if (!strcmp (name, "language"))
      {
	result = "german";
      }
     else if (!strcmp (name, "library"))
      {
	static char libpath[100];

	sprintf (libpath, "%s/lib/softspeech.so", PROGPATH);
	result = libpath;
      }
     else if (!strcmp (name, "phoneme_generator_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "phoneme_generator_command"))
      {
	result = "./txt2pho -p ./data/ -f";
      }
     else if (!strcmp (name, "synthesizer_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "synthesizer_command"))
      {
	result = "./mbrola -e ./voices/de3 - -";
      }
     else if (!strcmp (name, "samples_per_second"))
      {
	result = "22050";
      }
     else
      {
	result = NULL;
      }
   }				/* if german3 */
  else if (!strcmp (c, "mbrdico_en1"))
   {
     if (!strcmp (name, "language"))
      {
	result = "english";
      }
     else if (!strcmp (name, "library"))
      {
	static char libpath[100];

	sprintf (libpath, "%s/lib/softspeech.so", PROGPATH);
	result = libpath;
      }
     else if (!strcmp (name, "phoneme_generator_directory"))
      {
	result = "/usr/lib/mbrola4sbl/mbrdico";
      }
     else if (!strcmp (name, "phoneme_generator_command"))
      {
	result = "./sbl_mbrdico en1";
      }
     else if (!strcmp (name, "synthesizer_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "synthesizer_command"))
      {
	result = "./mbrola -e voices/en1 - -";
      }
     else if (!strcmp (name, "samples_per_second"))
      {
	result = "16000";
      }
     else
      {
	result = NULL;
      }

   }
  else if (!strcmp (c, "mbrdico_us2"))
   {
     if (!strcmp (name, "language"))
      {
	result = "us";
      }
     else if (!strcmp (name, "library"))
      {
	static char libpath[100];

	sprintf (libpath, "%s/lib/softspeech.so", PROGPATH);
	result = libpath;
      }
     else if (!strcmp (name, "phoneme_generator_directory"))
      {
	result = "/usr/lib/mbrola4sbl/mbrdico";
      }
     else if (!strcmp (name, "phoneme_generator_command"))
      {
	result = "./sbl_mbrdico us2";
      }
     else if (!strcmp (name, "synthesizer_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "synthesizer_command"))
      {
	result = "./mbrola -e voices/us2 - -";
      }
     else if (!strcmp (name, "samples_per_second"))
      {
	result = "16000";
      }

     else
      {
	result = NULL;
      }
   }
  else if (!strcmp (c, "mbrdico_fr3"))
   {
     if (!strcmp (name, "language"))
      {
	result = "french";
      }
     else if (!strcmp (name, "library"))
      {
	static char libpath[100];

	sprintf (libpath, "%s/lib/softspeech.so", PROGPATH);
	result = libpath;
      }
     else if (!strcmp (name, "phoneme_generator_directory"))
      {
	result = "/usr/lib/mbrola4sbl/mbrdico";
      }
     else if (!strcmp (name, "phoneme_generator_command"))
      {
	result = "./sbl_mbrdico fr3";
      }
     else if (!strcmp (name, "synthesizer_directory"))
      {
	result = "/usr/lib/mbrola4sbl";
      }
     else if (!strcmp (name, "synthesizer_command"))
      {
	result = "./mbrola -e voices/fr3 - -";
      }
     else if (!strcmp (name, "samples_per_second"))
      {
	result = "16000";
      }
     else
      {
	result = NULL;
      }

   }
  else
   {
     result = NULL;
   }

  sbl_log ("lookup %s ", result);
  return result;
}
void mbrola_punctuation (int on)
{
  current_lang->set_param (current_lang, L_SPEAK_PUNCTUATION, on);
}
