/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#include <pwd.h>
#include <stdio.h>
#include <utmp.h>

char *getuser (char *, int);
char *gethome (char *, int);
char *gethome (char *home, int console)
{
  struct passwd *user;

  getuser (home, console);
  if (!strcmp (home, "none"))
   {
     home[0] = 0;
     return home;
   }
  user = getpwnam (home);
  if (user)
    return strcpy (home, user->pw_dir);
  else
    return strcpy (home, "");
}

char *getuser (char *str, int console)
{

  struct utmp *user;
  char dev[30] = "";

  sprintf (dev, "tty%i", console);

  while ((user = getutent ()))
    if (!strcmp (dev, user->ut_line))
     {
       endutent ();
       return strcpy (str, user->ut_user);
     }

  endutent ();
  return strcpy (str, "none");
}
