#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/termios.h>
#include <string.h>
#define DefDev "/dev/ttyS1"
#define BAUDRATE B9600
#define IDLEN 5
#define BRL_ID "\033ID="
#define WAIT_DTR 900000
#define WAIT_FLUSH 20000

int brl_fd;
char dev[50] = "";
void main ()
{
  int id = 0;
  struct termios newtio, oldtio;	/* new terminal settings */
  unsigned char buffer[IDLEN];

  /* Open the Braille display device for random access */
  if (!strlen (dev))
    strcpy (dev, DefDev);
  brl_fd = open (dev, O_RDWR | O_NOCTTY);
  tcgetattr (brl_fd, &oldtio);	/* save current settings */

  /* Set flow control and 8n1, enable reading */
  newtio.c_cflag = CRTSCTS | CS8 | CLOCAL | CREAD;

  /* Ignore bytes with parity errors and make terminal raw and dumb */
  newtio.c_iflag = IGNPAR;
  newtio.c_oflag = 0;		/* raw output */
  newtio.c_lflag = 0;		/* don't echo or generate signals */
  newtio.c_cc[VMIN] = 0;	/* set nonblocking read */
  newtio.c_cc[VTIME] = 0;

  /* autodetecting ABT model */
  /* to force DTR off */
  cfsetispeed (&newtio, B0);
  cfsetospeed (&newtio, B0);
  tcsetattr (brl_fd, TCSANOW, &newtio);	/* activate new settings */
  usleep (WAIT_DTR);

  tcflush (brl_fd, TCIOFLUSH);	/* clean line */
  usleep (WAIT_FLUSH);

  /* DTR back on */
  cfsetispeed (&newtio, BAUDRATE);
  cfsetospeed (&newtio, BAUDRATE);
  tcsetattr (brl_fd, TCSANOW, &newtio);	/* activate new settings */
  usleep (WAIT_DTR);		/* give time to send ID string */

  if (read (brl_fd, buffer, IDLEN) == IDLEN)
   {
     if (!strncmp ((char *) buffer, BRL_ID, strlen (BRL_ID)))
       /* Find out which model we are connected to... */
       switch (buffer[4])
	{
	case 1:
	  printf ("abt340\n");
	  break;
	case 2:
	  printf ("abt34d\n");
	  break;
	case 3:
	  printf ("abt380\n");
	  break;
	case 4:
	  printf ("abt38d\n");
	  break;
	case 11:
	  printf ("del440\n");
	  break;
	case 13:
	  printf ("del480\n");
	  break;
	case 14:
	  printf ("sat540\n");
	  break;
	default:
	  printf ("id=%i not known\n", id);
	}			/* switch */

   }				/* if read */

  close (brl_fd);
}
